/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.ic2;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.thirdparty.ic2.IC2;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityPneumaticGenerator
extends TileEntityPneumaticBase
implements IEnergySource,
IWrenchable,
IRedstoneControlled,
IHeatExchanger {
    public boolean outputting;
    @GuiSynced
    public int curEnergyProduction;
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @GuiSynced
    public int redstoneMode = 0;

    public TileEntityPneumaticGenerator() {
        super(20.0f, 25.0f, 10000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.outputting) {
                this.outputting = false;
            } else {
                this.curEnergyProduction = 0;
            }
        }
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    public void func_145843_s() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        super.onChunkUnload();
    }

    @Override
    public boolean redstoneAllows() {
        switch (this.redstoneMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.func_145831_w().func_175687_A(this.func_174877_v()) > 0;
            }
            case 2: {
                return this.func_145831_w().func_175687_A(this.func_174877_v()) == 0;
            }
        }
        return false;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return this.getRotation() == side.func_176734_d();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public String getName() {
        return IC2.PNEUMATIC_GENERATOR.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
        this.outputting = nbtTagCompound.func_74767_n("outputting");
        this.curEnergyProduction = nbtTagCompound.func_74762_e("energyProduction");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        nbtTagCompound.func_74757_a("outputting", this.outputting);
        nbtTagCompound.func_74768_a("energyProduction", this.curEnergyProduction);
        return nbtTagCompound;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        return enumFacing == this.getRotation();
    }

    public double getOfferedEnergy() {
        return this.getPressure() > 15.0f && this.redstoneAllows() ? (double)this.getEnergyPacketSize() : 0.0;
    }

    public int getEnergyPacketSize() {
        int upgradesInserted = this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED);
        int energyAmount = 32 * (int)Math.pow(4.0, Math.min(3, upgradesInserted));
        return energyAmount * this.getEfficiency() / 100;
    }

    public void drawEnergy(double amount) {
        int efficiency = ConfigHandler.machineProperties.pneumaticGeneratorEfficiency;
        if (efficiency < 1) {
            efficiency = 1;
        }
        int airUsage = (int)(amount / 0.25 * 100.0 / (double)efficiency);
        this.addAir(-airUsage);
        this.heatExchanger.addHeat((double)airUsage / 40.0);
        this.outputting = true;
        this.curEnergyProduction = (int)amount;
    }

    public int getSourceTier() {
        return 1 + this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED);
    }

    public EnumFacing getFacing(World world, BlockPos blockPos) {
        return this.getRotation();
    }

    public boolean setFacing(World world, BlockPos blockPos, EnumFacing enumFacing, EntityPlayer entityPlayer) {
        return false;
    }

    public boolean wrenchCanRemove(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        return true;
    }

    public List<ItemStack> getWrenchDrops(World world, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, EntityPlayer entityPlayer, int i) {
        return Collections.singletonList(new ItemStack(IC2.PNEUMATIC_GENERATOR));
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.heatExchanger;
    }
}

