/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.ic2;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.thirdparty.ic2.BlockElectricCompressor;
import me.desht.pneumaticcraft.common.thirdparty.ic2.IC2;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityElectricCompressor
extends TileEntityPneumaticBase
implements IEnergySink,
IWrenchable,
IRedstoneControlled,
IHeatExchanger {
    private int outputTimer;
    private boolean redstoneAllows;
    @GuiSynced
    public int redstoneMode = 0;
    private int curEnergyProduction;
    @GuiSynced
    public int lastEnergyProduction;
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    public float turbineRotation;
    public float oldTurbineRotation;
    public float turbineSpeed;

    public TileEntityElectricCompressor() {
        super(20.0f, 25.0f, 10000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
        this.addApplicableCustomUpgrade(IC2.overclockerUpgrade, IC2.energyStorageUpgrade, IC2.transformerUpgrade);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void func_73660_a() {
        this.redstoneAllows = this.redstoneAllows();
        this.oldTurbineRotation = this.turbineRotation;
        this.turbineSpeed = this.outputTimer > 0 ? Math.min(this.turbineSpeed + 0.2f, 10.0f) : Math.max(this.turbineSpeed - 0.2f, 0.0f);
        this.turbineRotation += this.turbineSpeed;
        if (!this.func_145831_w().field_72995_K) {
            this.lastEnergyProduction = this.curEnergyProduction;
            this.curEnergyProduction = 0;
        }
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            --this.outputTimer;
            if (this.outputTimer == 0) {
                this.sendDescriptionPacket();
            }
        }
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    public void func_145843_s() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        super.onChunkUnload();
    }

    @Override
    public boolean redstoneAllows() {
        switch (this.redstoneMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.func_145831_w().func_175687_A(this.func_174877_v()) > 0;
            }
            case 2: {
                return this.func_145831_w().func_175687_A(this.func_174877_v()) == 0;
            }
        }
        return false;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side == this.getRotation() || side == this.getRotation().func_176734_d();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public String getName() {
        return IC2.ELECTRIC_COMPRESSOR.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
        this.outputTimer = nbtTagCompound.func_74767_n("outputTimer") ? 20 : 0;
        this.turbineSpeed = nbtTagCompound.func_74760_g("turbineSpeed");
        this.lastEnergyProduction = nbtTagCompound.func_74762_e("energyProduction");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        nbtTagCompound.func_74757_a("outputTimer", this.outputTimer > 0);
        nbtTagCompound.func_74776_a("turbineSpeed", this.turbineSpeed);
        nbtTagCompound.func_74768_a("energyProduction", this.lastEnergyProduction);
        return nbtTagCompound;
    }

    public double getDemandedEnergy() {
        return this.redstoneAllows ? Double.MAX_VALUE : 0.0;
    }

    public int getSinkTier() {
        int upgradesInserted = this.getCustomUpgrades(IC2.transformerUpgrade);
        return 1 + upgradesInserted;
    }

    int getMaxSafeInput() {
        int upgradesInserted = this.getCustomUpgrades(IC2.transformerUpgrade);
        return 32 * (int)Math.pow(4.0, upgradesInserted);
    }

    public double injectEnergy(EnumFacing enumFacing, double amount, double voltage) {
        int efficiency = ConfigHandler.machineProperties.electricCompressorEfficiency;
        int airProduction = (int)(amount / 0.25 * (double)efficiency / 100.0 * (double)this.getEfficiency() / 100.0);
        this.heatExchanger.addHeat(amount / 16.0);
        this.addAir(airProduction);
        this.curEnergyProduction += airProduction;
        boolean clientNeedsUpdate = this.outputTimer <= 0;
        this.outputTimer = 20;
        if (clientNeedsUpdate) {
            this.sendDescriptionPacket();
        }
        return 0.0;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return enumFacing == EnumFacing.UP;
    }

    public EnumFacing getFacing(World world, BlockPos blockPos) {
        return this.getRotation();
    }

    public boolean setFacing(World world, BlockPos blockPos, EnumFacing enumFacing, EntityPlayer entityPlayer) {
        Block b = this.func_145838_q();
        if (b instanceof BlockElectricCompressor) {
            ((BlockElectricCompressor)b).rotateBlock(world, entityPlayer, blockPos, enumFacing, EnumHand.MAIN_HAND);
            return true;
        }
        return false;
    }

    public boolean wrenchCanRemove(World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        return true;
    }

    public List<ItemStack> getWrenchDrops(World world, BlockPos blockPos, IBlockState iBlockState, TileEntity tileEntity, EntityPlayer entityPlayer, int i) {
        return Collections.singletonList(new ItemStack(IC2.ELECTRIC_COMPRESSOR));
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.heatExchanger;
    }
}

