/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computercraft;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemProgrammingPuzzle;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetString;
import me.desht.pneumaticcraft.common.progwidgets.WidgetRegistrator;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.DroneAICC;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ILuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ProgWidgetCC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityDroneInterface
extends TileEntity
implements ITickable,
IPeripheral,
ManagedPeripheral,
SimpleComponent {
    private LuaMethodRegistry luaMethodRegistry;
    private final CopyOnWriteArrayList<IComputerAccess> attachedComputers = new CopyOnWriteArrayList();
    private EntityDrone drone;
    public float rotationYaw;
    public float rotationPitch = (float)Math.toRadians(-42.0);
    private final ConcurrentLinkedQueue<Integer> ringSendQueue = new ConcurrentLinkedQueue();
    private int ringSendCooldown;
    private IProgWidget curAction;
    private int droneId;

    public TileEntityDroneInterface() {
        this.setupLuaMethods();
    }

    public void func_73660_a() {
        if (this.drone != null && this.drone.field_70128_L) {
            this.setDrone(null);
        }
        if (this.drone != null) {
            if (this.func_145831_w().field_72995_K) {
                double dx = this.drone.field_70165_t - ((double)this.func_174877_v().func_177958_n() + 0.5);
                double dy = this.drone.field_70163_u - ((double)this.func_174877_v().func_177956_o() + 0.5);
                double dz = this.drone.field_70161_v - ((double)this.func_174877_v().func_177952_p() + 0.5);
                float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                this.rotationYaw = (float)(-Math.atan2(dx, dz));
                this.rotationPitch = (float)(-Math.atan2(dy, f3));
            } else {
                if (this.ringSendCooldown > 0) {
                    --this.ringSendCooldown;
                }
                if (!this.ringSendQueue.isEmpty() && this.ringSendCooldown <= 0) {
                    this.ringSendCooldown = this.ringSendQueue.size() > 10 ? 1 : 5;
                    NetworkHandler.sendToDimension(new PacketSpawnRing((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.8, (double)this.func_174877_v().func_177952_p() + 0.5, (Entity)this.drone, this.ringSendQueue.poll()), this.func_145831_w().field_73011_w.getDimension());
                }
            }
        }
        if (this.func_145831_w().field_72995_K) {
            EntityDrone prevDrone = this.drone;
            Entity e = this.func_145831_w().func_73045_a(this.droneId);
            this.drone = e instanceof EntityDrone ? (EntityDrone)e : null;
            if (prevDrone != this.drone) {
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            }
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74768_a("drone", this.drone != null ? this.drone.func_145782_y() : -1);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.droneId = tag.func_74762_e("drone");
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    boolean isDroneConnected() {
        return this.drone != null;
    }

    private EntityDrone validateAndGetDrone() {
        if (this.drone == null) {
            throw new IllegalStateException("There's no connected Drone!");
        }
        return this.drone;
    }

    private void setupLuaMethods() {
        this.luaMethodRegistry = new LuaMethodRegistry();
        this.registerLuaMethod(new LuaMethod("isConnectedToDrone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.drone != null};
            }
        });
        this.registerLuaMethod(new LuaMethod("getDronePressure"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{(double)TileEntityDroneInterface.this.validateAndGetDrone().getPressure(null)};
            }
        });
        this.registerLuaMethod(new LuaMethod("exitPiece"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.validateAndGetDrone();
                TileEntityDroneInterface.this.setDrone(null);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("getAllActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                ArrayList<String> actions = new ArrayList<String>();
                for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
                    if (!widget.canBeRunByComputers(new EntityDrone(TileEntityDroneInterface.this.func_145831_w()), TileEntityDroneInterface.this.getWidget())) continue;
                    actions.add(widget.getWidgetString());
                }
                return new Object[]{this.getStringTable(actions)};
            }
        });
        this.registerLuaMethod(new LuaMethod("getDronePosition"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                EntityDrone d = TileEntityDroneInterface.this.validateAndGetDrone();
                return new Double[]{d.field_70165_t, d.field_70163_u, d.field_70161_v};
            }
        });
        this.registerLuaMethod(new LuaMethod("setBlockOrder"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "'closest'/'highToLow'/'lowToHigh'");
                String arg = (String)args[0];
                for (IBlockOrdered.EnumOrder order : IBlockOrdered.EnumOrder.values()) {
                    if (!order.toString().equalsIgnoreCase(arg)) continue;
                    TileEntityDroneInterface.this.getWidget().setOrder(order);
                    return null;
                }
                throw new IllegalArgumentException("No valid order. Valid arguments:  'closest', 'highToLow' or 'lowToHigh'!");
            }
        });
        this.registerLuaMethod(new LuaMethod("getAreaTypes"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return TileEntityDroneInterface.this.getWidget().getAreaTypes();
            }
        });
        this.registerLuaMethod(new LuaMethod("addArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{3, 7}, "(x,y,z) or (x1,y1,z1,x2,y2,z2,areaType)");
                if (args.length == 3) {
                    TileEntityDroneInterface.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                } else {
                    TileEntityDroneInterface.this.getWidget().addArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                }
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("removeArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{3, 7}, "(x,y,z) or (x1,y1,z1,x2,y2,z2,areaType)");
                if (args.length == 3) {
                    TileEntityDroneInterface.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue());
                } else if (args.length == 7) {
                    TileEntityDroneInterface.this.getWidget().removeArea(((Double)args[0]).intValue(), ((Double)args[1]).intValue(), ((Double)args[2]).intValue(), ((Double)args[3]).intValue(), ((Double)args[4]).intValue(), ((Double)args[5]).intValue(), (String)args[6]);
                }
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("clearArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearArea();
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetArea.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("showArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                HashSet<BlockPos> area = new HashSet<BlockPos>();
                TileEntityDroneInterface.this.getWidget().getArea(area);
                NetworkHandler.sendToDimension(new PacketShowArea(TileEntityDroneInterface.this.func_174877_v(), area), TileEntityDroneInterface.this.func_145831_w().field_73011_w.getDimension());
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("hideArea"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                NetworkHandler.sendToDimension(new PacketShowArea(TileEntityDroneInterface.this.func_174877_v(), new BlockPos[0]), TileEntityDroneInterface.this.func_145831_w().field_73011_w.getDimension());
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("addWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 6, "<string> item/block name, <int> item/block metadata, <bool> Use Metadata, <bool> Use NBT, <bool> Use Ore Dictionary, <bool> Use Mod Similarity");
                TileEntityDroneInterface.this.getWidget().addWhitelistItemFilter((String)args[0], ((Double)args[1]).intValue(), (Boolean)args[2], (Boolean)args[3], (Boolean)args[4], (Boolean)args[5]);
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("addBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 6, "<string> item/block name, <int> item/block metadata, <bool> Use Metadata, <bool> Use NBT, <bool> Use Ore Dictionary, <bool> Use Mod Similarity");
                TileEntityDroneInterface.this.getWidget().addBlacklistItemFilter((String)args[0], ((Double)args[1]).intValue(), (Boolean)args[2], (Boolean)args[3], (Boolean)args[4], (Boolean)args[5]);
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("clearWhitelistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearItemWhitelist();
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("clearBlacklistItemFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearItemBlacklist();
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetItemFilter.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("addWhitelistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> text");
                TileEntityDroneInterface.this.getWidget().addWhitelistText((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("addBlacklistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> text");
                TileEntityDroneInterface.this.getWidget().addBlacklistText((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("clearWhitelistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearWhitelistText();
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("clearBlacklistText"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearBlacklistText();
                TileEntityDroneInterface.this.messageToDrone(ProgWidgetString.class);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setSide"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 2, "down/up/north/south/west/east, <boolean> valid");
                EnumFacing dir = this.getDirForString((String)args[0]);
                boolean[] sides = TileEntityDroneInterface.this.getWidget().getSides();
                sides[dir.ordinal()] = (Boolean)args[1];
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setSides"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 6, "6 x boolean (order: DUNSWE)");
                boolean[] sides = new boolean[6];
                for (int i = 0; i < 6; ++i) {
                    sides[i] = (Boolean)args[i];
                }
                TileEntityDroneInterface.this.getWidget().setSides(sides);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setEmittingRedstone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> signal_strength");
                TileEntityDroneInterface.this.getWidget().setEmittingRedstone(((Double)args[0]).intValue());
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setRenameString"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> new_name");
                TileEntityDroneInterface.this.getWidget().setNewName((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("addWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> fluid_name");
                TileEntityDroneInterface.this.getWidget().addWhitelistLiquidFilter((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("addBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> fluid_name");
                TileEntityDroneInterface.this.getWidget().addBlacklistLiquidFilter((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("clearWhitelistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearLiquidWhitelist();
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("clearBlacklistLiquidFilter"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getWidget().clearLiquidBlacklist();
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setDropStraight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> drop_straight");
                TileEntityDroneInterface.this.getWidget().setDropStraight((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setUseCount"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_use_count");
                TileEntityDroneInterface.this.getWidget().setUseCount((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setCount"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> use_count");
                TileEntityDroneInterface.this.getWidget().setCount(((Double)args[0]).intValue());
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setIsAndFunction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> is_and_function");
                TileEntityDroneInterface.this.getWidget().setAndFunction((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setOperator"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> '>=', '=' or = '>='");
                TileEntityDroneInterface.this.getWidget().setOperator((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("evaluateCondition"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                if (TileEntityDroneInterface.this.curAction instanceof ICondition) {
                    boolean bool = ((ICondition)((Object)TileEntityDroneInterface.this.curAction)).evaluate(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget());
                    return new Object[]{bool};
                }
                throw new IllegalArgumentException("Current action is not a condition! Action: " + (TileEntityDroneInterface.this.curAction != null ? TileEntityDroneInterface.this.curAction.getWidgetString() : "*none*"));
            }
        });
        this.registerLuaMethod(new LuaMethod("setUseMaxActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_use_max_actions");
                TileEntityDroneInterface.this.getWidget().setUseMaxActions((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setMaxActions"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> max_actions");
                TileEntityDroneInterface.this.getWidget().setMaxActions(((Double)args[0]).intValue());
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setSneaking"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> is_sneaking");
                TileEntityDroneInterface.this.getWidget().setSneaking((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setPlaceFluidBlocks"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> should_place_fluid_blocks");
                TileEntityDroneInterface.this.getWidget().setPlaceFluidBlocks((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setAction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> action_name");
                String widgetName = (String)args[0];
                for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
                    if (!widget.getWidgetString().equalsIgnoreCase(widgetName)) continue;
                    EntityAIBase ai = widget.getWidgetAI(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget());
                    if (ai == null || !widget.canBeRunByComputers(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget())) {
                        throw new IllegalArgumentException("Parsed action '" + widgetName + "' is not a runnable action!");
                    }
                    TileEntityDroneInterface.this.getAI().setAction(widget, ai);
                    TileEntityDroneInterface.this.getTargetAI().setAction(widget, widget.getWidgetTargetAI(TileEntityDroneInterface.this.drone, TileEntityDroneInterface.this.getWidget()));
                    TileEntityDroneInterface.this.messageToDrone(ItemDye.field_150922_c[widget.getCraftingColorIndex()]);
                    TileEntityDroneInterface.this.curAction = widget;
                    return null;
                }
                throw new IllegalArgumentException("No action with the name '" + widgetName + "'!");
            }
        });
        this.registerLuaMethod(new LuaMethod("getAction"){

            @Override
            public Object[] call(Object[] args) {
                Object[] objectArray;
                this.requireNoArgs(args);
                if (TileEntityDroneInterface.this.curAction != null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = TileEntityDroneInterface.this.curAction.getWidgetString();
                } else {
                    objectArray = null;
                }
                return objectArray;
            }
        });
        this.registerLuaMethod(new LuaMethod("abortAction"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.getAI().abortAction();
                TileEntityDroneInterface.this.getTargetAI().abortAction();
                TileEntityDroneInterface.this.messageToDrone(-1);
                TileEntityDroneInterface.this.curAction = null;
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("isActionDone"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.getAI().isActionDone()};
            }
        });
        this.registerLuaMethod(new LuaMethod("forgetTarget"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                TileEntityDroneInterface.this.validateAndGetDrone().func_70624_b(null);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("getUpgrades"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<int> upgrade_index");
                return new Object[]{(double)TileEntityDroneInterface.this.validateAndGetDrone().getUpgrades(IItemRegistry.EnumUpgrade.values()[((Double)args[0]).intValue()])};
            }
        });
        this.registerLuaMethod(new LuaMethod("setCraftingGrid"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 9, "9 x item_name");
                String[] grid = new String[9];
                for (int i = 0; i < 9; ++i) {
                    grid[i] = (String)args[i];
                }
                TileEntityDroneInterface.this.getWidget().setCraftingGrid(grid);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setVariable"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, new int[]{2, 4}, "<string> var_name, true/false OR <string> var_name, <int> x, <int> y, <int> z");
                EntityDrone d = TileEntityDroneInterface.this.validateAndGetDrone();
                String varName = (String)args[0];
                int x = args[1] instanceof Double ? ((Double)args[1]).intValue() : ((Boolean)args[1] != false ? 1 : 0);
                int y = 0;
                int z = 0;
                if (args.length == 4) {
                    y = ((Double)args[2]).intValue();
                    z = ((Double)args[3]).intValue();
                }
                d.setVariable(varName, new BlockPos(x, y, z));
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("getVariable"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<string> var_name");
                BlockPos var = TileEntityDroneInterface.this.validateAndGetDrone().getVariable((String)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return new Object[]{var.func_177958_n(), var.func_177956_o(), var.func_177952_p()};
            }
        });
        this.registerLuaMethod(new LuaMethod("setSignText"){

            @Override
            public Object[] call(Object[] args) {
                ((TileEntityDroneInterface)TileEntityDroneInterface.this).getWidget().signText = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    ((TileEntityDroneInterface)TileEntityDroneInterface.this).getWidget().signText[i] = (String)args[i];
                }
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("setRequiresTool"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "<boolean> require_tool");
                TileEntityDroneInterface.this.getWidget().setRequiresTool((Boolean)args[0]);
                TileEntityDroneInterface.this.messageToDrone(-1);
                return null;
            }
        });
        this.registerLuaMethod(new LuaMethod("getDroneName"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.validateAndGetDrone().func_70005_c_()};
            }
        });
        this.registerLuaMethod(new LuaMethod("getOwnerName"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.validateAndGetDrone().getPlayerName()};
            }
        });
        this.registerLuaMethod(new LuaMethod("getOwnerID"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{TileEntityDroneInterface.this.validateAndGetDrone().getOwnerUUID()};
            }
        });
    }

    private void registerLuaMethod(ILuaMethod method) {
        this.luaMethodRegistry.registerLuaMethod(method);
    }

    public String getType() {
        return "droneInterface";
    }

    public String getComponentName() {
        return this.getType();
    }

    public String[] getMethodNames() {
        return this.luaMethodRegistry.getMethodNames();
    }

    public String[] methods() {
        return this.getMethodNames();
    }

    @Optional.Method(modid="opencomputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        if ("greet".equals(method)) {
            return new Object[]{String.format("Hello, %s!", args.checkString(0))};
        }
        return this.luaMethodRegistry.getMethod(method).call(args.toArray());
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException {
        try {
            return this.luaMethodRegistry.getMethod(method).call(arguments);
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Optional.Method(modid="computercraft")
    public void attach(IComputerAccess computer) {
        this.attachedComputers.add(computer);
    }

    @Optional.Method(modid="computercraft")
    public void detach(IComputerAccess computer) {
        this.attachedComputers.remove(computer);
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity tother = (TileEntity)other;
            return tother.func_145831_w().equals(this.func_145831_w()) && tother.func_174877_v().equals((Object)this.func_174877_v());
        }
        return false;
    }

    private void sendEvent(String name, Object ... parms) {
        if (Loader.isModLoaded((String)"computercraft")) {
            for (IComputerAccess computer : this.attachedComputers) {
                computer.queueEvent(name, parms);
            }
        }
    }

    public void setDrone(EntityDrone drone) {
        this.drone = drone;
        this.sendEvent(drone != null ? "droneConnected" : "droneDisconnected", new Object[0]);
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public EntityDrone getDrone() {
        return this.drone;
    }

    private ProgWidgetCC getWidget() {
        return this.getAI().getWidget();
    }

    private DroneAICC getAI() {
        if (this.drone != null) {
            for (DroneAIManager.EntityAITaskEntry task : this.drone.getRunningTasks()) {
                if (!(task.action instanceof DroneAICC)) continue;
                return (DroneAICC)task.action;
            }
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private DroneAICC getTargetAI() {
        if (this.drone != null && this.drone.getRunningTargetAI() instanceof DroneAICC) {
            return (DroneAICC)this.drone.getRunningTargetAI();
        }
        this.setDrone(null);
        throw new IllegalStateException("There's no connected Drone!");
    }

    private void messageToDrone(Class<? extends IProgWidget> widget) {
        this.messageToDrone(ItemDye.field_150922_c[ItemProgrammingPuzzle.getWidgetForClass(widget).getCraftingColorIndex()]);
    }

    private void messageToDrone(int color) {
        this.ringSendQueue.offer(color);
    }
}

