/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.config.ThirdPartyConfig;
import me.desht.pneumaticcraft.common.thirdparty.GenericIntegrationHandler;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IRegistryListener;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2;
import me.desht.pneumaticcraft.common.thirdparty.baubles.Baubles;
import me.desht.pneumaticcraft.common.thirdparty.botania.Botania;
import me.desht.pneumaticcraft.common.thirdparty.buildcraft.BuildCraft;
import me.desht.pneumaticcraft.common.thirdparty.cofhcore.CoFHCore;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ComputerCraft;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.OpenComputers;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.CraftTweaker;
import me.desht.pneumaticcraft.common.thirdparty.enderio.EnderIO;
import me.desht.pneumaticcraft.common.thirdparty.forestry.Forestry;
import me.desht.pneumaticcraft.common.thirdparty.ic2.IC2;
import me.desht.pneumaticcraft.common.thirdparty.igwmod.IGWMod;
import me.desht.pneumaticcraft.common.thirdparty.immersiveengineering.ImmersiveEngineering;
import me.desht.pneumaticcraft.common.thirdparty.immersivepetroleum.ImmersivePetroleum;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.Mekanism;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.thirdparty.thaumcraft.Thaumcraft;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TheOneProbe;
import me.desht.pneumaticcraft.common.thirdparty.toughasnails.ToughAsNails;
import me.desht.pneumaticcraft.common.thirdparty.waila.Waila;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class ThirdPartyManager
implements IGuiHandler {
    private static final ThirdPartyManager INSTANCE = new ThirdPartyManager();
    private final List<IThirdParty> thirdPartyMods = new ArrayList<IThirdParty>();
    public static boolean computerCraftLoaded;
    public IDocsProvider docsProvider = new IDocsProvider.NoDocsProvider();
    private GenericIntegrationHandler generic = new GenericIntegrationHandler();

    public static ThirdPartyManager instance() {
        return INSTANCE;
    }

    public void index() {
        HashMap<String, Class> thirdPartyClasses = new HashMap<String, Class>();
        try {
            thirdPartyClasses.put("buildcraftcore", BuildCraft.class);
            thirdPartyClasses.put("igwmod", IGWMod.class);
            thirdPartyClasses.put("computercraft", ComputerCraft.class);
            if (!Loader.isModLoaded((String)"computercraft")) {
                thirdPartyClasses.put("opencomputers", OpenComputers.class);
            }
            thirdPartyClasses.put("appliedenergistics2", AE2.class);
            thirdPartyClasses.put("forestry", Forestry.class);
            thirdPartyClasses.put("enderio", EnderIO.class);
            thirdPartyClasses.put("cofhcore", CoFHCore.class);
            thirdPartyClasses.put("waila", Waila.class);
            thirdPartyClasses.put("theoneprobe", TheOneProbe.class);
            thirdPartyClasses.put("crafttweaker", CraftTweaker.class);
            thirdPartyClasses.put("ic2", IC2.class);
            thirdPartyClasses.put("immersiveengineering", ImmersiveEngineering.class);
            thirdPartyClasses.put("thaumcraft", Thaumcraft.class);
            thirdPartyClasses.put("botania", Botania.class);
            thirdPartyClasses.put("immersivepetroleum", ImmersivePetroleum.class);
            thirdPartyClasses.put("patchouli", Patchouli.class);
            thirdPartyClasses.put("mekanism", Mekanism.class);
            thirdPartyClasses.put("baubles", Baubles.class);
            thirdPartyClasses.put("toughasnails", ToughAsNails.class);
        }
        catch (Throwable e) {
            Log.error("A class loader loaded a class where we didn't expect it to do so! Please report, as third party content is broken.");
            e.printStackTrace();
        }
        ThirdPartyConfig.setupDefaults(thirdPartyClasses.keySet());
        Set enabledThirdParty = thirdPartyClasses.keySet().stream().filter(ThirdPartyConfig::isEnabled).collect(Collectors.toSet());
        PneumaticCraftRepressurized.logger.info("Thirdparty integration activated for [" + Strings.join(enabledThirdParty, (String)", ") + "]");
        for (Map.Entry entry : thirdPartyClasses.entrySet()) {
            if (!enabledThirdParty.contains(entry.getKey()) || !Loader.isModLoaded((String)((String)entry.getKey()))) continue;
            try {
                this.thirdPartyMods.add((IThirdParty)((Class)entry.getValue()).newInstance());
            }
            catch (Throwable e) {
                Log.error("Failed to instantiate third party handler!");
                e.printStackTrace();
            }
        }
    }

    public void onItemRegistry(Item item) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof IRegistryListener)) continue;
            ((IRegistryListener)((Object)thirdParty)).onItemRegistry(item);
        }
    }

    public void onBlockRegistry(Block block) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            if (!(thirdParty instanceof IRegistryListener)) continue;
            ((IRegistryListener)((Object)thirdParty)).onBlockRegistry(block);
        }
    }

    public void preInit() {
        this.generic.preInit();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.preInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PreInit phase!");
                e.printStackTrace();
            }
        }
    }

    public void init() {
        this.generic.init();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.init();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the Init phase!");
                e.printStackTrace();
            }
        }
    }

    public void postInit() {
        this.generic.postInit();
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.postInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " in the PostInit phase!");
                e.printStackTrace();
            }
        }
    }

    public void clientPreInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientPreInit();
                if (!(thirdParty instanceof IDocsProvider)) continue;
                this.docsProvider = (IDocsProvider)((Object)thirdParty);
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " client side!");
                e.printStackTrace();
            }
        }
    }

    public void clientInit() {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            try {
                thirdParty.clientInit();
            }
            catch (Throwable e) {
                Log.error("PneumaticCraft wasn't able to load third party content from the third party class " + thirdParty.getClass() + " client side on the init!");
                e.printStackTrace();
            }
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            Object obj;
            if (!(thirdParty instanceof IGuiHandler) || (obj = ((IGuiHandler)thirdParty).getServerGuiElement(ID, player, world, x, y, z)) == null) continue;
            return obj;
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        for (IThirdParty thirdParty : this.thirdPartyMods) {
            Object obj;
            if (!(thirdParty instanceof IGuiHandler) || (obj = ((IGuiHandler)thirdParty).getClientGuiElement(ID, player, world, x, y, z)) == null) continue;
            return obj;
        }
        return null;
    }
}

