/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum ModdedWrenchUtils {
    INSTANCE;

    @GameRegistry.ObjectHolder(value="thermalfoundation:wrench")
    private static final Item CRESCENT_HAMMER;
    @GameRegistry.ObjectHolder(value="rftools:smartwrench")
    private static final Item SMART_WRENCH;
    @GameRegistry.ObjectHolder(value="immersiveengineering:tool")
    private static final Item IMMERSIVE_TOOL;
    @GameRegistry.ObjectHolder(value="appliedenergistics2:certus_quartz_wrench")
    private static final Item AE2_CERTUS_WRENCH;
    @GameRegistry.ObjectHolder(value="appliedenergistics2:nether_quartz_wrench")
    private static final Item AE2_NETHER_WRENCH;
    @GameRegistry.ObjectHolder(value="enderio:item_yeta_wrench")
    private static final Item YETA_WRENCH;
    @GameRegistry.ObjectHolder(value="buildcraftcore:wrench")
    private static final Item BC_WRENCH;
    @GameRegistry.ObjectHolder(value="teslacorelib:wrench")
    private static final Item TESLA_WRENCH;
    @GameRegistry.ObjectHolder(value="ic2:wrench")
    private static final Item IC2_WRENCH;
    @GameRegistry.ObjectHolder(value="chiselsandbits:wrench_wood")
    private static final Item CB_WRENCH_WOOD;
    private final Set<String> wrenches = new HashSet<String>();

    public static ModdedWrenchUtils getInstance() {
        return INSTANCE;
    }

    public void registerThirdPartyWrenches() {
        this.registerWrench(CRESCENT_HAMMER);
        this.registerWrench(SMART_WRENCH);
        this.registerWrench(IMMERSIVE_TOOL);
        this.registerWrench(AE2_CERTUS_WRENCH);
        this.registerWrench(AE2_NETHER_WRENCH);
        this.registerWrench(YETA_WRENCH);
        this.registerWrench(BC_WRENCH);
        this.registerWrench(TESLA_WRENCH);
        this.registerWrench(IC2_WRENCH);
        this.registerWrench(CB_WRENCH_WOOD);
    }

    private void registerWrench(Item wrench) {
        if (wrench != null) {
            this.wrenches.add(ModdedWrenchUtils.makeWrenchKey(new ItemStack(wrench)));
        }
    }

    private static String makeWrenchKey(ItemStack wrench) {
        return wrench.func_77973_b().getRegistryName() + (ModdedWrenchUtils.getWrenchMeta(wrench) >= 0 ? ":" + wrench.func_77960_j() : "");
    }

    private static int getWrenchMeta(ItemStack wrench) {
        if (wrench.func_77973_b() == IMMERSIVE_TOOL) {
            return 0;
        }
        return -1;
    }

    public boolean isModdedWrench(@Nonnull ItemStack stack) {
        return this.wrenches.contains(ModdedWrenchUtils.makeWrenchKey(stack));
    }

    static {
        CRESCENT_HAMMER = null;
        SMART_WRENCH = null;
        IMMERSIVE_TOOL = null;
        AE2_CERTUS_WRENCH = null;
        AE2_NETHER_WRENCH = null;
        YETA_WRENCH = null;
        BC_WRENCH = null;
        TESLA_WRENCH = null;
        IC2_WRENCH = null;
        CB_WRENCH_WOOD = null;
    }
}

