/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.awt.Point;
import java.io.IOException;
import me.desht.pneumaticcraft.common.config.MicromissileDefaults;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateMicromissileSettings
extends AbstractPacket<PacketUpdateMicromissileSettings> {
    private float topSpeed;
    private float accel;
    private float damage;
    private Point point;
    private String entityFilter;
    private ItemMicromissiles.FireMode fireMode;
    private boolean saveDefault;

    public PacketUpdateMicromissileSettings() {
    }

    public PacketUpdateMicromissileSettings(float topSpeed, float accel, float damage, Point point, String entityFilter, ItemMicromissiles.FireMode fireMode, boolean saveDefault) {
        this.topSpeed = topSpeed;
        this.accel = accel;
        this.damage = damage;
        this.point = point;
        this.entityFilter = entityFilter;
        this.fireMode = fireMode;
        this.saveDefault = saveDefault;
    }

    @Override
    public void handleClientSide(PacketUpdateMicromissileSettings message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketUpdateMicromissileSettings message, EntityPlayer player) {
        ItemStack stack = ItemMicromissiles.getHeldMicroMissile(player);
        if (!stack.func_190926_b()) {
            this.applySettings(message, player, stack);
        } else {
            Log.warning("Received PacketUpdateMicromissileSettings but player does not hold a Micromissile? " + player.func_70005_c_());
        }
    }

    private void applySettings(PacketUpdateMicromissileSettings message, EntityPlayer player, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74776_a("turnSpeed", message.accel);
        tag.func_74776_a("topSpeed", message.topSpeed);
        tag.func_74776_a("damage", message.damage);
        tag.func_74768_a("px", message.point.x);
        tag.func_74768_a("py", message.point.y);
        tag.func_74778_a("filter", message.entityFilter);
        tag.func_74778_a("fireMode", message.fireMode.toString());
        if (message.saveDefault) {
            try {
                MicromissileDefaults.INSTANCE.setDefaults(player, new MicromissileDefaults.Entry(message.topSpeed, message.accel, message.damage, message.point, message.entityFilter, message.fireMode));
                MicromissileDefaults.INSTANCE.writeToFile();
                NetworkHandler.sendTo(new PacketPlaySound(Sounds.CHIRP, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f, false), (EntityPlayerMP)player);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.topSpeed = buf.readFloat();
        this.accel = buf.readFloat();
        this.damage = buf.readFloat();
        this.point = new Point(buf.readInt(), buf.readInt());
        this.entityFilter = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.fireMode = ItemMicromissiles.FireMode.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.saveDefault = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.topSpeed);
        buf.writeFloat(this.accel);
        buf.writeFloat(this.damage);
        buf.writeInt(this.point.x);
        buf.writeInt(this.point.y);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityFilter);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fireMode.toString());
        buf.writeBoolean(this.saveDefault);
    }
}

