/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class EntityTumblingBlock
extends EntityThrowable {
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityTumblingBlock.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<ItemStack> STATE_STACK = EntityDataManager.func_187226_a(EntityTumblingBlock.class, (DataSerializer)DataSerializers.field_187196_f);
    private static FakePlayer fakePlayer;

    public EntityTumblingBlock(World worldIn) {
        super(worldIn);
    }

    public EntityTumblingBlock(World worldIn, double x, double y, double z, @Nonnull ItemStack stack) {
        super(worldIn);
        Validate.isTrue((!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock ? 1 : 0) != 0);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b(x, y + (double)((1.0f - this.field_70131_O) / 2.0f), z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setOrigin(new BlockPos((Entity)this));
        this.field_70180_af.func_187227_b(STATE_STACK, (Object)stack);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(STATE_STACK, (Object)ItemStack.field_190927_a);
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STATE_STACK);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    private void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos1 = new BlockPos((Entity)this);
            if (!(this.field_70122_E || (this.field_70173_aa <= 100 || blockpos1.func_177956_o() >= 1 && blockpos1.func_177956_o() <= 256) && this.field_70173_aa <= 600)) {
                this.dropAsItem();
                this.func_70106_y();
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.func_70106_y();
            if (!this.tryPlaceAsBlock(result.func_178782_a(), result.field_178784_b)) {
                this.dropAsItem();
            }
        }
    }

    private boolean tryPlaceAsBlock(BlockPos pos0, EnumFacing side) {
        BlockPos pos;
        Block b = this.field_70170_p.func_180495_p(pos0).func_177230_c();
        BlockPos blockPos = pos = b.func_176200_f((IBlockAccess)this.field_70170_p, pos0) ? pos0 : pos0.func_177972_a(side);
        if (this.field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
            ItemStack stack = (ItemStack)this.field_70180_af.func_187225_a(STATE_STACK);
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            EntityPlayer placer = this.field_70192_c instanceof EntityPlayer ? (EntityPlayer)this.field_70192_c : this.getFakePlayer();
            IBlockState newState = block.getStateForPlacement(this.field_70170_p, pos, side, 0.0f, 0.0f, 0.0f, stack.func_77960_j(), (EntityLivingBase)placer, EnumHand.MAIN_HAND);
            return PneumaticCraftUtils.tryPlaceBlock(this.field_70170_p, pos, placer, side, newState);
        }
        return false;
    }

    private void dropAsItem() {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(((ItemStack)this.field_70180_af.func_187225_a(STATE_STACK)).func_77946_l(), 0.0f);
        }
    }

    private EntityPlayer getFakePlayer() {
        if (fakePlayer == null) {
            fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_70170_p), (GameProfile)new GameProfile(null, "[Tumbling Block]"));
            EntityTumblingBlock.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(FMLCommonHandler.instance().getMinecraftServerInstance(), (EntityPlayerMP)fakePlayer);
        }
        EntityTumblingBlock.fakePlayer.field_70165_t = this.field_70165_t;
        EntityTumblingBlock.fakePlayer.field_70163_u = this.field_70163_u;
        EntityTumblingBlock.fakePlayer.field_70161_v = this.field_70161_v;
        return fakePlayer;
    }
}

