/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.living;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.IPathfindHandler;
import me.desht.pneumaticcraft.api.event.SemiblockEvent;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.client.render.RenderDroneHeldItem;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.common.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.DroneGoToChargingStation;
import me.desht.pneumaticcraft.common.ai.DroneGoToOwner;
import me.desht.pneumaticcraft.common.ai.DroneMoveHelper;
import me.desht.pneumaticcraft.common.ai.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.entity.living.DebugEntry;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.item.ItemProgrammingPuzzle;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferCustom;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import me.desht.pneumaticcraft.common.util.fakeplayer.InventoryFakePlayer;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.DyeUtils;

public class EntityDrone
extends EntityDroneBase
implements IManoMeasurable,
IPneumaticWrenchable,
IEntityAdditionalSpawnData,
IHackableEntity,
IDroneBase,
EntityFlying {
    private static final HashMap<String, Integer> colorMap = new HashMap();
    private EntityDroneItemHandler inventory = new EntityDroneItemHandler(1, this);
    private final FluidTank tank = new FluidTank(Integer.MAX_VALUE);
    private final ItemStackHandler upgradeInventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            EntityDrone.this.energy.setCapacity(100000 + 100000 * EntityDrone.this.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME));
        }
    };
    private final int[] emittingRedstoneValues = new int[6];
    private float propSpeed;
    private static final float LASER_EXTEND_SPEED = 0.05f;
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    protected float currentAir;
    private float volume;
    private RenderProgressingLine targetLine;
    private RenderProgressingLine oldTargetLine;
    public List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private DroneFakePlayer fakePlayer;
    public String playerName = "Drone";
    private String playerUUID;
    public DroneGoToChargingStation chargeAI;
    public DroneGoToOwner gotoOwnerAI;
    private final DroneAIManager aiManager = new DroneAIManager(this);
    private boolean firstTick = true;
    public boolean naturallySpawned = true;
    private double speed;
    private int lifeUpgrades;
    private int suffocationCounter = 40;
    private boolean isSuffocating;
    private boolean disabledByHacking;
    private boolean standby;
    private Minigun minigun;
    private AmadronOffer handlingOffer;
    private int offerTimes;
    private ItemStack usedTablet;
    private String buyingPlayer;
    private final DroneDebugList debugList = new DroneDebugList();
    private final Set<EntityPlayerMP> syncedPlayers = new HashSet<EntityPlayerMP>();
    private boolean heldItemChanged = true;
    private int securityUpgradeCount;
    private final Map<BlockPos, IBlockState> displacedLiquids = new HashMap<BlockPos, IBlockState>();
    private LogisticsManager logisticsManager;
    private static final DataParameter<Boolean> ACCELERATING;
    private static final DataParameter<Float> PRESSURE;
    private static final DataParameter<String> PROGRAM_KEY;
    private static final DataParameter<BlockPos> DUG_POS;
    private static final DataParameter<Boolean> GOING_TO_OWNER;
    private static final DataParameter<Integer> DRONE_COLOR;
    private static final DataParameter<Boolean> MINIGUN_ACTIVE;
    private static final DataParameter<Boolean> HAS_MINIGUN;
    private static final DataParameter<ItemStack> AMMO;
    private static final DataParameter<String> LABEL;
    private static final DataParameter<Integer> ACTIVE_WIDGET;
    private static final DataParameter<BlockPos> TARGET_POS;
    private static final DataParameter<ItemStack> HELD_ITEM;
    private static final DataParameter<Integer> TARGET_ID;

    public EntityDrone(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.35f);
        this.field_70765_h = new DroneMoveHelper(this);
        this.chargeAI = new DroneGoToChargingStation(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.chargeAI);
    }

    public EntityDrone(World world, EntityPlayer player) {
        this(world);
        if (player != null) {
            this.playerUUID = player.func_146103_bH().getId().toString();
            this.playerName = player.func_70005_c_();
        } else {
            this.playerUUID = this.func_110124_au().toString();
        }
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().field_72995_K && event.getWorld() == this.func_130014_f_()) {
            this.logisticsManager = null;
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        EntityPathNavigateDrone nav = new EntityPathNavigateDrone(this, worldIn);
        nav.func_192879_a(false);
        nav.func_192877_c(true);
        nav.func_192878_b(true);
        return nav;
    }

    private void initializeFakePlayer() {
        this.fakePlayer = new DroneFakePlayer((WorldServer)this.field_70170_p, new GameProfile(UUID.fromString(this.getOwnerUUID()), this.playerName), this);
        this.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(FMLCommonHandler.instance().getMinecraftServerInstance(), (EntityPlayerMP)this.fakePlayer);
        this.fakePlayer.field_71071_by = new InventoryFakePlayer((EntityPlayer)this.fakePlayer){

            @Override
            public IItemHandlerModifiable getUnderlyingItemHandler() {
                return EntityDrone.this.inventory;
            }
        };
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PRESSURE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ACCELERATING, (Object)false);
        this.field_70180_af.func_187214_a(PROGRAM_KEY, (Object)"");
        this.field_70180_af.func_187214_a(DUG_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(GOING_TO_OWNER, (Object)false);
        this.field_70180_af.func_187214_a(DRONE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(MINIGUN_ACTIVE, (Object)false);
        this.field_70180_af.func_187214_a(HAS_MINIGUN, (Object)false);
        this.field_70180_af.func_187214_a(AMMO, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(LABEL, (Object)"");
        this.field_70180_af.func_187214_a(ACTIVE_WIDGET, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TARGET_ID, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getRange());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.getFakePlayer().func_70005_c_());
    }

    public void readSpawnData(ByteBuf data) {
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)data);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return Sounds.DRONE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return Sounds.DRONE_DEATH;
    }

    public void func_70071_h_() {
        BlockPos pos;
        int z;
        boolean enabled;
        if (this.firstTick) {
            this.firstTick = false;
            this.volume = 12000 + this.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME) * 5000;
            this.securityUpgradeCount = this.getUpgrades(IItemRegistry.EnumUpgrade.SECURITY);
            if (this.securityUpgradeCount > 0) {
                ((EntityPathNavigateDrone)this.getPathNavigator()).pathThroughLiquid = true;
            }
            this.func_184644_a(PathNodeType.WATER, this.securityUpgradeCount > 0 ? 0.0f : -1.0f);
            this.speed = 0.15 + (double)Math.min(10, this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED)) * 0.015;
            this.lifeUpgrades = this.getUpgrades(IItemRegistry.EnumUpgrade.ITEM_LIFE);
            if (!this.field_70170_p.field_72995_K) {
                this.setHasMinigun(this.getUpgrades(IItemRegistry.EnumUpgrade.ENTITY_TRACKER) > 0);
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            this.aiManager.setWidgets(this.progWidgets);
            this.energy.setCapacity(100000 + 100000 * this.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME));
        }
        boolean bl = enabled = !this.disabledByHacking && this.getPressure(null) > 0.01f;
        if (!this.field_70170_p.field_72995_K) {
            int interval;
            this.inventory.updateHeldItem();
            this.setAccelerating(!this.standby && enabled);
            if (this.isAccelerating()) {
                this.field_70143_R = 0.0f;
            }
            if (this.lifeUpgrades > 0 && ((interval = 10 / this.lifeUpgrades) == 0 || this.field_70173_aa % interval == 0)) {
                this.func_70691_i(1.0f);
            }
            if (!this.isSuffocating) {
                this.suffocationCounter = 40;
            }
            this.isSuffocating = false;
            Path path = this.func_70661_as().func_75505_d();
            if (path != null) {
                PathPoint target = path.func_75870_c();
                if (target != null) {
                    this.setTargetedBlock(new BlockPos(target.field_75839_a, target.field_75837_b, target.field_75838_c));
                } else {
                    this.setTargetedBlock(null);
                }
            } else {
                this.setTargetedBlock(null);
            }
            if (this.field_70170_p.func_82737_E() % 20L == 0L) {
                this.updateSyncedPlayers();
            }
            DroneFakePlayer fp = this.getFakePlayer();
            fp.field_70165_t = this.field_70165_t;
            fp.field_70163_u = this.field_70163_u;
            fp.field_70161_v = this.field_70161_v;
            fp.func_70071_h_();
        } else {
            if (this.digLaser != null) {
                this.digLaser.update();
            }
            this.oldLaserExtension = this.laserExtension;
            this.laserExtension = this.getActiveProgramKey().equals("dig") ? Math.min(1.0f, this.laserExtension + 0.05f) : Math.max(0.0f, this.laserExtension - 0.05f);
            if (this.isAccelerating() && this.field_70146_Z.nextBoolean()) {
                int x = (int)Math.floor(this.field_70165_t);
                int y = (int)Math.floor(this.field_70163_u - 1.0);
                z = (int)Math.floor(this.field_70161_v);
                pos = new BlockPos(x, y, z);
                IBlockState state = null;
                for (int i = 0; i < 3 && (state = this.field_70170_p.func_180495_p(pos)).func_185904_a() == Material.field_151579_a; ++i) {
                    --y;
                }
                if (state.func_185904_a() != Material.field_151579_a) {
                    Vec3d vec = new Vec3d(this.field_70163_u - (double)y, 0.0, 0.0);
                    vec = vec.func_178785_b((float)((double)this.field_70146_Z.nextFloat() * Math.PI * 2.0));
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + vec.field_72450_a, (double)(y + 1), this.field_70161_v + vec.field_72449_c, vec.field_72450_a, 0.0, vec.field_72449_c, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(pos))});
                }
            }
        }
        if (this.securityUpgradeCount > 1 && this.func_110143_aJ() > 0.0f) {
            this.restoreLiquids(true);
            for (int x = (int)this.field_70165_t - 1; x <= (int)(this.field_70165_t + (double)this.field_70130_N); ++x) {
                for (int y = (int)this.field_70163_u - 1; y <= (int)(this.field_70163_u + (double)this.field_70131_O + 1.0); ++y) {
                    for (z = (int)this.field_70161_v - 2; z <= (int)(this.field_70161_v + (double)this.field_70130_N); ++z) {
                        if (!PneumaticCraftUtils.isBlockLiquid(this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c())) continue;
                        pos = new BlockPos(x, y, z);
                        if (this.securityUpgradeCount == 2) {
                            this.displacedLiquids.put(pos, this.field_70170_p.func_180495_p(pos));
                        }
                        this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }
        if (this.isAccelerating()) {
            this.field_70159_w *= 0.3;
            this.field_70181_x *= 0.3;
            this.field_70179_y *= 0.3;
            this.propSpeed = Math.min(1.0f, this.propSpeed + 0.04f);
            this.addAir(null, -1);
        } else {
            this.propSpeed = Math.max(0.0f, this.propSpeed - 0.04f);
        }
        this.oldPropRotation = this.propRotation;
        this.propRotation += this.propSpeed;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            for (int i = 0; i < 4; ++i) {
                this.getFakePlayer().field_71134_c.func_73075_a();
            }
        }
        super.func_70071_h_();
        if (this.hasMinigun()) {
            this.getMinigun().setAttackTarget(this.func_70638_az()).update(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (enabled) {
                this.aiManager.onUpdateTasks();
            }
            for (EnumFacing d : EnumFacing.field_82609_l) {
                if (this.getEmittingRedstone(d) <= 0) continue;
                if (!this.field_70170_p.func_175623_d(new BlockPos((int)Math.floor(this.field_70165_t + (double)(this.field_70130_N / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.field_70130_N / 2.0f))))) break;
                this.field_70170_p.func_175656_a(new BlockPos((int)Math.floor(this.field_70165_t + (double)(this.field_70130_N / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.field_70130_N / 2.0f))), Blockss.DRONE_REDSTONE_EMITTER.func_176223_P());
                break;
            }
        }
    }

    public boolean func_70648_aU() {
        return this.securityUpgradeCount > 0;
    }

    public BlockPos getTargetedBlock() {
        BlockPos pos = (BlockPos)this.field_70180_af.func_187225_a(TARGET_POS);
        return pos.equals((Object)BlockPos.field_177992_a) ? null : pos;
    }

    private void setTargetedBlock(BlockPos pos) {
        this.field_70180_af.func_187227_b(TARGET_POS, (Object)(pos == null ? BlockPos.field_177992_a : pos));
    }

    @Override
    public int getLaserColor() {
        if (colorMap.containsKey(this.func_95999_t().toLowerCase())) {
            return colorMap.get(this.func_95999_t().toLowerCase());
        }
        if (colorMap.containsKey(this.playerName.toLowerCase())) {
            return colorMap.get(this.playerName.toLowerCase());
        }
        return super.getLaserColor();
    }

    @Override
    protected BlockPos getDugBlock() {
        BlockPos pos = (BlockPos)this.field_70180_af.func_187225_a(DUG_POS);
        return pos.equals((Object)BlockPos.field_177992_a) ? null : pos;
    }

    @Override
    public ItemStack getDroneHeldItem() {
        return ConfigHandler.client.dronesRenderHeldItem ? (ItemStack)this.field_70180_af.func_187225_a(HELD_ITEM) : ItemStack.field_190927_a;
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        this.field_70180_af.func_187227_b(DUG_POS, (Object)(pos == null ? BlockPos.field_177992_a : pos));
    }

    public List<DroneAIManager.EntityAITaskEntry> getRunningTasks() {
        return this.aiManager.getRunningTasks();
    }

    public EntityAIBase getRunningTargetAI() {
        return this.aiManager.getTargetAI();
    }

    public void setVariable(String varName, BlockPos pos) {
        this.aiManager.setCoordinate(varName, pos);
    }

    public BlockPos getVariable(String varName) {
        return this.aiManager.getCoordinate(varName);
    }

    @Nonnull
    public ItemStack getActiveProgram() {
        String key = this.getActiveProgramKey();
        if (key.equals("")) {
            return ItemStack.field_190927_a;
        }
        return ItemProgrammingPuzzle.getStackForWidgetKey(key);
    }

    private String getActiveProgramKey() {
        return (String)this.field_70180_af.func_187225_a(PROGRAM_KEY);
    }

    public IProgWidget getActiveWidget() {
        int index = this.getActiveWidgetIndex();
        if (index >= 0 && index < this.progWidgets.size()) {
            return this.progWidgets.get(index);
        }
        return null;
    }

    private int getActiveWidgetIndex() {
        return (Integer)this.field_70180_af.func_187225_a(ACTIVE_WIDGET);
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.field_70180_af.func_187227_b(PROGRAM_KEY, (Object)widget.getWidgetString());
        this.field_70180_af.func_187227_b(ACTIVE_WIDGET, (Object)this.progWidgets.indexOf(widget));
    }

    private void setAccelerating(boolean accelerating) {
        this.field_70180_af.func_187227_b(ACCELERATING, (Object)accelerating);
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.field_70180_af.func_187225_a(ACCELERATING);
    }

    private void setDroneColor(int color) {
        this.field_70180_af.func_187227_b(DRONE_COLOR, (Object)color);
    }

    @Override
    public int getDroneColor() {
        return (Integer)this.field_70180_af.func_187225_a(DRONE_COLOR);
    }

    private void setMinigunActivated(boolean activated) {
        this.field_70180_af.func_187227_b(MINIGUN_ACTIVE, (Object)activated);
    }

    private boolean isMinigunActivated() {
        return (Boolean)this.field_70180_af.func_187225_a(MINIGUN_ACTIVE);
    }

    private void setHasMinigun(boolean hasMinigun) {
        this.field_70180_af.func_187227_b(HAS_MINIGUN, (Object)hasMinigun);
    }

    public boolean hasMinigun() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_MINIGUN);
    }

    public int getAmmoColor() {
        ItemStack ammo = (ItemStack)this.field_70180_af.func_187225_a(AMMO);
        if (ammo.func_77973_b() instanceof ItemGunAmmo) {
            return ((ItemGunAmmo)ammo.func_77973_b()).getAmmoColor(ammo);
        }
        return 0x808080;
    }

    public void setAmmoColor(ItemStack color) {
        this.field_70180_af.func_187227_b(AMMO, (Object)color);
    }

    protected int func_70682_h(int par1) {
        return -20;
    }

    public void func_191986_a(float par1, float par2, float par3) {
        if (this.field_70170_p.field_72995_K) {
            EntityLivingBase targetEntity = this.func_70638_az();
            if (targetEntity != null && targetEntity.field_70128_L) {
                this.func_70624_b(null);
                targetEntity = null;
            }
            if (targetEntity != null) {
                if (this.targetLine == null) {
                    this.targetLine = new RenderProgressingLine(0.0, -this.field_70131_O / 2.0f, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.oldTargetLine == null) {
                    this.oldTargetLine = new RenderProgressingLine(0.0, -this.field_70131_O / 2.0f, 0.0, 0.0, 0.0, 0.0);
                }
                this.targetLine.endX = targetEntity.field_70165_t - this.field_70165_t;
                this.targetLine.endY = targetEntity.field_70163_u + (double)(targetEntity.field_70131_O / 2.0f) - this.field_70163_u;
                this.targetLine.endZ = targetEntity.field_70161_v - this.field_70161_v;
                this.oldTargetLine.endX = targetEntity.field_70169_q - this.field_70169_q;
                this.oldTargetLine.endY = targetEntity.field_70167_r + (double)(targetEntity.field_70131_O / 2.0f) - this.field_70167_r;
                this.oldTargetLine.endZ = targetEntity.field_70166_s - this.field_70166_s;
                this.oldTargetLine.setProgress(this.targetLine.getProgress());
                this.targetLine.incProgressByDistance(0.3);
                this.field_70158_ak = true;
            } else {
                this.oldTargetLine = null;
                this.targetLine = null;
                this.field_70158_ak = false;
            }
        }
        if (this.func_184187_bx() == null && this.isAccelerating()) {
            double d3 = this.field_70181_x;
            super.func_191986_a(par1, par2, par3);
            this.field_70181_x = d3 * 0.6;
        } else {
            super.func_191986_a(par1, par2, par3);
        }
        this.field_70122_E = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderExtras(double transX, double transY, double transZ, float partialTicks) {
        super.renderExtras(transX, transY, transZ, partialTicks);
        if (this.targetLine != null && this.oldTargetLine != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.targetLine.renderInterpolated(this.oldTargetLine, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
        double x = this.field_70142_S + (this.field_70165_t - this.field_70142_S) * (double)partialTicks;
        double y = this.field_70137_T + (this.field_70163_u - this.field_70137_T) * (double)partialTicks;
        double z = this.field_70136_U + (this.field_70161_v - this.field_70136_U) * (double)partialTicks;
        this.getMinigun().render(x, y, z, 0.6);
        ItemStack held = this.getDroneHeldItem();
        if (!(held.func_190926_b() || held.func_77973_b() instanceof ItemGunAmmo && this.hasMinigun())) {
            if (this.renderDroneHeldItem == null) {
                this.renderDroneHeldItem = new RenderDroneHeldItem(this.field_70170_p);
            }
            this.renderDroneHeldItem.render(held);
        }
    }

    public double getRange() {
        return 75.0;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack equippedItem = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K && !equippedItem.func_190926_b()) {
            if (equippedItem.func_77973_b() == Itemss.GPS_TOOL) {
                BlockPos gpsLoc = ItemGPSTool.getGPSLocation(equippedItem);
                if (gpsLoc != null) {
                    this.func_70661_as().func_75492_a((double)gpsLoc.func_177958_n(), (double)gpsLoc.func_177956_o(), (double)gpsLoc.func_177952_p(), 0.1);
                }
            } else {
                OptionalInt dyeIndex = DyeUtils.dyeDamageFromStack((ItemStack)equippedItem);
                if (dyeIndex.isPresent()) {
                    this.setDroneColor(ItemDye.field_150922_c[dyeIndex.getAsInt()]);
                    if (ConfigHandler.general.useUpDyesWhenColoring && !player.field_71075_bZ.field_75098_d) {
                        equippedItem.func_190918_g(1);
                        if (equippedItem.func_190916_E() <= 0) {
                            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing side, EnumHand hand) {
        if (!this.naturallySpawned) {
            if (player.field_71075_bZ.field_75098_d) {
                this.naturallySpawned = true;
            }
            this.func_70097_a(new DamageSourcePneumaticCraft.DamageSourceDroneOverload("wrenched", new Object[0]), 2000.0f);
            return true;
        }
        return false;
    }

    private void restoreLiquids(boolean distCheck) {
        Iterator<Map.Entry<BlockPos, IBlockState>> iter = this.displacedLiquids.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BlockPos, IBlockState> entry = iter.next();
            BlockPos pos = entry.getKey();
            if (distCheck && !(pos.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 1.0)) continue;
            if (this.field_70170_p.func_175623_d(pos) || PneumaticCraftUtils.isBlockLiquid(this.field_70170_p.func_180495_p(pos).func_177230_c())) {
                this.field_70170_p.func_180501_a(pos, entry.getValue(), 2);
            }
            iter.remove();
        }
    }

    @Nullable
    public Entity changeDimension(int dimensionIn, ITeleporter teleporter) {
        Entity entity = super.changeDimension(dimensionIn, teleporter);
        if (entity != null) {
            this.restoreLiquids(false);
        }
        return entity;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            this.func_70099_a(this.inventory.getStackInSlot(i), 0.0f);
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.restoreLiquids(false);
        if (!this.naturallySpawned) {
            EntityPlayer owner;
            ItemStack drone = this.getDroppedStack();
            if (this.func_145818_k_()) {
                drone.func_151001_c(this.func_95999_t());
            }
            this.func_70099_a(drone, 0.0f);
            if (!this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
                int x = (int)Math.floor(this.field_70165_t);
                int y = (int)Math.floor(this.field_70163_u);
                int z = (int)Math.floor(this.field_70161_v);
                TextComponentTranslation msg = this.func_145818_k_() ? new TextComponentTranslation("death.drone.named", new Object[]{this.func_95999_t(), x, y, z}) : new TextComponentTranslation("death.drone", new Object[]{x, y, z});
                msg = msg.func_150257_a((ITextComponent)new TextComponentString(" - ")).func_150257_a(par1DamageSource.func_151519_b((EntityLivingBase)this));
                owner.func_146105_b((ITextComponent)msg, false);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.getFakePlayer().field_71134_c.func_180238_e();
        }
        this.func_96094_a("");
        super.func_70645_a(par1DamageSource);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    protected ItemStack getDroppedStack() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        ItemStack drone = new ItemStack(Itemss.DRONE);
        drone.func_77982_d(tag);
        return drone;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.field_70170_p.field_72995_K && TARGET_ID.equals(key)) {
            Entity e;
            int id = (Integer)this.field_70180_af.func_187225_a(TARGET_ID);
            if (id > 0 && (e = this.func_130014_f_().func_73045_a(id)) instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)e);
            }
            if (this.targetLine != null && this.oldTargetLine != null) {
                this.targetLine.setProgress(0.0f);
                this.oldTargetLine.setProgress(0.0f);
            }
        } else {
            super.func_184206_a(key);
        }
    }

    public void func_70624_b(EntityLivingBase entity) {
        super.func_70624_b(entity);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(TARGET_ID, (Object)(entity == null ? 0 : entity.func_145782_y()));
        }
    }

    @Override
    public float getPressure(ItemStack iStack) {
        return ((Float)this.field_70180_af.func_187225_a(PRESSURE)).floatValue();
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        if (!this.world().field_72995_K) {
            this.currentAir += (float)amount;
            this.field_70180_af.func_187227_b(PRESSURE, (Object)Float.valueOf(this.currentAir / this.volume));
        }
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 10.0f;
    }

    @Override
    public int getVolume(ItemStack iStack) {
        return (int)this.volume;
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        if (this.func_145818_k_()) {
            curInfo.add(TextFormatting.AQUA + this.func_95999_t());
        }
        curInfo.add("Owner: " + this.getFakePlayer().func_70005_c_());
        curInfo.add("Current pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(null), 1) + " bar.");
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        TileEntityProgrammer.setWidgetsToNBT(this.progWidgets, tag);
        tag.func_74757_a("naturallySpawned", this.naturallySpawned);
        tag.func_74776_a("currentAir", this.currentAir);
        tag.func_74776_a("propSpeed", this.propSpeed);
        tag.func_74757_a("disabledByHacking", this.disabledByHacking);
        tag.func_74757_a("hackedByOwner", this.gotoOwnerAI != null);
        tag.func_74768_a("color", this.getDroneColor());
        tag.func_74757_a("standby", this.standby);
        tag.func_74776_a("volume", this.volume);
        NBTTagCompound variableTag = new NBTTagCompound();
        this.aiManager.writeToNBT(variableTag);
        tag.func_74782_a("variables", (NBTBase)variableTag);
        tag.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74782_a("UpgradeInventory", (NBTBase)this.upgradeInventory.serializeNBT());
        this.tank.writeToNBT(tag);
        if (this.handlingOffer != null) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74757_a("isCustom", this.handlingOffer instanceof AmadronOfferCustom);
            this.handlingOffer.writeToNBT(subTag);
            tag.func_74782_a("amadronOffer", (NBTBase)subTag);
            tag.func_74768_a("offerTimes", this.offerTimes);
            if (!this.usedTablet.func_190926_b()) {
                this.usedTablet.func_77955_b(subTag);
            }
            tag.func_74778_a("buyingPlayer", this.buyingPlayer);
        }
        if (!this.displacedLiquids.isEmpty()) {
            NBTTagList disp = new NBTTagList();
            for (Map.Entry<BlockPos, IBlockState> entry : this.displacedLiquids.entrySet()) {
                NBTTagCompound p = NBTUtil.func_186859_a((BlockPos)entry.getKey());
                NBTTagCompound s = new NBTTagCompound();
                NBTUtil.func_190009_a((NBTTagCompound)s, (IBlockState)entry.getValue());
                NBTTagList l = new NBTTagList();
                l.func_74742_a((NBTBase)p);
                l.func_74742_a((NBTBase)s);
                disp.func_74742_a((NBTBase)l);
            }
            tag.func_74782_a("displacedLiquids", (NBTBase)disp);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.progWidgets = TileEntityProgrammer.getWidgetsFromNBT(tag);
        this.naturallySpawned = tag.func_74767_n("naturallySpawned");
        this.currentAir = tag.func_74760_g("currentAir");
        this.volume = tag.func_74760_g("volume");
        this.field_70180_af.func_187227_b(PRESSURE, (Object)Float.valueOf(this.currentAir / this.volume));
        this.propSpeed = tag.func_74760_g("propSpeed");
        this.disabledByHacking = tag.func_74767_n("disabledByHacking");
        this.setGoingToOwner(tag.func_74767_n("hackedByOwner"));
        this.setDroneColor(tag.func_74762_e("color"));
        this.aiManager.readFromNBT(tag.func_74775_l("variables"));
        this.standby = tag.func_74767_n("standby");
        this.upgradeInventory.deserializeNBT(tag.func_74775_l("UpgradeInventory"));
        this.inventory = new EntityDroneItemHandler(1 + this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER), this);
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT(tag.func_74775_l("Inventory"));
        for (int i = 0; i < tmpInv.getSlots() && i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, tmpInv.getStackInSlot(i).func_77946_l());
        }
        this.tank.setCapacity(16000 * (1 + this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER)));
        this.tank.readFromNBT(tag);
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME));
        if (tag.func_74764_b("amadronOffer")) {
            NBTTagCompound subTag = tag.func_74775_l("amadronOffer");
            this.handlingOffer = subTag.func_74767_n("isCustom") ? AmadronOfferCustom.loadFromNBT(subTag) : AmadronOffer.loadFromNBT(subTag);
            this.usedTablet = subTag.func_74764_b("id") ? new ItemStack(subTag) : ItemStack.field_190927_a;
            this.buyingPlayer = subTag.func_74779_i("buyingPlayer");
        } else {
            this.handlingOffer = null;
            this.usedTablet = ItemStack.field_190927_a;
            this.buyingPlayer = null;
        }
        this.offerTimes = tag.func_74762_e("offerTimes");
        if (tag.func_74764_b("displacedLiquids")) {
            NBTTagList disp = tag.func_150295_c("displacedLiquids", 9);
            for (int i = 0; i < disp.func_74745_c(); ++i) {
                NBTTagList l = (NBTTagList)disp.func_179238_g(i);
                NBTTagCompound p = l.func_150305_b(0);
                NBTTagCompound s = l.func_150305_b(1);
                BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)p);
                IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)s);
                this.displacedLiquids.put(pos, state);
            }
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getOwnerUUID() {
        if (this.playerUUID == null) {
            Log.warning(String.format("Drone with owner '%s' has no UUID! Substituting the Drone's UUID (%s).", this.playerName, this.func_110124_au().toString()));
            this.playerUUID = this.func_110124_au().toString();
        }
        return this.playerUUID;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        if (!this.func_130014_f_().field_72995_K && this.playerName != null) {
            tag.func_74778_a("owner", this.playerName);
            tag.func_74778_a("ownerUUID", this.getOwnerUUID());
        }
        return tag;
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        if (!this.func_130014_f_().field_72995_K && tag.func_74764_b("owner")) {
            this.playerName = tag.func_74779_i("owner");
            this.playerUUID = tag.func_74764_b("ownerUUID") ? tag.func_74779_i("ownerUUID") : null;
        }
    }

    public int getUpgrades(IItemRegistry.EnumUpgrade upgrade) {
        return this.getUpgrades(Itemss.upgrades.get(upgrade));
    }

    @Override
    public int getUpgrades(Item upgrade) {
        int upgrades = 0;
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            if (this.upgradeInventory.getStackInSlot(i).func_77973_b() != upgrade) continue;
            upgrades += this.upgradeInventory.getStackInSlot(i).func_190916_E();
        }
        return upgrades;
    }

    public DroneFakePlayer getFakePlayer() {
        if (this.fakePlayer == null && !this.field_70170_p.field_72995_K) {
            this.initializeFakePlayer();
        }
        return this.fakePlayer;
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunDrone(this).setPlayer((EntityPlayer)this.getFakePlayer()).setWorld(this.field_70170_p).setPressurizable(this, 200);
        }
        return this.minigun;
    }

    public boolean func_70652_k(Entity entity) {
        this.getFakePlayer().func_71059_n(entity);
        this.addAir(null, -200);
        return true;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource == DamageSource.field_76368_d) {
            this.isSuffocating = true;
            if (this.suffocationCounter-- > 0 || !ConfigHandler.general.enableDroneSuffocationDamage) {
                return false;
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.inventory;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getEmittingRedstone(EnumFacing side) {
        return this.emittingRedstoneValues[side.ordinal()];
    }

    @Override
    public void setEmittingRedstone(EnumFacing side, int value) {
        if (this.emittingRedstoneValues[side.ordinal()] != value) {
            this.emittingRedstoneValues[side.ordinal()] = value;
            BlockPos pos = new BlockPos((int)Math.floor(this.field_70165_t + (double)(this.field_70130_N / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.field_70130_N / 2.0f)));
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            this.field_70170_p.func_184138_a(pos, state, state, 3);
        }
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        if (this.field_70170_p.func_175623_d(pos)) {
            return true;
        }
        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
        if (PneumaticCraftUtils.isBlockLiquid(block)) {
            return this.securityUpgradeCount > 0;
        }
        if (block.func_176205_b((IBlockAccess)this.field_70170_p, pos) && block != Blocks.field_150468_ap) {
            return true;
        }
        if (DroneRegistry.getInstance().pathfindableBlocks.containsKey(block)) {
            IPathfindHandler pathfindHandler = DroneRegistry.getInstance().pathfindableBlocks.get(block);
            return pathfindHandler == null || pathfindHandler.canPathfindThrough(this.field_70170_p, pos);
        }
        return false;
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
        NetworkHandler.sendToAllAround(new PacketShowWireframe(this, pos), this.field_70170_p);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public boolean canHack(Entity entity, EntityPlayer player) {
        return this.isAccelerating();
    }

    @Override
    public void addInfo(Entity entity, List<String> curInfo, EntityPlayer player) {
        if (this.playerName.equals(player.func_70005_c_())) {
            if (this.isGoingToOwner()) {
                curInfo.add("pneumaticHelmet.hacking.result.resumeTasks");
            } else {
                curInfo.add("pneumaticHelmet.hacking.result.callBack");
            }
        } else {
            curInfo.add("pneumaticHelmet.hacking.result.disable");
        }
    }

    @Override
    public void addPostHackInfo(Entity entity, List<String> curInfo, EntityPlayer player) {
        if (this.playerName.equals(player.func_70005_c_())) {
            if (this.isGoingToOwner()) {
                curInfo.add("pneumaticHelmet.hacking.finished.calledBack");
            } else {
                curInfo.add("pneumaticHelmet.hacking.finished.resumedTasks");
            }
        } else {
            curInfo.add("pneumaticHelmet.hacking.finished.disabled");
        }
    }

    @Override
    public int getHackTime(Entity entity, EntityPlayer player) {
        return this.playerName.equals(player.func_70005_c_()) ? 20 : 100;
    }

    @Override
    public void onHackFinished(Entity entity, EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && player.func_146103_bH().equals((Object)this.getFakePlayer().func_146103_bH())) {
            this.setGoingToOwner(this.gotoOwnerAI == null);
        } else {
            this.disabledByHacking = true;
        }
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return false;
    }

    private void setGoingToOwner(boolean state) {
        if (!this.field_70170_p.field_72995_K) {
            if (state && this.gotoOwnerAI == null) {
                this.gotoOwnerAI = new DroneGoToOwner(this);
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.gotoOwnerAI);
                this.field_70180_af.func_187227_b(GOING_TO_OWNER, (Object)true);
                this.setActiveProgram(new ProgWidgetGoToLocation());
            } else if (!state && this.gotoOwnerAI != null) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.gotoOwnerAI);
                this.gotoOwnerAI = null;
                this.field_70180_af.func_187227_b(GOING_TO_OWNER, (Object)false);
            }
        }
    }

    private boolean isGoingToOwner() {
        return (Boolean)this.field_70180_af.func_187225_a(GOING_TO_OWNER);
    }

    @Override
    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public EntityPlayer getOwner() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(this.playerName);
    }

    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    @Override
    public World world() {
        return this.field_70170_p;
    }

    @Override
    public Vec3d getDronePos() {
        return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public void dropItem(ItemStack stack) {
        this.func_70099_a(stack, 0.0f);
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public EntityAITasks getTargetAI() {
        return this.field_70715_bh;
    }

    @Override
    public boolean isProgramApplicable(IProgWidget widget) {
        return true;
    }

    @Override
    public void setName(String string) {
        this.func_96094_a(string);
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        if (entity == null) {
            for (Entity e : this.getCarryingEntities()) {
                e.func_184210_p();
                if (!(e instanceof EntityMinecart) && !(e instanceof EntityBoat)) continue;
                e.field_70163_u -= 2.0;
                if (this.field_70170_p.func_180495_p(e.func_180425_c()).func_185898_k()) {
                    e.field_70163_u += 1.0;
                }
                if (!(e instanceof EntityMinecart)) continue;
                e.field_184245_j = 0;
            }
        } else {
            entity.func_184220_m((Entity)this);
        }
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return this.func_184188_bt();
    }

    @Override
    public boolean isAIOverriden() {
        return this.chargeAI.isExecuting || this.gotoOwnerAI != null;
    }

    @Override
    public void onItemPickupEvent(EntityItem curPickingUpEntity, int stackSize) {
        this.func_71001_a((Entity)curPickingUpEntity, stackSize);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return (IPathNavigator)this.func_70661_as();
    }

    public void tryFireMinigun(EntityLivingBase target) {
        ItemStack ammo = this.getAmmo();
        if (this.getMinigun().setAmmoStack(ammo).tryFireMinigun((Entity)target)) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i) != ammo) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public ItemStack getAmmo() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemGunAmmo)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void setHandlingOffer(AmadronOffer offer, int times, @Nonnull ItemStack usedTablet, String buyingPlayer) {
        this.handlingOffer = offer;
        this.offerTimes = times;
        this.usedTablet = usedTablet.func_77946_l();
        this.buyingPlayer = buyingPlayer;
    }

    public AmadronOffer getHandlingOffer() {
        return this.handlingOffer;
    }

    public int getOfferTimes() {
        return this.offerTimes;
    }

    public ItemStack getUsedTablet() {
        return this.usedTablet;
    }

    public String getBuyingPlayer() {
        return this.buyingPlayer;
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        this.func_70097_a(new DamageSourcePneumaticCraft.DamageSourceDroneOverload(msgKey, params), 2000.0f);
    }

    @Override
    public DroneAIManager getAIManager() {
        return this.aiManager;
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    @Override
    public void updateLabel() {
        this.field_70180_af.func_187227_b(LABEL, (Object)(this.getAIManager() != null ? this.getAIManager().getLabel() : "Main"));
    }

    public String getLabel() {
        return (String)this.field_70180_af.func_187225_a(LABEL);
    }

    public DebugEntry getCurrentDebugEntry() {
        return this.debugList.getCurrent();
    }

    public DebugEntry getDebugEntry(int widgetID) {
        return this.debugList.get(widgetID);
    }

    @Override
    public void addDebugEntry(String message) {
        this.addDebugEntry(message, null);
    }

    @Override
    public void addDebugEntry(String message, BlockPos pos) {
        DebugEntry entry = new DebugEntry(message, this.getActiveWidgetIndex(), pos);
        this.addDebugEntry(entry);
        PacketSendDroneDebugEntry packet = new PacketSendDroneDebugEntry(entry, this);
        for (EntityPlayerMP player : this.syncedPlayers) {
            NetworkHandler.sendTo(packet, player);
        }
    }

    public void addDebugEntry(DebugEntry entry) {
        this.debugList.addEntry(entry);
    }

    public void trackAsDebugged(EntityPlayerMP player) {
        NetworkHandler.sendTo(new PacketSyncDroneEntityProgWidgets(this), player);
        for (DebugEntry entry : this.debugList.getAll()) {
            NetworkHandler.sendTo(new PacketSendDroneDebugEntry(entry, this), player);
        }
        this.syncedPlayers.add(player);
    }

    private void updateSyncedPlayers() {
        this.syncedPlayers.removeIf(player -> player.field_70128_L || player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || me.desht.pneumaticcraft.common.util.NBTUtil.getInteger(player.func_184582_a(EntityEquipmentSlot.HEAD), "debuggingDrone") != this.func_145782_y());
    }

    static {
        colorMap.put("aureylian", 16738740);
        colorMap.put("loneztar", 41120);
        colorMap.put("jadedcat", 10494192);
        colorMap.put("desht", 0xFF6000);
        ACCELERATING = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187198_h);
        PRESSURE = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187193_c);
        PROGRAM_KEY = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187194_d);
        DUG_POS = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187200_j);
        GOING_TO_OWNER = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187198_h);
        DRONE_COLOR = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187192_b);
        MINIGUN_ACTIVE = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187198_h);
        HAS_MINIGUN = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187198_h);
        AMMO = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187196_f);
        LABEL = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187194_d);
        ACTIVE_WIDGET = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187192_b);
        TARGET_POS = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187200_j);
        HELD_ITEM = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187196_f);
        TARGET_ID = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187192_b);
    }

    private class DroneDebugList {
        private final Map<Integer, DebugEntry> debugEntries = new HashMap<Integer, DebugEntry>();

        private DroneDebugList() {
        }

        void addEntry(DebugEntry entry) {
            this.debugEntries.put(EntityDrone.this.getActiveWidgetIndex(), entry);
        }

        public Collection<DebugEntry> getAll() {
            return this.debugEntries.values();
        }

        public DebugEntry get(int widgetId) {
            return this.debugEntries.get(widgetId);
        }

        public DebugEntry getCurrent() {
            return this.debugEntries.get(EntityDrone.this.getActiveWidgetIndex());
        }
    }

    private class EntityDroneItemHandler
    extends DroneItemHandler {
        public EntityDroneItemHandler(int size, IDrone holder) {
            super(size, holder);
        }

        @Override
        public void updateHeldItem() {
            if (this.heldItemChanged && ConfigHandler.client.dronesRenderHeldItem) {
                EntityDrone.this.field_70180_af.func_187227_b(HELD_ITEM, (Object)this.getStackInSlot(0));
            }
            super.updateHeldItem();
        }
    }

    private class MinigunDrone
    extends Minigun {
        private final EntityDrone drone;

        MinigunDrone(EntityDrone drone) {
            super(true);
            this.drone = drone;
        }

        @Override
        public Object getSoundSource() {
            return this.drone;
        }

        @Override
        public boolean isMinigunActivated() {
            return EntityDrone.this.isMinigunActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            EntityDrone.this.setMinigunActivated(activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            EntityDrone.this.setAmmoColor(ammo);
        }

        @Override
        public int getAmmoColor() {
            return EntityDrone.this.getAmmoColor();
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(soundName, SoundCategory.NEUTRAL, EntityDrone.this.field_70165_t, EntityDrone.this.field_70163_u, EntityDrone.this.field_70161_v, volume, pitch, true), this.world);
        }
    }
}

