/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.common.config.JsonConfig;
import me.desht.pneumaticcraft.common.progwidgets.WidgetRegistrator;

public class ProgWidgetConfig
extends JsonConfig {
    public static final Set<String> blacklistedPieces = new HashSet<String>();

    public ProgWidgetConfig() {
        super(true);
    }

    @Override
    public String getConfigFilename() {
        return "ProgrammingPuzzleBlacklist";
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("description", "In the 'blacklist' tag you can put the programming puzzle names that need to blacklisted from this instance. When they were used in existing programs already they will be deleted. A list of all programming puzzle names can be seen in 'allWidgets'.");
        JsonArray array = new JsonArray();
        ArrayList<String> names = new ArrayList<String>(WidgetRegistrator.getAllWidgetNames());
        Collections.sort(names);
        for (String name : names) {
            array.add((JsonElement)new JsonPrimitive(name));
        }
        json.add("allWidgets", (JsonElement)array);
        array = new JsonArray();
        for (String name : blacklistedPieces) {
            array.add((JsonElement)new JsonPrimitive(name));
        }
        json.add("blacklist", (JsonElement)array);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        JsonArray array = json.get("blacklist").getAsJsonArray();
        blacklistedPieces.clear();
        for (JsonElement element : array) {
            blacklistedPieces.add(element.getAsString());
        }
    }
}

