/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.config.JsonConfig;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class BlockHeatPropertiesConfig
extends JsonConfig {
    private static final String HEATBLOCK_CFG_ASSET = "/assets/pneumaticcraft/config/BlockHeatProperties.json";
    public static final BlockHeatPropertiesConfig INSTANCE = new BlockHeatPropertiesConfig();
    private final Map<String, CustomHeatEntry> customHeatEntries = new HashMap<String, CustomHeatEntry>();
    private final Set<Block> ignoreVariants = new HashSet<Block>();
    private static double defaultBlockThermalResistance = 500.0;
    private static double defaultFluidThermalResistance = 150.0;
    private static int defaultFluidTotalHeat = 10000;
    public static double ambientTempBiomeModifier = 0.0;
    public static double ambientTempHeightModifier = 0.0;

    private BlockHeatPropertiesConfig() {
        super(false);
    }

    @Override
    public void preInit(File file) throws IOException {
        super.preInit(file);
        this.mergeConfigs();
    }

    private void mergeConfigs() throws IOException {
        JsonObject toWrite;
        String cfg = Resources.toString((URL)PneumaticCraftRepressurized.class.getResource(HEATBLOCK_CFG_ASSET), (Charset)Charsets.UTF_8);
        JsonParser parser = new JsonParser();
        JsonObject internalJsonObject = (JsonObject)parser.parse(cfg);
        if (this.file.exists()) {
            JsonObject fileJsonObject = (JsonObject)parser.parse(FileUtils.readFileToString((File)this.file, (Charset)Charsets.UTF_8));
            fileJsonObject.add("Description", internalJsonObject.get("Description"));
            JsonObject defaults1 = internalJsonObject.getAsJsonObject("defaults");
            JsonObject defaults2 = fileJsonObject.getAsJsonObject("defaults");
            for (Map.Entry entry : defaults1.entrySet()) {
                if (defaults2.has((String)entry.getKey())) continue;
                defaults2.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            JsonObject blocks1 = internalJsonObject.getAsJsonObject("blocks");
            JsonObject blocks2 = fileJsonObject.getAsJsonObject("blocks");
            for (Map.Entry entry : blocks1.entrySet()) {
                if (blocks2.has((String)entry.getKey())) continue;
                blocks2.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            toWrite = fileJsonObject;
        } else {
            toWrite = internalJsonObject;
        }
        try (PrintWriter out = new PrintWriter(this.file);){
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            out.println(gson.toJson((JsonElement)toWrite));
        }
    }

    @Override
    protected void writeToJson(JsonObject json) {
    }

    @Override
    public void writeToFile() throws IOException {
    }

    @Override
    protected void readFromJson(JsonObject json) {
        JsonObject def = json.getAsJsonObject("defaults");
        defaultBlockThermalResistance = def.get("blockThermalResistance").getAsDouble();
        defaultFluidThermalResistance = def.get("fluidThermalResistance").getAsDouble();
        defaultFluidTotalHeat = def.get("fluidTotalHeat").getAsInt();
        ambientTempBiomeModifier = def.get("ambientTemperatureBiomeModifier").getAsDouble();
        ambientTempHeightModifier = def.get("ambientTemperatureHeightModifier").getAsDouble();
        JsonObject sub = json.getAsJsonObject("blocks");
        for (Map.Entry entry : sub.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                JsonObject jsonRecord = ((JsonElement)entry.getValue()).getAsJsonObject();
                try {
                    CustomHeatEntry che = CustomHeatEntry.fromJson((String)entry.getKey(), jsonRecord);
                    if (che != null) {
                        IBlockState state = che.getBlockState();
                        if (((String)entry.getKey()).indexOf(91) == -1) {
                            this.ignoreVariants.add(state.func_177230_c());
                        }
                        this.customHeatEntries.put(this.makeKeyForState(state), che);
                        continue;
                    }
                    String what = ((String)entry.getKey()).indexOf(58) == -1 ? "fluid" : "block";
                    Log.warning("skipping BlockHeatProperties.cfg entry '" + (String)entry.getKey() + "': unknown " + what + " (mod not loaded?)");
                }
                catch (InvalidBlockStateException e) {
                    Log.error("invalid blockstate for " + (String)entry.getKey() + ": " + e.getMessage());
                }
                continue;
            }
            Log.error("Invalid JSON? entry '" + (String)entry.getKey() + "' in " + this.getConfigFilename());
        }
    }

    private String makeKeyForState(IBlockState blockState) {
        Block b = blockState.func_177230_c();
        return this.ignoreVariants.contains(b) ? b.getRegistryName().toString() : b.getRegistryName() + ":" + b.func_176201_c(blockState);
    }

    public Map<String, CustomHeatEntry> getCustomHeatEntries() {
        return this.customHeatEntries;
    }

    public CustomHeatEntry getCustomHeatEntry(IBlockState state) {
        Fluid fluid;
        String key = this.makeKeyForState(state);
        CustomHeatEntry entry = this.customHeatEntries.get(key);
        if (entry == null && (fluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c())) != null) {
            entry = this.buildDefaultFluidEntry(state, fluid);
            this.customHeatEntries.put(key, entry);
        }
        return entry;
    }

    private CustomHeatEntry buildDefaultFluidEntry(IBlockState state, Fluid fluid) {
        IBlockState transformColdFlowing;
        IBlockState transformCold;
        IBlockState transformHotFlowing;
        IBlockState transformHot;
        if (fluid.getTemperature() >= 1300) {
            transformHot = null;
            transformHotFlowing = null;
            transformCold = Blocks.field_150343_Z.func_176223_P();
            transformColdFlowing = Blocks.field_150347_e.func_176223_P();
        } else {
            transformHot = Blocks.field_150348_b.func_176223_P();
            transformHotFlowing = Blocks.field_150350_a.func_176223_P();
            transformCold = Blocks.field_150432_aD.func_176223_P();
            transformColdFlowing = Blocks.field_150433_aE.func_176223_P();
        }
        return new CustomHeatEntry(fluid.getName(), state, transformHot, transformHotFlowing, transformCold, transformColdFlowing, defaultFluidTotalHeat, fluid.getTemperature(), defaultFluidThermalResistance);
    }

    @Override
    public String getConfigFilename() {
        return "BlockHeatProperties";
    }

    public static class CustomHeatEntry {
        private final int totalHeat;
        private final int temperature;
        private final double thermalResistance;
        private final IBlockState blockState;
        private final IBlockState transformHot;
        private final IBlockState transformHotFlowing;
        private final IBlockState transformCold;
        private final IBlockState transformColdFlowing;
        private final String id;
        private final boolean isDefaultState;

        CustomHeatEntry(String id, IBlockState blockState, IBlockState transformHot, IBlockState transformHotFlowing, IBlockState transformCold, IBlockState transformColdFlowing, int totalHeat, int temperature, double thermalResistance) {
            this.totalHeat = totalHeat;
            this.blockState = blockState;
            this.transformHot = transformHot;
            this.transformHotFlowing = transformHotFlowing != null ? transformHotFlowing : transformHot;
            this.transformCold = transformCold;
            this.transformColdFlowing = transformColdFlowing != null ? transformColdFlowing : transformCold;
            this.id = id;
            this.temperature = temperature;
            this.thermalResistance = thermalResistance;
            this.isDefaultState = blockState.func_177230_c().func_176223_P() == blockState;
        }

        static CustomHeatEntry fromJson(String blockStateId, JsonObject value) throws InvalidBlockStateException {
            int temperature;
            IBlockState transformHot = null;
            IBlockState transformHotFlowing = null;
            IBlockState transformCold = null;
            IBlockState transformColdFlowing = null;
            IBlockState blockState = CustomHeatEntry.parseBlockState(blockStateId);
            if (blockState == null || blockState.func_177230_c() == Blocks.field_150350_a) {
                return null;
            }
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)blockState.func_177230_c());
            int totalHeat = 0;
            if (value.has("totalHeat")) {
                totalHeat = value.get("totalHeat").getAsInt();
            } else if (fluid != null) {
                totalHeat = defaultFluidTotalHeat;
            }
            if (totalHeat != 0) {
                transformHot = CustomHeatEntry.maybeParseBlockState(value, "transformHot");
                transformHotFlowing = CustomHeatEntry.maybeParseBlockState(value, "transformHotFlowing");
                transformCold = CustomHeatEntry.maybeParseBlockState(value, "transformCold");
                transformColdFlowing = CustomHeatEntry.maybeParseBlockState(value, "transformColdFlowing");
            }
            if (value.has("temperature")) {
                temperature = value.get("temperature").getAsInt();
            } else {
                if (fluid == null) {
                    throw new JsonSyntaxException(blockState.toString() + ": Non-fluid definitions must have a temperature field!");
                }
                temperature = fluid.getTemperature();
            }
            double thermalResistance = value.has("thermalResistance") ? value.get("thermalResistance").getAsDouble() : (fluid == null ? defaultBlockThermalResistance : defaultFluidThermalResistance);
            return new CustomHeatEntry(blockStateId, blockState, transformHot, transformHotFlowing, transformCold, transformColdFlowing, totalHeat, temperature, thermalResistance);
        }

        public int getTotalHeat() {
            return this.totalHeat;
        }

        public int getTemperature() {
            return this.temperature;
        }

        public double getThermalResistance() {
            return this.thermalResistance;
        }

        public IBlockState getBlockState() {
            return this.blockState;
        }

        public IBlockState getTransformHot() {
            return this.transformHot;
        }

        public IBlockState getTransformCold() {
            return this.transformCold;
        }

        public IBlockState getTransformHotFlowing() {
            return this.transformHotFlowing;
        }

        public IBlockState getTransformColdFlowing() {
            return this.transformColdFlowing;
        }

        public String getId() {
            return this.id;
        }

        public boolean isDefaultState() {
            return this.isDefaultState;
        }

        private static IBlockState maybeParseBlockState(JsonObject value, String field) throws InvalidBlockStateException {
            return value.has(field) ? CustomHeatEntry.parseBlockState(value.get(field).getAsString()) : null;
        }

        private static IBlockState parseBlockState(String s) throws InvalidBlockStateException {
            ResourceLocation rl;
            Block b;
            if (s.equals("minecraft:air")) {
                return Blocks.field_150350_a.func_176223_P();
            }
            Fluid fluid = FluidRegistry.getFluid((String)s);
            if (fluid != null) {
                return fluid.getBlock() == null ? null : fluid.getBlock().func_176223_P();
            }
            if (s.indexOf(58) == -1) {
                Log.warning("BlockHeatProperties.cfg: unknown fluid definition [" + s + "]");
                return null;
            }
            String blockName = s;
            String variant = "";
            int i = s.indexOf(91);
            if (i >= 0) {
                blockName = s.substring(0, i);
                variant = s.substring(i + 1);
                variant = variant.replaceAll("]$", "");
            }
            if ((b = (Block)Block.field_149771_c.func_82594_a((Object)(rl = new ResourceLocation(blockName)))) == Blocks.field_150350_a || b == null) {
                if (Loader.isModLoaded((String)rl.func_110624_b())) {
                    throw new InvalidBlockStateException("unknown block name: " + rl, new Object[0]);
                }
                return null;
            }
            IBlockState state = b.func_176223_P();
            if (variant.isEmpty()) {
                return state;
            }
            BlockStateContainer blockstatecontainer = b.func_176194_O();
            for (String v : variant.split(",")) {
                String[] p = v.split("=");
                if (p.length != 2) {
                    throw new InvalidBlockStateException("malformed property " + v, new Object[0]);
                }
                String propName = p[0];
                String propVal = p[1];
                IProperty property = blockstatecontainer.func_185920_a(propName);
                if (property == null) {
                    throw new InvalidBlockStateException("unknown property " + propName, new Object[0]);
                }
                state = CustomHeatEntry.setValueHelper(state, property, propVal);
            }
            return state;
        }

        private static <T extends Comparable<T>> IBlockState setValueHelper(IBlockState state, IProperty<T> property, String propVal) {
            Optional optional = property.func_185929_b(propVal);
            if (optional.isPresent()) {
                return state.func_177226_a(property, (Comparable)optional.get());
            }
            Log.warning(String.format("Unable to read property: %s with value: %s for blockstate: %s", property, propVal, state));
            return state;
        }
    }
}

