/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.config.JsonConfig;

public class ArmorHUDLayout
extends JsonConfig {
    public static final ArmorHUDLayout INSTANCE = new ArmorHUDLayout();
    private boolean needLegacyImport = true;
    public LayoutItem powerStat = new LayoutItem(-1.0f, 0.01f, false);
    public LayoutItem messageStat = new LayoutItem(0.005f, 0.005f, true);
    public LayoutItem blockTrackerStat = new LayoutItem(-1.0f, 0.1f, false);
    public LayoutItem entityTrackerStat = new LayoutItem(-1.0f, 0.2f, false);
    public LayoutItem itemSearchStat = new LayoutItem(0.005f, 0.1f, true);
    public LayoutItem airConStat = new LayoutItem(0.5f, 0.005f, false);

    private ArmorHUDLayout() {
        super(false);
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("Description", "Stores the layout of Pneumatic Armor HUD elements");
        if (this.needLegacyImport) {
            json.addProperty("needLegacyImport", Boolean.valueOf(this.needLegacyImport));
        } else {
            JsonObject sub = new JsonObject();
            sub.add("power", (JsonElement)this.powerStat.toJson());
            sub.add("message", (JsonElement)this.messageStat.toJson());
            sub.add("blockTracker", (JsonElement)this.blockTrackerStat.toJson());
            sub.add("entityTracker", (JsonElement)this.entityTrackerStat.toJson());
            sub.add("itemSearch", (JsonElement)this.itemSearchStat.toJson());
            sub.add("airCon", (JsonElement)this.airConStat.toJson());
            json.add("stats", (JsonElement)sub);
        }
    }

    @Override
    protected void readFromJson(JsonObject json) {
        boolean bl = this.needLegacyImport = json.has("needLegacyImport") && json.get("needLegacyImport").getAsBoolean();
        if (json.has("stats")) {
            JsonObject sub = json.getAsJsonObject("stats");
            this.powerStat = LayoutItem.fromJson(sub.get("power").getAsJsonObject());
            this.messageStat = LayoutItem.fromJson(sub.get("message").getAsJsonObject());
            this.blockTrackerStat = LayoutItem.fromJson(sub.get("blockTracker").getAsJsonObject());
            this.entityTrackerStat = LayoutItem.fromJson(sub.get("entityTracker").getAsJsonObject());
            this.itemSearchStat = LayoutItem.fromJson(sub.get("itemSearch").getAsJsonObject());
            this.airConStat = LayoutItem.fromJson(sub.get("airCon").getAsJsonObject());
        }
    }

    @Override
    public String getConfigFilename() {
        return "PneumaticArmorHUDLayout";
    }

    public void maybeImportLegacySettings(int sx, int sy) {
        if (this.needLegacyImport) {
            this.needLegacyImport = false;
            ConfigHandler.HelmetOptions ho = ConfigHandler.helmetOptions;
            this.powerStat = new LayoutItem(sx, sy, ho.powerX, ho.powerY, ho.powerLeft);
            this.messageStat = new LayoutItem(sx, sy, ho.messageX, ho.messageY, ho.messageLeft);
            this.blockTrackerStat = new LayoutItem(sx, sy, ho.blockTrackerX, ho.blockTrackerY, ho.blockTrackerLeft);
            this.entityTrackerStat = new LayoutItem(sx, sy, ho.entityTrackerX, ho.entityTrackerY, ho.entityTrackerLeft);
            this.itemSearchStat = new LayoutItem(sx, sy, ho.itemSearchX, ho.itemSearchY, ho.itemSearchLeft);
            this.airConStat = new LayoutItem(sx, sy, ho.acStatX, ho.acStatY, ho.acStatLeft);
            try {
                this.writeToFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLayout(LayoutTypes what, float x, float y, boolean leftSided) {
        LayoutItem l = new LayoutItem(x, y, leftSided);
        switch (what) {
            case POWER: {
                this.powerStat = l;
                break;
            }
            case MESSAGE: {
                this.messageStat = l;
                break;
            }
            case ENTITY_TRACKER: {
                this.entityTrackerStat = l;
                break;
            }
            case BLOCK_TRACKER: {
                this.blockTrackerStat = l;
                break;
            }
            case ITEM_SEARCH: {
                this.itemSearchStat = l;
                break;
            }
            case AIR_CON: {
                this.airConStat = l;
            }
        }
        try {
            this.writeToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum LayoutTypes {
        POWER,
        MESSAGE,
        ENTITY_TRACKER,
        BLOCK_TRACKER,
        ITEM_SEARCH,
        AIR_CON;

    }

    public static class LayoutItem {
        private final float x;
        private final float y;
        private final boolean leftSided;

        LayoutItem(float x, float y, boolean leftSided) {
            this.x = x;
            this.y = y;
            this.leftSided = leftSided;
        }

        LayoutItem(int screenX, int screenY, int x, int y, boolean leftSided) {
            this.x = (float)x / (float)screenX;
            this.y = (float)y / (float)screenY;
            this.leftSided = leftSided;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public boolean isLeftSided() {
            return this.leftSided;
        }

        JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("x", (Number)Float.valueOf(this.x));
            obj.addProperty("y", (Number)Float.valueOf(this.y));
            obj.addProperty("leftSided", Boolean.valueOf(this.leftSided));
            return obj;
        }

        static LayoutItem fromJson(JsonObject obj) {
            return new LayoutItem(obj.get("x").getAsFloat(), obj.get("y").getAsFloat(), obj.get("leftSided").getAsBoolean());
        }
    }
}

