/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.client.model.module.ModelRedstone;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticWrench;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketOpenTubeModuleGui;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToClient;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.DyeUtils;

public class ModuleRedstone
extends TubeModule
implements INetworkedModule {
    private EnumRedstoneDirection redstoneDirection = EnumRedstoneDirection.OUTPUT;
    private int inputLevel = -1;
    private int outputLevel;
    private int colorChannel;
    private Operation operation = Operation.PASSTHROUGH;
    private boolean invert = false;
    private int otherColor = 0;
    private int constantVal = 0;
    private byte[] prevLevels = new byte[16];
    public float extension = 1.0f;
    public float lastExtension;

    @Override
    public String getType() {
        return "redstone_module";
    }

    @Override
    protected GuiHandler.EnumGuiId getGuiId() {
        return GuiHandler.EnumGuiId.REDSTONE_MODULE;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelRedstone.class;
    }

    @Override
    public void onNeighborBlockUpdate() {
        this.updateInputLevel();
    }

    @Override
    public double getWidth() {
        return 0.5;
    }

    @Override
    protected double getHeight() {
        return 0.25;
    }

    @Override
    public void update() {
        super.update();
        if (!this.pressureTube.world().field_72995_K) {
            byte[] levels = new byte[16];
            if (this.redstoneDirection == EnumRedstoneDirection.OUTPUT) {
                for (TubeModule module : ModuleNetworkManager.getInstance(this.getTube().world()).getConnectedModules(this)) {
                    ModuleRedstone mr;
                    if (!(module instanceof ModuleRedstone) || (mr = (ModuleRedstone)module).getRedstoneDirection() != EnumRedstoneDirection.INPUT || mr.getInputLevel() <= levels[mr.getColorChannel()]) continue;
                    levels[mr.getColorChannel()] = (byte)mr.inputLevel;
                }
                int out = this.computeOutputSignal(this.outputLevel, levels);
                if (this.invert) {
                    int n = out = out > 0 ? 0 : 15;
                }
                if (this.setOutputLevel(out)) {
                    NetworkHandler.sendToAllAround(new PacketSyncRedstoneModuleToClient(this), this.getTube().world());
                }
            } else if (this.inputLevel < 0) {
                this.updateInputLevel();
            }
            System.arraycopy(levels, 0, this.prevLevels, 0, 16);
        } else {
            this.lastExtension = this.extension;
            this.extension = this.redstoneDirection == EnumRedstoneDirection.OUTPUT ? Math.min(1.0f, this.extension + 0.125f) : Math.max(0.0f, this.extension - 0.125f);
        }
    }

    private int computeOutputSignal(int lastOutput, byte[] levels) {
        byte s1 = levels[this.getColorChannel()];
        byte s2 = levels[this.otherColor];
        switch (this.operation) {
            case PASSTHROUGH: {
                return s1;
            }
            case AND: {
                return s1 > 0 && s2 > 0 ? 15 : 0;
            }
            case OR: {
                return s1 > 0 || s2 > 0 ? 15 : 0;
            }
            case XOR: {
                return s1 == 0 && s2 == 0 || s1 > 0 && s2 > 0 ? 0 : 15;
            }
            case COMPARATOR: {
                return s1 > s2 ? 15 : 0;
            }
            case SUBTRACT: {
                return MathHelper.func_76125_a((int)(s1 - s2), (int)0, (int)15);
            }
            case COMPARE: {
                return s1 > this.constantVal ? 15 : 0;
            }
            case CLOCK: {
                return s1 == 0 && this.getTube().world().func_82737_E() % (long)this.constantVal < 2L ? 15 : 0;
            }
            case TOGGLE: {
                if (s1 > this.prevLevels[this.getColorChannel()]) {
                    return lastOutput > 0 ? 0 : 15;
                }
                return lastOutput;
            }
            case CONSTANT: {
                return MathHelper.func_76125_a((int)this.constantVal, (int)0, (int)15);
            }
            case COUNTER: {
                if (s1 > this.prevLevels[this.getColorChannel()]) {
                    return ++lastOutput > Math.min(15, this.constantVal) ? 0 : lastOutput;
                }
                return lastOutput;
            }
        }
        return 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("input", this.redstoneDirection == EnumRedstoneDirection.INPUT);
        tag.func_74774_a("channel", (byte)this.colorChannel);
        tag.func_74774_a("outputLevel", (byte)this.outputLevel);
        tag.func_74778_a("op", this.operation.toString());
        tag.func_74774_a("color2", (byte)this.otherColor);
        tag.func_74774_a("const", (byte)this.constantVal);
        tag.func_74757_a("invert", this.invert);
        tag.func_74772_a("prevLevels", this.encodeLevels(this.prevLevels));
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.redstoneDirection = tag.func_74767_n("input") ? EnumRedstoneDirection.INPUT : EnumRedstoneDirection.OUTPUT;
        this.colorChannel = tag.func_74771_c("channel");
        this.outputLevel = tag.func_74771_c("outputLevel");
        try {
            this.operation = tag.func_74764_b("op") ? Operation.valueOf(tag.func_74779_i("op")) : Operation.PASSTHROUGH;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.operation = Operation.PASSTHROUGH;
        }
        this.otherColor = tag.func_74771_c("color2");
        this.constantVal = tag.func_74771_c("const");
        this.invert = tag.func_74767_n("invert");
        this.decodeLevels(tag.func_74763_f("prevLevels"), this.prevLevels);
    }

    private long encodeLevels(byte[] l) {
        return IntStream.range(0, l.length).mapToLong(i -> l[i] << 4 * i).reduce(0L, (a, b) -> a | b);
    }

    private void decodeLevels(long l, byte[] res) {
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(l >> 4 * i | 0xFL);
        }
    }

    public EnumRedstoneDirection getRedstoneDirection() {
        return this.redstoneDirection;
    }

    public void setRedstoneDirection(EnumRedstoneDirection redstoneDirection) {
        this.redstoneDirection = redstoneDirection;
    }

    @Override
    public int getRedstoneLevel() {
        return this.redstoneDirection == EnumRedstoneDirection.OUTPUT ? this.outputLevel : 0;
    }

    public boolean setOutputLevel(int level) {
        if ((level = MathHelper.func_76125_a((int)level, (int)0, (int)15)) != this.outputLevel) {
            this.outputLevel = level;
            this.updateNeighbors();
            return true;
        }
        return false;
    }

    public int getInputLevel() {
        return this.inputLevel;
    }

    public void setInputLevel(int level) {
        this.inputLevel = level;
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int channel) {
        this.colorChannel = channel;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    @Override
    public void addInfo(List<String> curInfo) {
        super.addInfo(curInfo);
        if (this.getRedstoneDirection() == EnumRedstoneDirection.INPUT) {
            curInfo.add("Receiving Redstone: " + TextFormatting.YELLOW + this.inputLevel);
        } else {
            curInfo.add("Emitting Redstone: " + TextFormatting.YELLOW + this.outputLevel);
            if (this.upgraded) {
                this.addAdvancedInfo(curInfo);
            }
        }
    }

    private void addAdvancedInfo(List<String> curInfo) {
        String s = "Operation: " + TextFormatting.YELLOW + PneumaticCraftUtils.xlate(this.operation.getTranslationKey()) + " ";
        if (this.operation.useOtherColor) {
            s = s + "(" + PneumaticCraftUtils.dyeColorDesc(this.otherColor) + ")";
        }
        if (this.operation.useConst) {
            s = s + "(" + this.constantVal + ")";
        }
        curInfo.add(s);
        curInfo.add("Output inverted: " + TextFormatting.YELLOW + (this.invert ? "Yes" : "No"));
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        OptionalInt colorIndex = DyeUtils.dyeDamageFromStack((ItemStack)heldStack);
        if (colorIndex.isPresent()) {
            this.setColorChannel(colorIndex.getAsInt());
            if (ConfigHandler.general.useUpDyesWhenColoring && !player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            return true;
        }
        if (heldStack.func_77973_b() instanceof ItemPneumaticWrench || ModdedWrenchUtils.getInstance().isModdedWrench(heldStack)) {
            this.redstoneDirection = this.redstoneDirection == EnumRedstoneDirection.INPUT ? EnumRedstoneDirection.OUTPUT : EnumRedstoneDirection.INPUT;
            this.updateNeighbors();
            if (!this.updateInputLevel()) {
                NetworkHandler.sendToAllAround(new PacketSyncRedstoneModuleToClient(this), this.getTube().world());
            }
            return true;
        }
        if (!this.getTube().world().field_72995_K && this.upgraded && this.getRedstoneDirection() == EnumRedstoneDirection.OUTPUT) {
            NetworkHandler.sendTo(new PacketOpenTubeModuleGui(this.getGuiId().ordinal(), this.pressureTube.pos()), (EntityPlayerMP)player);
            return true;
        }
        return false;
    }

    private boolean updateInputLevel() {
        int newInputLevel;
        int n = newInputLevel = this.redstoneDirection == EnumRedstoneDirection.INPUT ? this.pressureTube.world().func_175651_c(this.pressureTube.pos().func_177972_a(this.getDirection()), this.getDirection()) : 0;
        if (newInputLevel != this.inputLevel) {
            this.inputLevel = newInputLevel;
            NetworkHandler.sendToAllAround(new PacketSyncRedstoneModuleToClient(this), this.getTube().world());
            return true;
        }
        return false;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int getOtherColor() {
        return this.otherColor;
    }

    public int getConstantVal() {
        return this.constantVal;
    }

    public void setOperation(Operation operation, int otherColor, int constantVal) {
        if (operation == Operation.CLOCK) {
            constantVal = Math.max(4, constantVal);
        }
        this.operation = operation;
        this.otherColor = otherColor;
        this.constantVal = constantVal;
    }

    public static enum Operation {
        PASSTHROUGH(false, false),
        AND(true, false),
        OR(true, false),
        XOR(true, false),
        CLOCK(false, true),
        COMPARATOR(true, false),
        SUBTRACT(true, false),
        COMPARE(false, true),
        TOGGLE(false, false),
        CONSTANT(false, true),
        COUNTER(false, true);

        private final boolean useOtherColor;
        private final boolean useConst;

        private Operation(boolean useOtherColor, boolean useConst) {
            this.useOtherColor = useOtherColor;
            this.useConst = useConst;
        }

        public String getTranslationKey() {
            return "gui.redstoneModule.operation_" + this.toString().toLowerCase();
        }

        public boolean useOtherColor() {
            return this.useOtherColor;
        }

        public boolean useConst() {
            return this.useConst;
        }
    }

    public static enum EnumRedstoneDirection {
        INPUT,
        OUTPUT;

    }
}

