/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.ai.DistanceEntitySorter;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class DroneEntityAIPickupItems
extends EntityAIBase {
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase itemPickupWidget;
    private EntityItem curPickingUpEntity;
    private final DistanceEntitySorter theNearestAttackableTargetSorter;

    public DroneEntityAIPickupItems(IDroneBase drone, ProgWidgetAreaItemBase progWidgetPickupItem) {
        this.drone = drone;
        this.func_75248_a(63);
        this.itemPickupWidget = progWidgetPickupItem;
        this.theNearestAttackableTargetSorter = new DistanceEntitySorter(drone);
    }

    public boolean func_75250_a() {
        List<Entity> pickableItems = this.itemPickupWidget.getEntitiesInArea(this.drone.world(), entity -> entity instanceof EntityItem && entity.func_70089_S());
        if (pickableItems.isEmpty()) {
            this.drone.addDebugEntry("gui.progWidget.itemPickup.debug.noItems");
            return false;
        }
        pickableItems.sort(this.theNearestAttackableTargetSorter);
        for (Entity ent : pickableItems) {
            ItemStack stack = ((EntityItem)ent).func_92059_d();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                if (!IOHelper.insert(this.drone, stack, null, true).func_190926_b() || !this.drone.getPathNavigator().moveToEntity(ent)) continue;
                this.curPickingUpEntity = (EntityItem)ent;
                return true;
            }
            this.drone.addDebugEntry("gui.progWidget.itemPickup.debug.itemNotValid");
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.curPickingUpEntity.field_70128_L) {
            return false;
        }
        Vec3d vec3d = new Vec3d(this.curPickingUpEntity.field_70165_t, this.curPickingUpEntity.field_70163_u, this.curPickingUpEntity.field_70161_v);
        if (vec3d.func_72436_e(this.drone.getDronePos()) < 2.25) {
            ItemStack stack = this.curPickingUpEntity.func_92059_d();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                DroneEntityAIPickupItems.tryPickupItem(this.drone, this.curPickingUpEntity);
            }
            return false;
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    static void tryPickupItem(IDrone drone, EntityItem itemEntity) {
        ItemStack remainder;
        ItemStack stack = itemEntity.func_92059_d();
        int stackSize = stack.func_190916_E();
        int collected = stackSize - (remainder = PneumaticCraftUtils.exportStackToInventory(drone, stack, EnumFacing.UP)).func_190916_E();
        if (collected > 0) {
            drone.onItemPickupEvent(itemEntity, collected);
        }
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        } else if (collected > 0) {
            itemEntity.func_92058_a(remainder);
        }
    }
}

