/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import me.desht.pneumaticcraft.client.sound.MovingSoundElevator;
import me.desht.pneumaticcraft.client.sound.MovingSoundJetBoots;
import me.desht.pneumaticcraft.client.sound.MovingSoundMinigun;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MovingSounds {
    private static MovingSound createMovingSound(Sound s, Object o) {
        switch (s) {
            case JET_BOOTS: {
                if (!(o instanceof EntityPlayer)) break;
                return new MovingSoundJetBoots((EntityPlayer)o);
            }
            case MINIGUN: {
                if (o instanceof EntityPlayer || o instanceof EntityDrone) {
                    return new MovingSoundMinigun((Entity)o);
                }
                if (!(o instanceof BlockPos)) break;
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s((BlockPos)o);
                return te == null ? null : new MovingSoundMinigun(te);
            }
            case ELEVATOR: {
                TileEntity te;
                if (!(o instanceof BlockPos) || !((te = Minecraft.func_71410_x().field_71441_e.func_175625_s((BlockPos)o)) instanceof TileEntityElevatorBase)) break;
                return new MovingSoundElevator((TileEntityElevatorBase)te);
            }
        }
        throw new IllegalArgumentException("Invalid moving sound " + (Object)((Object)s) + " for entity " + o);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playMovingSound(Sound s, Object o) {
        MovingSound movingSound = MovingSounds.createMovingSound(s, o);
        if (movingSound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)movingSound);
        }
    }

    public static enum Sound {
        JET_BOOTS,
        MINIGUN,
        ELEVATOR;

    }
}

