/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.semiblock;

import me.desht.pneumaticcraft.client.semiblock.ISemiBlockRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class SemiBlockRendererLogistics
implements ISemiBlockRenderer<SemiBlockLogistics> {
    private static final double FRAME_WIDTH = 0.03125;
    private static final AxisAlignedBB DEFAULT_BOX = new AxisAlignedBB(0.03125, 0.03125, 0.03125, 0.96875, 0.96875, 0.96875);

    @Override
    public void render(SemiBlockLogistics semiBlock, float partialTick) {
        int alpha = semiBlock.getAlpha();
        if (alpha == 0) {
            return;
        }
        if (alpha < 255) {
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179090_x();
        RenderUtils.glColorHex((alpha << 24 | 0xFFFFFF) & semiBlock.getColor(), this.getLightMultiplier(semiBlock));
        AxisAlignedBB aabb = semiBlock.getWorld() != null ? semiBlock.getBlockState().func_185900_c((IBlockAccess)semiBlock.getWorld(), semiBlock.getPos()) : DEFAULT_BOX;
        RenderUtils.renderFrame(aabb, 0.03125);
        this.drawSideHighlight(semiBlock, alpha, aabb);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawSideHighlight(SemiBlockLogistics semiBlock, int alpha, AxisAlignedBB aabb) {
        GlStateManager.func_179147_l();
        RenderUtils.glColorHex((alpha * 2 / 3 << 24 | 0xFFFFFF) & semiBlock.getColor(), this.getLightMultiplier(semiBlock));
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        switch (semiBlock.getSide()) {
            case DOWN: {
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b - 0.02, aabb.field_72339_c).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b - 0.02, aabb.field_72339_c).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b - 0.02, aabb.field_72334_f).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b - 0.02, aabb.field_72334_f).func_181675_d();
                break;
            }
            case UP: {
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e + 0.02, aabb.field_72334_f).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e + 0.02, aabb.field_72334_f).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e + 0.02, aabb.field_72339_c).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e + 0.02, aabb.field_72339_c).func_181675_d();
                break;
            }
            case NORTH: {
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c - 0.02).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c - 0.02).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c - 0.02).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c - 0.02).func_181675_d();
                break;
            }
            case SOUTH: {
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f + 0.02).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f + 0.02).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f + 0.02).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f + 0.02).func_181675_d();
                break;
            }
            case WEST: {
                wr.func_181662_b(aabb.field_72340_a - 0.02, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a - 0.02, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a - 0.02, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a - 0.02, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
                break;
            }
            case EAST: {
                wr.func_181662_b(aabb.field_72336_d + 0.02, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d + 0.02, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d + 0.02, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d + 0.02, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private float getLightMultiplier(ISemiBlock semiBlock) {
        return ConfigHandler.client.semiBlockLighting ? (float)Math.max(1, Minecraft.func_71410_x().field_71441_e.func_175721_c(semiBlock.getPos(), true)) / 15.0f : 1.0f;
    }
}

