/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.EntityTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiEntityTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderTarget;
import me.desht.pneumaticcraft.common.ai.StringFilterEntitySelector;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private static final int ENTITY_TRACK_THRESHOLD = 7;
    private static final float ENTITY_TRACKING_RANGE = 16.0f;
    private static final String UPGRADE_NAME = "entityTracker";
    private final Map<Integer, RenderTarget> targets = new HashMap<Integer, RenderTarget>();
    private boolean shouldStopSpamOnEntityTracking = false;
    public boolean gaveNotAbleToTrackEntityWarning;
    @SideOnly(value=Side.CLIENT)
    private GuiAnimatedStat entityTrackInfo;
    @Nonnull
    private EntityFilter entityFilter = new EntityFilter("");

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return UPGRADE_NAME;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        EntityFilter newFilter;
        String filterStr;
        ItemStack helmetStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        String string = filterStr = helmetStack.func_190926_b() ? "" : NBTUtil.getString(helmetStack, "entityFilter");
        if (!this.entityFilter.toString().equals(filterStr) && (newFilter = EntityFilter.fromString(filterStr)) != null) {
            this.entityFilter = newFilter;
        }
        double entityTrackRange = 16.0f + (float)(rangeUpgrades * 5);
        AxisAlignedBB bbBox = EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades);
        List mobs = player.field_70170_p.func_175647_a(EntityLivingBase.class, bbBox, (Predicate)new EntityTrackerSelector(player, this.entityFilter, entityTrackRange));
        for (Object mob : mobs) {
            RenderTarget renderTarget = this.targets.get(mob.func_145782_y());
            if (renderTarget != null) {
                renderTarget.ticksExisted = Math.abs(renderTarget.ticksExisted);
                continue;
            }
            this.targets.put(mob.func_145782_y(), new RenderTarget((Entity)mob));
        }
        ArrayList toRemove = new ArrayList();
        for (Map.Entry entry : this.targets.entrySet()) {
            RenderTarget target = (RenderTarget)entry.getValue();
            if (!target.entity.field_70128_L && !((double)player.func_70032_d(target.entity) > entityTrackRange + 5.0) && this.entityFilter.test(target.entity)) continue;
            if (target.ticksExisted > 0) {
                target.ticksExisted = -60;
                continue;
            }
            if (target.ticksExisted != -1) continue;
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(this.targets::remove);
        if (this.targets.size() > 7) {
            if (!this.shouldStopSpamOnEntityTracking) {
                this.shouldStopSpamOnEntityTracking = true;
                HUDHandler.instance().addMessage(new ArmorMessage("Stopped spam on Entity Tracker", new ArrayList<String>(), 60, 0x7700AA00));
            }
        } else {
            this.shouldStopSpamOnEntityTracking = false;
        }
        ArrayList<String> text = new ArrayList<String>();
        for (RenderTarget target : this.targets.values()) {
            boolean wasNegative = target.ticksExisted < 0;
            target.ticksExisted += CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EntityEquipmentSlot.HEAD);
            if (target.ticksExisted >= 0 && wasNegative) {
                target.ticksExisted = -1;
            }
            target.update();
            if (!target.isLookingAtTarget) continue;
            if (target.isInitialized()) {
                text.add(TextFormatting.GRAY + target.entity.func_70005_c_());
                text.addAll(target.getEntityText());
                continue;
            }
            text.add(TextFormatting.GRAY + "Acquiring target...");
        }
        if (text.size() == 0) {
            text.add("Filter mode: " + (this.entityFilter.toString().isEmpty() ? "None" : this.entityFilter.toString()));
        }
        this.entityTrackInfo.setText(text);
    }

    static AxisAlignedBB getAABBFromRange(EntityPlayer player, int rangeUpgrades) {
        double entityTrackRange = 16.0f + (float)(Math.min(10, rangeUpgrades) * 5);
        return new AxisAlignedBB(player.field_70165_t - entityTrackRange, player.field_70163_u - entityTrackRange, player.field_70161_v - entityTrackRange, player.field_70165_t + entityTrackRange, player.field_70163_u + entityTrackRange, player.field_70161_v + entityTrackRange);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        this.targets.values().forEach(target -> target.render(partialTicks, this.shouldStopSpamOnEntityTracking));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.ENTITY_TRACKER)};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.targets.clear();
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f * (1.0f + (float)Math.min(10, rangeUpgrades) * 5.0f / 16.0f) * (float)CommonArmorHandler.getHandlerForPlayer(player).getSpeedFromUpgrades(EntityEquipmentSlot.HEAD);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiEntityTrackOptions(this);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        if (this.entityTrackInfo == null) {
            GuiAnimatedStat.StatIcon icon = GuiAnimatedStat.StatIcon.of(CraftingRegistrator.getUpgrade(IItemRegistry.EnumUpgrade.ENTITY_TRACKER));
            this.entityTrackInfo = new GuiAnimatedStat(null, "Current tracked entities:", icon, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.entityTrackerStat);
            this.entityTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.entityTrackInfo;
    }

    public Stream<RenderTarget> getTargetsStream() {
        return this.targets.values().stream();
    }

    public RenderTarget getTargetForEntity(Entity entity) {
        return this.getTargetsStream().filter(target -> target.entity == entity).findFirst().orElse(null);
    }

    public void hack() {
        this.getTargetsStream().forEach(RenderTarget::hack);
    }

    public void selectAsDebuggingTarget() {
        this.getTargetsStream().forEach(RenderTarget::selectAsDebuggingTarget);
    }

    public boolean scroll(MouseEvent event) {
        return this.getTargetsStream().anyMatch(target -> target.scroll(event));
    }

    @Override
    public void onResolutionChanged() {
        this.entityTrackInfo = null;
    }

    private class EntityTrackerSelector
    extends StringFilterEntitySelector {
        private final EntityPlayer player;
        private final double threshold;

        private EntityTrackerSelector(EntityPlayer player, EntityFilter filter, double threshold) {
            this.player = player;
            this.threshold = threshold;
            this.setFilter(Collections.singletonList(filter));
        }

        @Override
        public boolean apply(Entity entity) {
            return entity != this.player && !entity.field_70128_L && (double)this.player.func_70032_d(entity) < this.threshold && !MinecraftForge.EVENT_BUS.post((Event)new EntityTrackEvent(entity)) && super.apply(entity);
        }
    }
}

