/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderCoordWireframe;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemPlastic;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RenderDroneAI {
    private final EntityDrone drone;
    private final EntityItem entityItem;
    private final List<Pair<RenderCoordWireframe, Integer>> blackListWireframes = new ArrayList<Pair<RenderCoordWireframe, Integer>>();
    private float progress = 0.0f;
    private BlockPos oldPos;
    private BlockPos pos;

    public RenderDroneAI(EntityDrone drone) {
        this.drone = drone;
        this.entityItem = new EntityItem(drone.field_70170_p);
        this.update();
    }

    public void update() {
        this.entityItem.field_70292_b += 4;
        BlockPos lastPos = this.pos;
        this.pos = this.drone.getTargetedBlock();
        if (this.pos != null) {
            if (lastPos == null) {
                this.oldPos = this.pos;
            } else if (!this.pos.equals((Object)lastPos)) {
                this.progress = 0.0f;
                this.oldPos = lastPos;
            }
        } else {
            this.oldPos = null;
        }
        this.progress = Math.min((float)Math.PI, this.progress + 0.1f);
        Iterator<Pair<RenderCoordWireframe, Integer>> iterator = this.blackListWireframes.iterator();
        while (iterator.hasNext()) {
            Pair<RenderCoordWireframe, Integer> wireframe = iterator.next();
            ++((RenderCoordWireframe)wireframe.getKey()).ticksExisted;
            wireframe.setValue((Object)((Integer)wireframe.getValue() - 1));
            if ((Integer)wireframe.getValue() > 0) continue;
            iterator.remove();
        }
    }

    public void render(float partialTicks) {
        for (Pair<RenderCoordWireframe, Integer> wireframe : this.blackListWireframes) {
            ((RenderCoordWireframe)wireframe.getKey()).render(partialTicks);
        }
        if (this.pos != null) {
            int color = ItemPlastic.getColour(this.drone.getActiveProgram());
            double x = this.getInterpolated(this.pos.func_177958_n(), this.oldPos.func_177958_n(), partialTicks);
            double y = this.getInterpolated(this.pos.func_177956_o(), this.oldPos.func_177956_o(), partialTicks);
            double z = this.getInterpolated(this.pos.func_177952_p(), this.oldPos.func_177952_p(), partialTicks);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179094_E();
            float[] c = RenderDroneAI.colorToRGBA(color);
            GlStateManager.func_179131_c((float)c[1], (float)c[2], (float)c[3], (float)0.5f);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderUtils.render3DArrow();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    private double getInterpolated(double newPos, double oldPos, float partialTicks) {
        double cosProgress = 0.5 - 0.5 * (double)MathHelper.func_76134_b((float)((float)Math.min(Math.PI, (double)(this.progress + partialTicks * 0.1f))));
        return oldPos + (newPos - oldPos) * cosProgress;
    }

    public void addBlackListEntry(World world, BlockPos pos) {
        this.blackListWireframes.add((Pair<RenderCoordWireframe, Integer>)new MutablePair((Object)new RenderCoordWireframe(world, pos), (Object)60));
    }

    private static float[] colorToRGBA(int color) {
        float[] c = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return c;
    }
}

