/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderLaser {
    private int ticksExisted;
    private final int coreColor;
    private final int glowColor;

    public RenderLaser(int color) {
        this(color, color);
    }

    public RenderLaser(int coreColor, int glowColor) {
        this.coreColor = coreColor;
        this.glowColor = glowColor;
    }

    public void update() {
        ++this.ticksExisted;
    }

    public void render(float partialTicks, double x1, double y1, double z1, double x2, double y2, double z2) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        TextureManager textureManager = mc.field_71446_o;
        double laserLength = PneumaticCraftUtils.distBetween(x1, y1, z1, x2, y2, z2);
        double laserSize = 0.4;
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179137_b((double)x1, (double)y1, (double)z1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double rotYaw = Math.atan2(dx, dz) * 180.0 / Math.PI;
        double rotPitch = 90.0f - (float)(Math.atan2(dy, f3) * 180.0 / Math.PI);
        GlStateManager.func_179114_b((float)((float)rotYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rotPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)laserSize, (double)laserSize, (double)laserSize);
        GlStateManager.func_179137_b((double)0.0, (double)0.6, (double)0.0);
        GlStateManager.func_179114_b((float)(((float)this.ticksExisted + partialTicks) * 200.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)1.0, (double)(laserLength / laserSize), (double)1.0);
        textureManager.func_110577_a(Textures.RENDER_LASER);
        this.renderQuad(this.glowColor);
        textureManager.func_110577_a(Textures.RENDER_LASER_OVERLAY);
        this.renderQuad(this.coreColor);
        GlStateManager.func_179121_F();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        textureManager.func_110577_a(Textures.RENDER_LASER_START);
        this.renderQuad(this.glowColor);
        textureManager.func_110577_a(Textures.RENDER_LASER_START_OVERLAY);
        this.renderQuad(this.coreColor);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderQuad(int color) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.glColorHex(color);
        wr.func_181662_b(-0.5, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(-0.5, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(0.5, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(0.5, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

