/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.config.HelmetWidgetDefaults;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class GuiKeybindCheckBox
extends GuiCheckBox {
    public static final String UPGRADE_PREFIX = "pneumaticHelmet.upgrade.";
    private boolean isAwaitingKey;
    private String oldCheckboxText;
    private KeyBinding keyBinding;
    private final String keyBindingName;
    private static final Map<String, GuiKeybindCheckBox> trackedCheckboxes = new HashMap<String, GuiKeybindCheckBox>();
    private static GuiKeybindCheckBox coreComponents;

    public GuiKeybindCheckBox(int id, int x, int y, int color, String text) {
        this(id, x, y, color, text, text);
    }

    public GuiKeybindCheckBox(int id, int x, int y, int color, String text, String keyBindingName) {
        super(id, x, y, color, text);
        this.keyBindingName = keyBindingName;
        this.keyBinding = GuiKeybindCheckBox.setOrAddKeybind(keyBindingName, -1, KeyModifier.NONE);
        if (!trackedCheckboxes.containsKey(keyBindingName)) {
            this.checked = HelmetWidgetDefaults.INSTANCE.getKey(keyBindingName);
            trackedCheckboxes.put(keyBindingName, this);
            MinecraftForge.EVENT_BUS.register((Object)this);
            if (keyBindingName.equals("pneumaticHelmet.upgrade.coreComponents")) {
                coreComponents = this;
            }
        } else {
            this.checked = GuiKeybindCheckBox.trackedCheckboxes.get((Object)keyBindingName).checked;
        }
    }

    public static GuiKeybindCheckBox getCoreComponents() {
        return coreComponents;
    }

    public static GuiKeybindCheckBox fromKeyBindingName(String name) {
        return trackedCheckboxes.get(name);
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            super.onMouseClicked(mouseX, mouseY, button);
            GuiKeybindCheckBox trackedBox = trackedCheckboxes.get(this.keyBindingName);
            if (trackedBox != this) {
                trackedBox.onMouseClicked(mouseX, mouseY, button);
            } else {
                HelmetWidgetDefaults.INSTANCE.setKey(this.keyBindingName, this.checked);
                try {
                    HelmetWidgetDefaults.INSTANCE.writeToFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                CommonArmorHandler hudHandler = CommonArmorHandler.getHandlerForPlayer();
                for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                    int i;
                    List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
                    for (i = 0; i < renderHandlers.size(); ++i) {
                        IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                        if (!(UPGRADE_PREFIX + upgradeRenderHandler.getUpgradeName()).equals(this.keyBindingName) || !hudHandler.isUpgradeRendererInserted(slot, i)) continue;
                        NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, GuiKeybindCheckBox.coreComponents.checked && this.checked, slot));
                        hudHandler.setUpgradeRenderEnabled(slot, (byte)i, GuiKeybindCheckBox.coreComponents.checked && this.checked);
                        HUDHandler.instance().addFeatureToggleMessage(this.keyBindingName, this.checked);
                        break;
                    }
                    if (!this.keyBindingName.equals("pneumaticHelmet.upgrade.coreComponents")) continue;
                    for (i = 0; i < renderHandlers.size(); ++i) {
                        boolean state = GuiKeybindCheckBox.fromKeyBindingName((String)new StringBuilder().append((String)UPGRADE_PREFIX).append((String)renderHandlers.get((int)i).getUpgradeName()).toString()).checked;
                        NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, GuiKeybindCheckBox.coreComponents.checked && state, slot));
                        hudHandler.setUpgradeRenderEnabled(slot, (byte)i, GuiKeybindCheckBox.coreComponents.checked && state);
                    }
                }
            }
        } else if (PneumaticCraftRepressurized.proxy.isSneakingInGui()) {
            this.clearKeybinding();
        } else {
            boolean bl = this.isAwaitingKey = !this.isAwaitingKey;
            if (this.isAwaitingKey) {
                this.oldCheckboxText = this.text;
                this.text = "gui.setKeybind";
            } else {
                this.text = this.oldCheckboxText;
            }
        }
    }

    private void clearKeybinding() {
        KeyBinding[] keyBindings = Minecraft.func_71410_x().field_71474_y.field_74324_K;
        HashSet<Integer> idx = new HashSet<Integer>();
        for (int i = 0; i < keyBindings.length; ++i) {
            if (!keyBindings[i].func_151464_g().equals(this.keyBinding.func_151464_g())) continue;
            idx.add(i);
            break;
        }
        if (!idx.isEmpty()) {
            ArrayList<KeyBinding> l = new ArrayList<KeyBinding>(keyBindings.length);
            for (int i = 0; i < keyBindings.length; ++i) {
                if (idx.contains(i)) continue;
                l.add(keyBindings[i]);
            }
            Minecraft.func_71410_x().field_71474_y.field_74324_K = l.toArray(new KeyBinding[0]);
            this.keyBinding = new KeyBinding(this.keyBindingName, (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, "key.pneumaticcraft.category");
            ClientRegistry.registerKeyBinding((KeyBinding)this.keyBinding);
            KeyBinding.func_74508_b();
            ((ClientProxy)PneumaticCraftRepressurized.proxy).keybindToKeyCodes.put(this.keyBindingName, (Pair<Integer, KeyModifier>)Pair.of((Object)0, (Object)KeyModifier.NONE));
            Minecraft.func_71410_x().field_71474_y.func_74303_b();
        }
    }

    @Override
    public boolean onKey(char key, int keyCode) {
        if (this.isAwaitingKey) {
            if (KeyModifier.isKeyCodeModifier((int)keyCode)) {
                return true;
            }
            this.isAwaitingKey = false;
            this.keyBinding = GuiKeybindCheckBox.setOrAddKeybind(this.keyBindingName, keyCode, KeyModifier.getActiveModifier());
            this.text = this.oldCheckboxText;
            if (trackedCheckboxes.containsKey(this.keyBindingName)) {
                MinecraftForge.EVENT_BUS.unregister((Object)trackedCheckboxes.get(this.keyBindingName));
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71415_G && this.keyBinding != null && this.keyBinding.func_151468_f()) {
            this.onMouseClicked(0, 0, 0);
        }
    }

    private static KeyBinding setOrAddKeybind(String keybindName, int keyCode, KeyModifier modifier) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
        for (KeyBinding keyBinding : gameSettings.field_74324_K) {
            if (keyBinding == null || !keyBinding.func_151464_g().equals(keybindName)) continue;
            if (keyCode >= 0) {
                keyBinding.setKeyModifierAndCode(modifier, keyCode);
                KeyBinding.func_74508_b();
                gameSettings.func_74303_b();
            }
            return keyBinding;
        }
        if (keyCode < 0) {
            if (((ClientProxy)PneumaticCraftRepressurized.proxy).keybindToKeyCodes.containsKey(keybindName)) {
                Pair<Integer, KeyModifier> binding = ((ClientProxy)PneumaticCraftRepressurized.proxy).keybindToKeyCodes.get(keybindName);
                keyCode = (Integer)binding.getLeft();
                modifier = (KeyModifier)binding.getRight();
            } else {
                return null;
            }
        }
        KeyBinding keyBinding = new KeyBinding(keybindName, (IKeyConflictContext)KeyConflictContext.IN_GAME, modifier, keyCode, "key.pneumaticcraft.category");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        KeyBinding.func_74508_b();
        gameSettings.func_74303_b();
        return keyBinding;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTooltip, boolean shiftPressed) {
        if (this.keyBinding != null) {
            String s = this.keyBinding.getKeyModifier() != KeyModifier.NONE ? this.keyBinding.getKeyModifier() + " + " : "";
            curTooltip.add(I18n.func_135052_a((String)"gui.keybindBoundKey", (Object[])new Object[]{s + Keyboard.getKeyName((int)this.keyBinding.func_151463_i())}));
        }
        if (!this.isAwaitingKey) {
            curTooltip.add("gui.keybindRightClickToSet");
            if (this.keyBinding != null && this.keyBinding.func_151463_i() != 0) {
                curTooltip.add("gui.keybindShiftRightClickToClear");
            }
        }
    }
}

