/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.progwidgets.IJump;
import me.desht.pneumaticcraft.common.progwidgets.ILabel;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiUnitProgrammer
extends GuiScreen {
    private final FontRenderer fontRenderer;
    private final List<IProgWidget> progWidgets;
    private final int guiLeft;
    private final int guiTop;
    private final int startX;
    private final int startY;
    private final int areaWidth;
    private final int areaHeight;
    private int translatedX;
    private int translatedY;
    private int lastMouseX;
    private int lastMouseY;
    private int lastZoom;
    private boolean wasClicking;
    private final WidgetVerticalScrollbar scaleScroll;
    private static final float SCALE_PER_STEP = 0.2f;

    public GuiUnitProgrammer(List<IProgWidget> progWidgets, FontRenderer fontRenderer, int guiLeft, int guiTop, int width, int height, int xSize, int startX, int startY, int areaWidth, int areaHeight, int translatedX, int translatedY, int lastZoom) {
        this.fontRenderer = fontRenderer;
        this.progWidgets = progWidgets;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.func_146280_a(Minecraft.func_71410_x(), width, height);
        this.startX = startX;
        this.startY = startY;
        this.areaWidth = areaWidth;
        this.areaHeight = areaHeight;
        this.translatedX = translatedX;
        this.translatedY = translatedY;
        this.lastZoom = lastZoom;
        this.scaleScroll = new WidgetVerticalScrollbar(guiLeft + areaWidth + 8, guiTop + 40, areaHeight - 25).setStates(9).setCurrentState(lastZoom).setListening(true);
    }

    public WidgetVerticalScrollbar getScrollBar() {
        return this.scaleScroll;
    }

    public int getLastZoom() {
        return this.lastZoom;
    }

    public int getTranslatedX() {
        return this.translatedX;
    }

    public int getTranslatedY() {
        return this.translatedY;
    }

    public void renderForeground(int x, int y, IProgWidget tooltipExcludingWidget) {
        IProgWidget widget = this.getHoveredWidget(x, y);
        if (widget != null && widget != tooltipExcludingWidget) {
            ArrayList<String> tooltip = new ArrayList<String>();
            widget.getTooltip(tooltip);
            ArrayList<String> errors = new ArrayList<String>();
            widget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.programmer.errors", (Object[])new Object[0]));
                for (String s : errors) {
                    String[] lines;
                    String msg = I18n.func_188566_a((String)s) ? I18n.func_135052_a((String)s, (Object[])new Object[0]) : s;
                    for (String line : lines = WordUtils.wrap((String)("- " + msg), (int)35).split(System.getProperty("line.separator"))) {
                        tooltip.add(TextFormatting.RED + line);
                    }
                }
            }
            ArrayList<String> warnings = new ArrayList<String>();
            widget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() > 0) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.programmer.warnings", (Object[])new Object[0]));
                for (String s : warnings) {
                    String[] lines;
                    String msg = I18n.func_188566_a((String)s) ? I18n.func_135052_a((String)s, (Object[])new Object[0]) : s;
                    for (String line : lines = WordUtils.wrap((String)("- " + msg), (int)35).split(System.getProperty("line.separator"))) {
                        tooltip.add(TextFormatting.YELLOW + "   " + line);
                    }
                }
            }
            this.addAdditionalInfoToTooltip(widget, tooltip);
            if (tooltip.size() > 0) {
                this.drawHoveringText(tooltip, x - this.guiLeft, y - this.guiTop, this.fontRenderer);
            }
        }
    }

    public IProgWidget getHoveredWidget(int x, int y) {
        float scale = this.getScale();
        for (IProgWidget widget : this.progWidgets) {
            if (this.isOutsideProgrammingArea(widget) || !((float)(x - this.translatedX) / scale - (float)this.guiLeft >= (float)widget.getX()) || !((float)(y - this.translatedY) / scale - (float)this.guiTop >= (float)widget.getY()) || !((float)(x - this.translatedX) / scale - (float)this.guiLeft <= (float)(widget.getX() + widget.getWidth() / 2)) || !((float)(y - this.translatedY) / scale - (float)this.guiTop <= (float)(widget.getY() + widget.getHeight() / 2))) continue;
            return widget;
        }
        return null;
    }

    protected void addAdditionalInfoToTooltip(IProgWidget widget, List<String> tooltip) {
        if (widget.getOptionWindow(null) != null) {
            tooltip.add(TextFormatting.GOLD + "Right click for options");
        }
        ThirdPartyManager.instance().docsProvider.addTooltip(tooltip, false);
    }

    public void render(int x, int y, boolean showFlow, boolean showInfo, boolean translate) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int origX = x;
        int origY = y;
        x -= this.translatedX;
        y -= this.translatedY;
        float scale = this.getScale();
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        if (this.scaleScroll.getState() != this.lastZoom) {
            float shift = 0.2f * (float)(this.scaleScroll.getState() - this.lastZoom);
            if (new Rectangle(this.guiLeft + this.startX, this.guiTop + this.startY, this.areaWidth, this.areaHeight).contains(origX, origY) && !this.scaleScroll.isDragging()) {
                this.translatedX = (int)((float)this.translatedX + shift * (float)x);
                this.translatedY = (int)((float)this.translatedY + shift * (float)y);
            } else {
                this.translatedX = (int)((float)this.translatedX + (float)(this.areaWidth / 2) * shift);
                this.translatedY = (int)((float)this.translatedY + (float)(this.areaHeight / 2) * shift);
            }
        }
        this.lastZoom = this.scaleScroll.getState();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glScissor((int)((this.guiLeft + this.startX) * sr.func_78325_e()), (int)((sr.func_78328_b() - this.areaHeight - (this.guiTop + this.startY)) * sr.func_78325_e()), (int)(this.areaWidth * sr.func_78325_e()), (int)(this.areaHeight * sr.func_78325_e()));
        GL11.glEnable((int)3089);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.translatedX, (float)this.translatedY, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        if (showFlow) {
            this.showFlow();
        }
        GlStateManager.func_179098_w();
        for (IProgWidget widget : this.progWidgets) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(widget.getX() + this.guiLeft), (float)(widget.getY() + this.guiTop), (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            widget.render();
            GlStateManager.func_179121_F();
        }
        for (IProgWidget widget : this.progWidgets) {
            ArrayList<String> errors = new ArrayList<String>();
            widget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                this.drawBorder(widget, -65536);
                continue;
            }
            ArrayList<String> warnings = new ArrayList<String>();
            widget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() <= 0) continue;
            this.drawBorder(widget, -256);
        }
        this.renderAdditionally();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (showInfo) {
            for (IProgWidget widget : this.progWidgets) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(widget.getX() + this.guiLeft), (float)(widget.getY() + this.guiTop), (float)0.0f);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
                widget.renderExtraInfo();
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179121_F();
        GL11.glDisable((int)3089);
        boolean isLeftClicking = Mouse.isButtonDown((int)0);
        if (translate && isLeftClicking && this.wasClicking && !this.scaleScroll.isDragging() && new Rectangle(this.guiLeft + this.startX, this.guiTop + this.startY, this.areaWidth, this.areaHeight).contains(origX, origY)) {
            this.translatedX += origX - this.lastMouseX;
            this.translatedY += origY - this.lastMouseY;
        }
        this.wasClicking = isLeftClicking;
        this.lastMouseX = origX;
        this.lastMouseY = origY;
    }

    protected void renderAdditionally() {
    }

    protected void drawBorder(IProgWidget widget, int color) {
        this.drawBorder(widget, color, 0);
    }

    protected void drawBorder(IProgWidget widget, int color, int inset) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(widget.getX() + this.guiLeft), (float)(widget.getY() + this.guiTop), (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        this.func_73728_b(inset, inset, widget.getHeight() - inset, color);
        this.func_73728_b(widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        this.func_73730_a(widget.getWidth() - inset, inset, inset, color);
        this.func_73730_a(widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        GlStateManager.func_179121_F();
    }

    private void showFlow() {
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_187447_r((int)1);
        for (IProgWidget widget : this.progWidgets) {
            List<String> jumpLocations;
            if (!(widget instanceof IJump) || (jumpLocations = ((IJump)((Object)widget)).getPossibleJumpLocations()) == null) continue;
            for (String jumpLocation : jumpLocations) {
                if (jumpLocation == null) continue;
                for (IProgWidget w : this.progWidgets) {
                    String label;
                    if (!(w instanceof ILabel) || !jumpLocation.equals(label = ((ILabel)((Object)w)).getLabel())) continue;
                    int x1 = widget.getX() + widget.getWidth() / 4;
                    int y1 = widget.getY() + widget.getHeight() / 4;
                    int x2 = w.getX() + w.getWidth() / 4;
                    int y2 = w.getY() + w.getHeight() / 4;
                    float midX = (float)(x2 + x1) / 2.0f;
                    float midY = (float)(y2 + y1) / 2.0f;
                    GlStateManager.func_187435_e((float)(this.guiLeft + x1), (float)(this.guiTop + y1), (float)this.field_73735_i);
                    GlStateManager.func_187435_e((float)(this.guiLeft + x2), (float)(this.guiTop + y2), (float)this.field_73735_i);
                    Vec3d arrowVec = new Vec3d((double)(x1 - x2), (double)(y1 - y2), 0.0).func_72432_b();
                    float arrowAngle = (float)Math.toRadians(30.0);
                    float arrowSize = 5.0f;
                    arrowVec = new Vec3d(arrowVec.field_72450_a * (double)arrowSize, 0.0, arrowVec.field_72448_b * (double)arrowSize);
                    arrowVec = arrowVec.func_178785_b(arrowAngle);
                    GlStateManager.func_187435_e((float)((float)this.guiLeft + midX), (float)((float)this.guiTop + midY), (float)this.field_73735_i);
                    GlStateManager.func_187435_e((float)((float)this.guiLeft + midX + (float)arrowVec.field_72450_a), (float)((float)this.guiTop + midY + (float)arrowVec.field_72449_c), (float)this.field_73735_i);
                    arrowVec = arrowVec.func_178785_b(-2.0f * arrowAngle);
                    GlStateManager.func_187435_e((float)((float)this.guiLeft + midX), (float)((float)this.guiTop + midY), (float)this.field_73735_i);
                    GlStateManager.func_187435_e((float)((float)this.guiLeft + midX + (float)arrowVec.field_72450_a), (float)((float)this.guiTop + midY + (float)arrowVec.field_72449_c), (float)this.field_73735_i);
                }
            }
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_179098_w();
    }

    public float getScale() {
        return 2.0f - (float)this.scaleScroll.getState() * 0.2f;
    }

    public boolean isOutsideProgrammingArea(IProgWidget widget) {
        float scale = this.getScale();
        int x = (int)((float)(widget.getX() + this.guiLeft) * scale);
        int y = (int)((float)(widget.getY() + this.guiTop) * scale);
        return (x += this.translatedX - this.guiLeft) < this.startX || (float)x + (float)widget.getWidth() * scale / 2.0f > (float)(this.startX + this.areaWidth) || (y += this.translatedY - this.guiTop) < this.startY || (float)y + (float)widget.getHeight() * scale / 2.0f > (float)(this.startY + this.areaHeight);
    }

    public void gotoPiece(IProgWidget widget) {
        if (widget != null) {
            this.scaleScroll.currentScroll = 0.0f;
            this.lastZoom = 0;
            this.translatedX = -widget.getX() * 2 + this.areaWidth / 2 - this.guiLeft;
            this.translatedY = -widget.getY() * 2 + this.areaHeight / 2 - this.guiTop;
        }
    }
}

