/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.GuiUtils;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiMicromissile
extends GuiPneumaticScreenBase {
    private static final Rectangle SELECTOR_BOUNDS = new Rectangle(12, 21, 92, 81);
    private static final int MAX_DIST = GuiMicromissile.SELECTOR_BOUNDS.width;
    private static final Point TOP_SPEED_PT = new Point(46, 1);
    private static final Point TURN_SPEED_PT = new Point(1, 80);
    private static final Point DMG_PT = new Point(92, 80);
    private float turnSpeed;
    private float topSpeed;
    private float damage;
    private Point point;
    private ItemMicromissiles.FireMode fireMode;
    private boolean dragging = false;
    private String entityFilter;
    private int sendTimer = 0;
    private WidgetTextField textField;
    private WidgetLabel filterLabel;
    private GuiButtonSpecial modeButton;
    private GuiButtonSpecial warningButton;

    public GuiMicromissile() {
        this.xSize = 183;
        this.ySize = 191;
        ItemStack stack = ItemMicromissiles.getHeldMicroMissile((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (stack.func_77973_b() == Itemss.MICROMISSILES) {
            if (stack.func_77942_o()) {
                this.topSpeed = NBTUtil.getFloat(stack, "topSpeed");
                this.turnSpeed = NBTUtil.getFloat(stack, "turnSpeed");
                this.damage = NBTUtil.getFloat(stack, "damage");
                this.entityFilter = NBTUtil.getString(stack, "filter");
                this.point = new Point(NBTUtil.getInteger(stack, "px"), NBTUtil.getInteger(stack, "py"));
                this.fireMode = ItemMicromissiles.FireMode.fromString(NBTUtil.getString(stack, "fireMode"));
            } else {
                this.damage = 0.33333334f;
                this.turnSpeed = 0.33333334f;
                this.topSpeed = 0.33333334f;
                this.point = new Point(MAX_DIST / 2, MAX_DIST / 4);
                this.entityFilter = "";
                this.fireMode = ItemMicromissiles.FireMode.SMART;
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String labelStr = I18n.func_135052_a((String)"gui.sentryTurret.targetFilter", (Object[])new Object[0]);
        this.filterLabel = new WidgetLabel(this.guiLeft + 12, this.guiTop + 130, labelStr);
        this.addWidget(this.filterLabel);
        int textBoxX = this.guiLeft + 12 + fr.func_78256_a(labelStr) + 5;
        int textBoxWidth = this.xSize - (textBoxX - this.guiLeft) - 20;
        this.textField = new WidgetTextField(Minecraft.func_71410_x().field_71466_p, textBoxX, this.guiTop + 128, textBoxWidth, 10);
        this.textField.func_146180_a(this.entityFilter);
        this.addWidget(this.textField);
        this.textField.func_146195_b(true);
        this.addWidget(new WidgetTooltipArea(this.guiLeft + 42, this.guiTop + 9, 35, 9, "gui.micromissile.topSpeed"));
        this.addWidget(new WidgetTooltipArea(this.guiLeft + 6, this.guiTop + 103, 25, 12, "gui.micromissile.turnSpeed"));
        this.addWidget(new WidgetTooltipArea(this.guiLeft + 96, this.guiTop + 103, 15, 15, "gui.micromissile.damage"));
        String saveLabel = I18n.func_135052_a((String)"gui.micromissile.saveDefault", (Object[])new Object[0]);
        int buttonWidth = fr.func_78256_a(saveLabel) + 10;
        int buttonX = this.guiLeft + (this.xSize - buttonWidth) / 2;
        this.field_146292_n.add(new GuiButtonSpecial(1, buttonX, this.guiTop + 160, buttonWidth, 20, saveLabel));
        this.modeButton = new GuiButtonSpecial(2, this.guiLeft + 123, this.guiTop + 20, 52, 20, "");
        this.modeButton.setTooltipText("gui.micromissile.modeTooltip");
        this.field_146292_n.add(this.modeButton);
        this.warningButton = new GuiButtonSpecial(3, this.guiLeft + 162, this.guiTop + 123, 20, 20, "");
        this.warningButton.setVisible(false);
        this.warningButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        this.field_146292_n.add(this.warningButton);
        this.validateEntityFilter(this.entityFilter);
        this.setupWidgets();
    }

    private void setupWidgets() {
        this.textField.func_146184_c(this.fireMode == ItemMicromissiles.FireMode.SMART);
        this.filterLabel.setColor(this.fireMode == ItemMicromissiles.FireMode.SMART ? -12566464 : -5592406);
        this.modeButton.field_146126_j = I18n.func_135052_a((String)("gui.micromissile.mode." + this.fireMode.toString()), (Object[])new Object[0]);
    }

    @Override
    public void func_73863_a(int x, int y, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(x, y, partialTicks);
        if (Keyboard.isKeyDown((int)59)) {
            GuiUtils.showPopupHelpScreen(this, this.field_146289_q, PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.entityFilter.helpText", (Object[])new Object[0]), 60));
        } else if (this.textField.getBounds().contains(x, y)) {
            String str = I18n.func_135052_a((String)"gui.entityFilter", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(str, this.guiLeft + (this.xSize - this.field_146289_q.func_78256_a(str)) / 2, this.guiTop + this.ySize + 5, 0x808080);
        }
        if (this.fireMode == ItemMicromissiles.FireMode.DUMB) {
            return;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        if (this.point != null) {
            double px = this.point.getX();
            double py = this.point.getY();
            RenderUtils.glColorHex(0x2020A0, 255);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + GuiMicromissile.SELECTOR_BOUNDS.x), (float)(this.guiTop + GuiMicromissile.SELECTOR_BOUNDS.y), (float)0.0f);
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            int size = this.dragging ? 5 : 3;
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2d((double)(px - (double)size), (double)py);
            GL11.glVertex2d((double)(px + (double)size), (double)py);
            GlStateManager.func_187437_J();
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2d((double)px, (double)(py - (double)size));
            GL11.glVertex2d((double)px, (double)(py + (double)size));
            GlStateManager.func_187437_J();
            GL11.glEnable((int)2852);
            GL11.glLineStipple((int)1, (short)-21846);
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2d((double)px, (double)py);
            GL11.glVertex2d((double)((double)GuiMicromissile.SELECTOR_BOUNDS.width / 2.0), (double)0.0);
            GlStateManager.func_187437_J();
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2d((double)px, (double)py);
            GL11.glVertex2d((double)0.0, (double)GuiMicromissile.SELECTOR_BOUNDS.height);
            GlStateManager.func_187437_J();
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2d((double)px, (double)py);
            GL11.glVertex2d((double)GuiMicromissile.SELECTOR_BOUNDS.width, (double)GuiMicromissile.SELECTOR_BOUNDS.height);
            GlStateManager.func_187437_J();
            GL11.glDisable((int)2852);
            GlStateManager.func_179121_F();
            RenderUtils.glColorHex(0xFFFFFF, 255);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_187441_d((float)10.0f);
        GL11.glEnable((int)2852);
        GL11.glLineStipple((int)1, (short)-258);
        RenderUtils.glColorHex(49152, 255);
        GlStateManager.func_187447_r((int)1);
        GL11.glVertex2i((int)125, (int)51);
        GL11.glVertex2i((int)(125 + (int)(49.0f * this.topSpeed)), (int)51);
        GlStateManager.func_187437_J();
        GlStateManager.func_187447_r((int)1);
        GL11.glVertex2i((int)125, (int)71);
        GL11.glVertex2i((int)(125 + (int)(49.0f * this.turnSpeed)), (int)71);
        GlStateManager.func_187437_J();
        GlStateManager.func_187447_r((int)1);
        GL11.glVertex2i((int)125, (int)91);
        GL11.glVertex2i((int)(125 + (int)(49.0f * this.damage)), (int)91);
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
        GL11.glDisable((int)2852);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.sendTimer > 0 && --this.sendTimer == 0) {
            this.sendSettingsToServer(false);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MICROMISSILE;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.trySetPoint(mouseX, mouseY)) {
            this.dragging = true;
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.dragging) {
            this.trySetPoint(mouseX, mouseY);
        } else {
            super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.dragging) {
            this.sendSettingsToServer(false);
            this.dragging = false;
        } else {
            super.func_146286_b(mouseX, mouseY, state);
        }
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        if (widget instanceof WidgetTextField) {
            this.entityFilter = ((WidgetTextField)widget).func_146179_b();
            if (this.validateEntityFilter(this.entityFilter)) {
                this.sendTimer = 5;
            }
        }
    }

    private boolean validateEntityFilter(String filter) {
        try {
            this.warningButton.field_146125_m = false;
            this.warningButton.setTooltipText("");
            EntityFilter f = new EntityFilter(filter);
            return true;
        }
        catch (Exception e) {
            this.warningButton.field_146125_m = true;
            this.warningButton.setTooltipText(TextFormatting.GOLD + e.getMessage());
            return false;
        }
    }

    private boolean trySetPoint(int mouseX, int mouseY) {
        Point p = this.getPoint(mouseX, mouseY);
        if (p != null) {
            double dSpeed = (double)MAX_DIST - p.distance(TOP_SPEED_PT);
            double dTurnSpd = (double)MAX_DIST - p.distance(TURN_SPEED_PT);
            double dDamage = (double)MAX_DIST - p.distance(DMG_PT);
            double total = dSpeed + dTurnSpd + dDamage;
            this.topSpeed = (float)(dSpeed / total);
            this.turnSpeed = (float)(dTurnSpd / total);
            this.damage = (float)(dDamage / total);
            this.point = p;
            return true;
        }
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1) {
            this.sendSettingsToServer(true);
        } else if (button.field_146127_k == 2) {
            int n = this.fireMode.ordinal() + 1;
            if (n >= ItemMicromissiles.FireMode.values().length) {
                n = 0;
            }
            this.fireMode = ItemMicromissiles.FireMode.values()[n];
            this.setupWidgets();
            this.sendSettingsToServer(false);
        } else {
            super.func_146284_a(button);
        }
    }

    private void sendSettingsToServer(boolean saveDefault) {
        NetworkHandler.sendToServer(new PacketUpdateMicromissileSettings(this.topSpeed, this.turnSpeed, this.damage, this.point, this.entityFilter, this.fireMode, saveDefault));
    }

    private Point getPoint(int mouseX, int mouseY) {
        Rectangle r = new Rectangle(GuiMicromissile.SELECTOR_BOUNDS.x + this.guiLeft, GuiMicromissile.SELECTOR_BOUNDS.y + this.guiTop, GuiMicromissile.SELECTOR_BOUNDS.width, GuiMicromissile.SELECTOR_BOUNDS.height);
        if (!r.contains(mouseX, mouseY)) {
            return null;
        }
        Point p = new Point(mouseX - r.x, mouseY - r.y);
        return this.isPointInTriangle(p, TOP_SPEED_PT, TURN_SPEED_PT, DMG_PT) ? p : null;
    }

    private boolean isPointInTriangle(Point s, Point a, Point b, Point c) {
        boolean s_ab;
        int as_x;
        int as_y;
        if ((c.x - a.x) * as_y - (c.y - a.y) * as_x > 0 == (s_ab = (b.x - a.x) * (as_y = s.y - a.y) - (b.y - a.y) * (as_x = s.x - a.x) > 0)) {
            return false;
        }
        return (c.x - b.x) * (s.y - b.y) - (c.y - b.y) * (s.x - b.x) > 0 == s_ab;
    }
}

