/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.Container4UpgradeSlots;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElectrostaticCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElectrostaticCompressor
extends GuiPneumaticContainerBase<TileEntityElectrostaticCompressor> {
    private int connectedCompressors = 1;
    private int ticksExisted;
    private GuiAnimatedStat electrostaticStat;

    public GuiElectrostaticCompressor(InventoryPlayer player, TileEntityElectrostaticCompressor te) {
        super(new Container4UpgradeSlots<TileEntityElectrostaticCompressor>(player, te), te, "pneumaticcraft:textures/gui/gui_pressure_chamber.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.electrostaticStat = this.addAnimatedStat("gui.tab.electrostaticCompressor.info.title", new ItemStack(Blockss.ELECTROSTATIC_COMPRESSOR), -14638849, false);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 53, 19, 0x404040);
    }

    @Override
    protected void addWarnings(List<String> textList) {
        super.addWarnings(textList);
        if (10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath < 200000 / this.connectedCompressors) {
            textList.add("gui.tab.problems.electrostatic.notEnoughGrounding");
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.ticksExisted % 20 == 0) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            positions.add(((TileEntityElectrostaticCompressor)this.te).func_174877_v());
            ((TileEntityElectrostaticCompressor)this.te).getElectrostaticGrid(positions, ((TileEntityElectrostaticCompressor)this.te).func_145831_w(), ((TileEntityElectrostaticCompressor)this.te).func_174877_v(), null);
            this.connectedCompressors = 0;
            for (BlockPos coord : positions) {
                if (((TileEntityElectrostaticCompressor)this.te).func_145831_w().func_180495_p(coord).func_177230_c() != Blockss.ELECTROSTATIC_COMPRESSOR) continue;
                ++this.connectedCompressors;
            }
        }
        ++this.ticksExisted;
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.WHITE + "Energy production:");
        info.add(TextFormatting.BLACK + PneumaticCraftUtils.roundNumberTo(200000.0f / (float)this.connectedCompressors, 1) + " mL/lightning strike");
        info.add(TextFormatting.BLACK + "(" + this.connectedCompressors + " connected compressors)");
        info.add(TextFormatting.WHITE + "Maximum air redirection:");
        info.add(TextFormatting.BLACK + PneumaticCraftUtils.roundNumberTo(10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath, 1) + " mL/lightning strike");
        info.add(TextFormatting.WHITE + "Lightning rod length (iron bars above):");
        info.add(TextFormatting.BLACK + "" + ((TileEntityElectrostaticCompressor)this.te).ironBarsAbove);
        String t = PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntityElectrostaticCompressor)this.te).getStrikeChance(), false);
        info.add(TextFormatting.WHITE + "Average strike time: ");
        info.add(TextFormatting.BLACK + "" + t + " (with optimal-sized grid)");
        this.electrostaticStat.setText(info);
    }
}

