/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerAssemblyController;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAssemblyController
extends GuiPneumaticContainerBase<TileEntityAssemblyController> {
    private GuiAnimatedStat statusStat;

    public GuiAssemblyController(InventoryPlayer player, TileEntityAssemblyController te) {
        super(new ContainerAssemblyController(player, te), te, "pneumaticcraft:textures/gui/gui_assembly_controller.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.statusStat = this.addAnimatedStat("gui.tab.status", new ItemStack(Blockss.ASSEMBLY_CONTROLLER), -22016, false);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 18, 21, 0x404040);
        this.field_146289_q.func_78276_b("Prog.", 70, 24, 0x404040);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        EnumSet<AssemblyProgram.EnumMachine> foundMachines = EnumSet.of(AssemblyProgram.EnumMachine.CONTROLLER);
        for (IAssemblyMachine machine : ((TileEntityAssemblyController)this.te).findMachines(AssemblyProgram.EnumMachine.values().length)) {
            foundMachines.add(machine.getAssemblyType());
        }
        for (AssemblyProgram.EnumMachine m : AssemblyProgram.EnumMachine.values()) {
            if (m == AssemblyProgram.EnumMachine.CONTROLLER) continue;
            String s = foundMachines.contains((Object)m) ? TextFormatting.DARK_GREEN + "\u2714 " : TextFormatting.RED + "\u2717 ";
            text.add(s + TextFormatting.BLACK + " " + I18n.func_135052_a((String)m.getTranslationKey(), (Object[])new Object[0]));
        }
        return text;
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        ((TileEntityAssemblyController)this.te).addProblems(textList);
    }
}

