/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.client.gui.objects.editing;

import com.jarhax.prestige.api.Reward;
import com.jarhax.prestige.client.gui.GuiPrestigeBase;
import com.jarhax.prestige.client.gui.objects.GuiObject;
import com.jarhax.prestige.client.utils.RenderUtils;
import java.util.LinkedList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiObjectEditingReward
extends GuiObject {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("prestige", "textures/gui/gui_prestige_icons.png");
    private final Reward reward;
    private int gridX;
    private int gridY;
    private boolean moving;
    private ItemStack renderStack;
    private boolean locked = false;

    public GuiObjectEditingReward(GuiPrestigeBase parent, int x, int y, int width, int height, Reward reward) {
        super(parent, x, y, width, height);
        this.reward = reward;
        this.setX(x);
        this.setY(y);
        this.renderStack = reward.getIcon();
        this.locked = false;
    }

    public GuiObjectEditingReward(GuiPrestigeBase parent, Reward reward) {
        super(parent, reward.getX(), reward.getY(), 32, 32);
        this.reward = reward;
        this.setX(reward.getX());
        this.setY(reward.getY());
        this.renderStack = reward.getIcon();
        this.locked = false;
    }

    public GuiObjectEditingReward(GuiPrestigeBase parent, int x, int y, Reward reward) {
        super(parent, x, y, 32, 32);
        this.reward = reward;
        this.setX(x);
        this.setY(y);
        this.renderStack = reward.getIcon();
        this.locked = false;
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public void draw(int left, int top, int mouseX, int mouseY, float partialTicks) {
        this.mc.func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (!this.isPlaced()) {
            RenderUtils.drawTexturedModalRect(this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
            this.renderIcon();
        } else {
            this.mc.func_110434_K().func_110577_a(BACKGROUND);
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            if (this.getX() < (float)this.getParent().getLeft()) {
                offsetX = (float)this.getParent().getLeft() - this.getX();
            }
            if (this.getY() < (float)this.getParent().getTop()) {
                offsetY = (float)this.getParent().getTop() - this.getY();
            }
            if (offsetX != 0.0f || offsetY != 0.0f) {
                RenderUtils.drawTexturedModalRect(this.getX() + offsetX, this.getY() + offsetY, offsetX, offsetY, (float)this.getWidth() - offsetX, (float)this.getHeight() - offsetY);
            } else {
                if (this.getX() + (float)this.getWidth() > (float)(this.getParent().getLeft() + this.getParent().getGuiWidth())) {
                    offsetX = (float)(this.getParent().getLeft() + this.getParent().getGuiWidth()) - (this.getX() + (float)this.getWidth());
                }
                if (this.getY() + (float)this.getHeight() > (float)(this.getParent().getTop() + this.getParent().getGuiHeight())) {
                    offsetY = (float)(this.getParent().getTop() + this.getParent().getGuiHeight()) - (this.getY() + (float)this.getHeight());
                }
                if (offsetX != 0.0f || offsetY != 0.0f) {
                    RenderUtils.drawTexturedModalRect(this.getX(), this.getY(), 0.0f, 0.0f, (float)this.getWidth() + offsetX, (float)this.getHeight() + offsetY);
                } else {
                    RenderUtils.drawTexturedModalRect(this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
                }
            }
            if (this.getX() + 8.0f > (float)this.getParent().getLeft() && this.getX() + (float)this.getWidth() - 8.0f < (float)(this.getParent().getLeft() + this.getParent().getGuiWidth()) && this.getY() + 8.0f > (float)this.getParent().getTop() && this.getY() + (float)this.getHeight() - 8.0f < (float)(this.getParent().getTop() + this.getParent().getGuiHeight())) {
                this.renderIcon();
            }
            if (!this.isPlaced() && this.collides(mouseX, mouseY, mouseX, mouseY)) {
                this.drawText(mouseX, mouseY);
            }
        }
    }

    public void renderIcon() {
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glTranslated((double)(this.getX() + 8.0f), (double)(this.getY() + 8.0f), (double)-50.0);
        this.mc.func_175599_af().func_175042_a(this.renderStack, 0, 0);
        GL11.glTranslated((double)(-(this.getX() + 8.0f)), (double)(-(this.getY() + 8.0f)), (double)50.0);
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    public void drawText(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
        LinkedList<String> text = new LinkedList<String>();
        text.add(this.reward.getTitle());
        text.add("");
        text.add("- " + this.reward.getDescription());
        text.add("- costs: " + this.reward.getCost());
        this.getParent().func_146283_a(text, mouseX, mouseY);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GL11.glPopMatrix();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.addX(-((float)this.getParent().getPrevMX() - (float)mouseX) / 1.0f);
        this.addY(-((float)this.getParent().getPrevMY() - (float)mouseY) / 1.0f);
        this.setX(Math.round(this.x));
        this.setY(Math.round(this.y));
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
    }

    public Reward getReward() {
        return this.reward;
    }

    public boolean isPlaced() {
        return this.reward.isPlaced();
    }

    public void setPlaced(boolean placed) {
        this.reward.setPlaced(placed);
    }

    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    @Override
    public void setX(float x) {
        super.setX(x);
        this.reward.setX((int)x);
    }

    @Override
    public void setY(float y) {
        super.setY(y);
        this.reward.setY((int)y);
    }

    @Override
    public float getX() {
        return this.reward.getX();
    }

    @Override
    public float getY() {
        return this.reward.getY();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

