/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.client.gui;

import com.jarhax.prestige.Prestige;
import com.jarhax.prestige.api.Reward;
import com.jarhax.prestige.client.gui.GuiPrestigeBase;
import com.jarhax.prestige.client.gui.objects.GuiObject;
import com.jarhax.prestige.client.gui.objects.GuiObjectBackGround;
import com.jarhax.prestige.client.gui.objects.GuiObjectBorder;
import com.jarhax.prestige.client.gui.objects.GuiObjectReward;
import com.jarhax.prestige.client.utils.RenderUtils;
import com.jarhax.prestige.packet.PacketGiveRewards;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiPrestige
extends GuiPrestigeBase {
    private GuiObjectBackGround backGround;
    private GuiObjectBorder border;
    private final int north = 0;
    private final int east = 1;
    private final int south = 2;
    private final int west = 3;

    public void generateRewards() {
        this.guiObjects.clear();
        LinkedList<Reward> values = new LinkedList<Reward>(Prestige.REGISTRY.values());
        values.sort(Comparator.comparing(Reward::getIdentifier));
        for (Reward reward : values) {
            if (!reward.isPlaced()) continue;
            GuiObjectReward rew = new GuiObjectReward(this, reward);
            if (Prestige.clientPlayerData.hasReward(reward)) {
                rew.setPurchased(true);
            }
            this.guiObjects.put(rew.getReward().getIdentifier(), rew);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        String[] rewards = new String[this.getRewardsToGive().size()];
        for (int i = 0; i < rewards.length; ++i) {
            rewards[i] = this.getRewardsToGive().get(i).getReward().getIdentifier();
        }
        Prestige.NETWORK.sendToServer((IMessage)new PacketGiveRewards(rewards));
    }

    public void func_73866_w_() {
        this.guiWidth = 256;
        this.guiHeight = 256;
        super.func_73866_w_();
        this.left = this.field_146294_l / 2 - this.guiWidth / 2;
        this.top = this.field_146295_m / 2 - this.guiHeight / 2;
        this.player = this.field_146297_k.field_71439_g;
        this.guiObjects = new LinkedHashMap();
        this.backGround = new GuiObjectBackGround(this, this.left, this.top, this.guiWidth, this.guiHeight);
        this.border = new GuiObjectBorder(this, this.left, this.top, this.guiWidth, this.guiHeight);
        this.generateRewards();
        this.rewardsToGive = new LinkedList();
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiObject object2 : this.guiObjects.values()) {
            object2.update();
        }
        this.guiObjects.values().forEach(object -> object.setVisible(true));
        for (GuiObject object2 : this.guiObjects.values()) {
            if (object2.isAlwaysVisible()) continue;
            if (this.backGround.collides(object2)) {
                object2.setVisible(true);
                continue;
            }
            object2.setVisible(false);
        }
        this.guiObjects.values().forEach(object -> object.setVisible(true));
        for (GuiObject object2 : this.guiObjects.values()) {
            if (!((GuiObjectReward)object2).isPlaced() || object2.isAlwaysVisible()) continue;
            if (this.backGround.collides(object2)) {
                object2.setVisible(true);
                continue;
            }
            object2.setVisible(false);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        this.backGround.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("prestige", "textures/gui/gui_prestige_line.png"));
        ScaledResolution resolution = new ScaledResolution(this.field_146297_k);
        int scale = resolution.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((this.left + 4) * scale), (int)((this.top - 1 + 4) * scale), (int)((this.guiWidth - 8) * scale), (int)((this.guiHeight + 1 - 8) * scale));
        for (GuiObjectReward parent : this.guiObjects.values()) {
            Vec3d start = new Vec3d((double)(parent.getX() + (float)(parent.getWidth() / 2)), (double)(parent.getY() + (float)(parent.getHeight() / 2)), 0.0);
            for (Reward child : parent.getReward().getChildren()) {
                GuiObjectReward childObject = this.getObject(child.getIdentifier());
                if (childObject == null) continue;
                Vec3d end = new Vec3d((double)(childObject.getX() + (float)(childObject.getWidth() / 2)), (double)(childObject.getY() + (float)(childObject.getHeight() / 2)), 0.0);
                GlStateManager.func_179094_E();
                double angle = Math.atan2(childObject.getY() - parent.getY(), childObject.getX() - parent.getX()) * 180.0 / Math.PI;
                GL11.glTranslated((double)(parent.getX() + (float)(parent.getWidth() / 2)), (double)(parent.getY() + (float)(parent.getHeight() / 2)), (double)0.0);
                GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
                float length = (float)start.func_72438_d(end);
                RenderUtils.drawTexturedModalRect(0.0f, 0.0f, RenderUtils.remap((float)((double)System.nanoTime() / 1.0E9), 1.0f, 0.0f, 0.0f, 16.0f), 0.0f, length, 4.0f);
                GL11.glTranslated((double)(-(parent.getX() + (float)(parent.getWidth() / 2))), (double)(-(parent.getY() + (float)(parent.getHeight() / 2))), (double)0.0);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179094_E();
        for (GuiObject object : this.guiObjects.values()) {
            if (!object.isVisible()) continue;
            object.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        }
        for (GuiObjectReward reward : this.guiObjects.values()) {
            if (!reward.isVisible() || !(reward.getY() >= (float)this.getTop()) || !(reward.getY() + (float)reward.getHeight() <= (float)(this.getTop() + this.getGuiHeight()))) continue;
            reward.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)0.0, (double)0.0, (double)500.0);
        this.border.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        this.field_146289_q.func_78276_b("Prestige points: " + Prestige.clientPlayerData.getPrestige(), this.left + 5, this.top + 5, 0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        GlStateManager.func_179121_F();
        for (GuiObjectReward reward : this.guiObjects.values()) {
            if (!reward.isVisible() || !reward.collides(mouseX, mouseY, mouseX, mouseY) || !(reward.getY() >= (float)this.getTop()) || !(reward.getY() + (float)reward.getHeight() <= (float)(this.getTop() + this.getGuiHeight()))) continue;
            reward.drawText(mouseX, mouseY);
        }
        boolean[] sides = new boolean[4];
        for (GuiObjectReward reward : this.guiObjects.values()) {
            if (!reward.isPlaced()) continue;
            if (sides[0] && sides[1] && sides[3] && sides[2]) break;
            if (!sides[3] && reward.getX() < (float)this.left) {
                sides[3] = true;
            }
            if (!sides[1] && reward.getX() > (float)(this.left + this.guiWidth)) {
                sides[1] = true;
            }
            if (!sides[0] && reward.getY() < (float)this.top) {
                sides[0] = true;
            }
            if (sides[2] || !(reward.getY() > (float)(this.top + this.guiHeight))) continue;
            sides[2] = true;
        }
        if (sides[0] || sides[1] || sides[3] || sides[2]) {
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("prestige", "textures/gui/gui_prestige_line.png"));
            if (sides[0]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + 25, this.left + this.guiWidth / 2, this.top + 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 + 4, this.top + 25, this.left + this.guiWidth / 2, this.top + 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + 25, this.left + this.guiWidth / 2 + 4, this.top + 25, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[2]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2, this.top + this.guiHeight - 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 + 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2, this.top + this.guiHeight - 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2 + 4, this.top + this.guiHeight - 25, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[1]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 - 4, this.left + this.guiWidth - 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 + 4, this.left + this.guiWidth - 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 - 4, this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 + 4, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[3]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 - 4, this.left + 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 + 4, this.left + 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 - 4, this.left + 25, this.top + this.guiHeight / 2 + 4, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146278_c(int tint) {
        super.func_146278_c(tint);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.prevMX = mouseX;
        this.prevMY = mouseY;
        if (mouseButton == 0) {
            boolean valid = true;
            for (GuiObject object : this.guiObjects.values()) {
                if (object.collides(mouseX, mouseY, mouseX, mouseY)) {
                    valid = false;
                }
                object.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (valid) {
                this.backGround.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (GuiObjectReward object : this.guiObjects.values()) {
            object.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
        this.backGround.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.prevMX = mouseX;
        this.prevMY = mouseY;
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.prevMX = -1;
        this.prevMY = -1;
        this.backGround.mouseReleased(mouseX, mouseY, state);
        for (GuiObject object : this.guiObjects.values()) {
            object.mouseReleased(mouseX, mouseY, state);
        }
    }

    public GuiObjectReward getObject(String identifier) {
        for (GuiObjectReward reward : this.guiObjects.values()) {
            if (!reward.getReward().getIdentifier().equals(identifier)) continue;
            return reward;
        }
        return null;
    }
}

