/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import com.google.common.collect.Sets;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;

public class NBTUtils {
    @Nullable
    public static NBTTagCompound writeTagToNBT(@Nullable NBTTagCompound nbt, @Nonnull String name, @Nullable NBTBase tag) {
        if (nbt == null) {
            if (tag == null) {
                return nbt;
            }
            nbt = new NBTTagCompound();
        }
        if (tag == null) {
            nbt.func_82580_o(name);
        } else {
            nbt.func_74782_a(name, tag);
        }
        return nbt;
    }

    @Nonnull
    public static ItemStack setRootCompoundTag(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null && nbt.func_82582_d()) {
            nbt = null;
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nullable
    public static NBTTagCompound getRootCompoundTag(@Nonnull ItemStack stack, boolean create) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (!create) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    @Nullable
    public static NBTTagCompound getCompoundTag(@Nullable NBTTagCompound nbt, @Nonnull String tagName, boolean create) {
        if (nbt == null) {
            return null;
        }
        if (!create) {
            return nbt.func_150297_b(tagName, 10) ? nbt.func_74775_l(tagName) : null;
        }
        if (!nbt.func_150297_b(tagName, 10)) {
            nbt.func_74782_a(tagName, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tagName);
    }

    @Nullable
    public static NBTTagCompound getCompoundTag(@Nonnull ItemStack stack, @Nullable String tagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getRootCompoundTag(stack, create);
        if (tagName != null) {
            nbt = NBTUtils.getCompoundTag(nbt, tagName, create);
        }
        return nbt;
    }

    @Nullable
    public static NBTTagCompound getCompoundTag(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getRootCompoundTag(stack, create);
        if (containerTagName != null) {
            nbt = NBTUtils.getCompoundTag(nbt, containerTagName, create);
        }
        return NBTUtils.getCompoundTag(nbt, tagName, create);
    }

    public static void removeCompoundTag(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        if (nbt != null && nbt.func_150297_b(tagName, 10)) {
            nbt.func_82580_o(tagName);
            if (nbt.func_82582_d()) {
                if (containerTagName != null) {
                    stack.func_77978_p().func_82580_o(containerTagName);
                } else {
                    stack.func_77982_d(null);
                }
            }
        }
    }

    @Nullable
    public static NBTTagCompound getCompoundExcludingTags(@Nonnull NBTTagCompound tag, boolean copyTags, String ... exclude) {
        NBTTagCompound newTag = new NBTTagCompound();
        HashSet excludeSet = Sets.newHashSet((Object[])exclude);
        for (String key : tag.func_150296_c()) {
            if (excludeSet.contains(key)) continue;
            newTag.func_74782_a(key, copyTags ? tag.func_74781_a(key).func_74737_b() : tag.func_74781_a(key));
        }
        return newTag.func_82582_d() ? null : newTag;
    }

    @Nonnull
    public static String getOrCreateString(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, @Nonnull String value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        if (!nbt.func_150297_b(tagName, 8)) {
            nbt.func_74778_a(tagName, value);
            return value;
        }
        return nbt.func_74779_i(tagName);
    }

    @Nullable
    public static UUID getUUIDFromItemStack(@Nonnull ItemStack stack, @Nullable String containerTagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, create);
        UUID uuid = NBTUtils.getUUIDFromNBT(nbt);
        if (uuid == null && create) {
            uuid = UUID.randomUUID();
            nbt.func_74772_a("UUIDM", uuid.getMostSignificantBits());
            nbt.func_74772_a("UUIDL", uuid.getLeastSignificantBits());
        }
        return uuid;
    }

    @Nullable
    public static UUID getUUIDFromNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null && nbt.func_150297_b("UUIDM", 4) && nbt.func_150297_b("UUIDL", 4)) {
            return new UUID(nbt.func_74763_f("UUIDM"), nbt.func_74763_f("UUIDL"));
        }
        return null;
    }

    public static void setUUID(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull UUID uuid) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74772_a("UUIDM", uuid.getMostSignificantBits());
        nbt.func_74772_a("UUIDL", uuid.getLeastSignificantBits());
    }

    public static boolean getBoolean(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74767_n(tagName) : false;
    }

    public static void setBoolean(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, boolean value) {
        NBTUtils.getCompoundTag(stack, containerTagName, true).func_74757_a(tagName, value);
    }

    public static void toggleBoolean(@Nonnull NBTTagCompound nbt, @Nonnull String tagName) {
        nbt.func_74757_a(tagName, !nbt.func_74767_n(tagName));
    }

    public static void toggleBoolean(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.toggleBoolean(nbt, tagName);
    }

    public static byte getByte(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74771_c(tagName) : (byte)0;
    }

    public static void setByte(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, byte value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(@Nonnull NBTTagCompound nbt, @Nonnull String tagName, int minValue, int maxValue) {
        NBTUtils.cycleByteValue(nbt, tagName, minValue, maxValue, false);
    }

    public static void cycleByteValue(@Nonnull NBTTagCompound nbt, @Nonnull String tagName, int minValue, int maxValue, boolean reverse) {
        byte value = nbt.func_74771_c(tagName);
        if (reverse) {
            if ((value = (byte)(value - 1)) < minValue) {
                value = (byte)maxValue;
            }
        } else if ((value = (byte)(value + 1)) > maxValue) {
            value = (byte)minValue;
        }
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, int maxValue) {
        NBTUtils.cycleByteValue(stack, containerTagName, tagName, maxValue, false);
    }

    public static void cycleByteValue(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, int maxValue, boolean reverse) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, 0, maxValue, reverse);
    }

    public static void cycleByteValue(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, int minValue, int maxValue, boolean reverse) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, minValue, maxValue, reverse);
    }

    public static short getShort(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74765_d(tagName) : (short)0;
    }

    public static void setShort(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, short value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74777_a(tagName, value);
    }

    public static int getInteger(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74762_e(tagName) : 0;
    }

    public static void setInteger(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, int value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74768_a(tagName, value);
    }

    public static long getLong(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74763_f(tagName) : 0L;
    }

    public static void setLong(@Nonnull ItemStack stack, @Nullable String containerTagName, @Nonnull String tagName, long value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74772_a(tagName, value);
    }

    @Nonnull
    public static NBTTagList writeInts(int ... values) {
        NBTTagList tagList = new NBTTagList();
        for (int i : values) {
            tagList.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        return tagList;
    }

    @Nonnull
    public static NBTTagList writeDoubles(double ... values) {
        NBTTagList tagList = new NBTTagList();
        for (double d : values) {
            tagList.func_74742_a((NBTBase)new NBTTagDouble(d));
        }
        return tagList;
    }

    @Nullable
    public static NBTTagList getTagList(@Nonnull ItemStack containerStack, @Nullable String containerTagName, @Nonnull String tagName, int tagType, boolean create) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(containerStack, containerTagName, create);
        if (create && !nbt.func_150297_b(tagName, 9)) {
            nbt.func_74782_a(tagName, (NBTBase)new NBTTagList());
        }
        return nbt != null ? nbt.func_150295_c(tagName, tagType) : null;
    }

    public static void setTagList(@Nonnull ItemStack containerStack, @Nullable String containerTagName, @Nonnull String tagName, @Nonnull NBTTagList tagList) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(containerStack, containerTagName, true);
        nbt.func_74782_a(tagName, (NBTBase)tagList);
    }

    @Nonnull
    public static NBTTagList insertToTagList(@Nonnull NBTTagList tagList, @Nonnull NBTBase tag, int index) {
        int i;
        int count = tagList.func_74745_c();
        if (index >= count) {
            index = count > 0 ? count - 1 : 0;
        }
        NBTTagList newList = new NBTTagList();
        for (i = 0; i < index; ++i) {
            newList.func_74742_a(tagList.func_74744_a(0));
        }
        newList.func_74742_a(tag);
        count = tagList.func_74745_c();
        for (i = 0; i < count; ++i) {
            newList.func_74742_a(tagList.func_74744_a(0));
        }
        return newList;
    }

    @Nullable
    public static NBTTagList getStoredItemsList(@Nonnull ItemStack containerStack, boolean create) {
        return NBTUtils.getTagList(containerStack, null, "Items", 10, create);
    }

    @Nonnull
    public static ItemStack loadItemStackFromTag(@Nonnull NBTTagCompound tag) {
        ItemStack stack = new ItemStack(tag);
        if (tag.func_150297_b("ActualCount", 3)) {
            stack.func_190920_e(tag.func_74762_e("ActualCount"));
        }
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    @Nonnull
    public static NBTTagCompound storeItemStackInTag(@Nonnull ItemStack stack, @Nonnull NBTTagCompound tag) {
        if (!stack.func_190926_b()) {
            stack.func_77955_b(tag);
            if (stack.func_190916_E() > 127) {
                tag.func_74774_a("Count", (byte)(stack.func_190916_E() & 0x7F));
                tag.func_74768_a("ActualCount", stack.func_190916_E());
            }
        }
        return tag;
    }

    public static void readStoredItemsFromTag(@Nonnull NBTTagCompound nbt, NonNullList<ItemStack> items, @Nonnull String tagName) {
        if (!nbt.func_150297_b(tagName, 9)) {
            return;
        }
        NBTTagList nbtTagList = nbt.func_150295_c(tagName, 10);
        int num = nbtTagList.func_74745_c();
        int listSize = items.size();
        for (int i = 0; i < num; ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            short slotNum = tag.func_74765_d("Slot");
            if (slotNum < 0 || slotNum >= listSize) continue;
            items.set((int)slotNum, (Object)NBTUtils.loadItemStackFromTag(tag));
        }
    }

    @Nonnull
    public static NBTTagList createTagListForItems(NonNullList<ItemStack> items) {
        NBTTagList nbtTagList = new NBTTagList();
        int invSlots = items.size();
        for (int slotNum = 0; slotNum < invSlots; ++slotNum) {
            ItemStack stack = (ItemStack)items.get(slotNum);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = NBTUtils.storeItemStackInTag(stack, new NBTTagCompound());
            if (invSlots <= 127) {
                tag.func_74774_a("Slot", (byte)slotNum);
            } else {
                tag.func_74777_a("Slot", (short)slotNum);
            }
            nbtTagList.func_74742_a((NBTBase)tag);
        }
        return nbtTagList;
    }

    @Nonnull
    public static NBTTagCompound writeItemsToTag(@Nonnull NBTTagCompound nbt, NonNullList<ItemStack> items, @Nonnull String tagName, boolean keepExtraSlots) {
        int invSlots = items.size();
        NBTTagList nbtTagList = NBTUtils.createTagListForItems(items);
        if (keepExtraSlots && nbt.func_150297_b(tagName, 9)) {
            NBTTagList nbtTagListExisting = nbt.func_150295_c(tagName, 10);
            int count = nbtTagListExisting.func_74745_c();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tag = nbtTagListExisting.func_150305_b(i);
                short slotNum = tag.func_74765_d("Slot");
                if (slotNum < invSlots) continue;
                nbtTagList.func_74742_a((NBTBase)tag);
            }
        }
        if (nbtTagList.func_74745_c() > 0) {
            nbt.func_74782_a(tagName, (NBTBase)nbtTagList);
        } else {
            nbt.func_82580_o(tagName);
        }
        return nbt;
    }

    public static void writeItemsToContainerItem(@Nonnull ItemStack containerStack, NonNullList<ItemStack> items, @Nonnull String tagName, boolean keepExtraSlots) {
        NBTTagCompound nbt = NBTUtils.getRootCompoundTag(containerStack, true);
        NBTUtils.writeItemsToTag(nbt, items, tagName, keepExtraSlots);
        NBTUtils.setRootCompoundTag(containerStack, nbt);
    }

    public static NBTTagCompound storeCachedInventory(NBTTagCompound nbt, IItemHandler inv, int maxEntries) {
        NBTTagList list = new NBTTagList();
        int stacks = 0;
        long items = 0L;
        int size = inv.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            if (stacks < maxEntries) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("dn", stack.func_82833_r());
                tag.func_74768_a("c", stack.func_190916_E());
                list.func_74742_a((NBTBase)tag);
            }
            ++stacks;
            items += (long)stack.func_190916_E();
        }
        if (stacks > 0) {
            NBTTagCompound wrapper = new NBTTagCompound();
            wrapper.func_74782_a("il", (NBTBase)list);
            wrapper.func_74768_a("ts", stacks);
            wrapper.func_74772_a("ti", items);
            nbt.func_74782_a("InvCache", (NBTBase)wrapper);
        } else {
            nbt.func_82580_o("InvCache");
        }
        return nbt;
    }

    public static void getCachedInventoryStrings(ItemStack stack, List<String> lines, int maxItemLines) {
        NBTTagCompound wrapper = NBTUtils.getCompoundTag(stack, "InvCache", false);
        if (wrapper == null) {
            return;
        }
        String preWhite = TextFormatting.WHITE.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        NBTTagList list = wrapper.func_150295_c("il", 10);
        int totalStacks = wrapper.func_74762_e("ts");
        int numLines = Math.min(list.func_74745_c(), maxItemLines);
        String countStr = EUStringUtils.formatNumberWithKSeparators(wrapper.func_74763_f("ti"));
        lines.add(EnderUtilities.proxy.format("enderutilities.tooltip.item.memorycard.items.stackcount", totalStacks, countStr));
        for (int i = 0; i < numLines; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            countStr = EUStringUtils.formatNumberWithKSeparators(tag.func_74762_e("c"));
            lines.add(String.format("  %s%s%s %s", preWhite, countStr, rst, tag.func_74779_i("dn")));
        }
        if (totalStacks > maxItemLines) {
            lines.add(EnderUtilities.proxy.format("enderutilities.tooltip.item.andmorestacksnotlisted", preWhite, totalStacks - maxItemLines, rst));
        }
    }

    public static String getItemStackDisplayName(ItemStack stack, String nameBase) {
        NBTTagCompound wrapper = NBTUtils.getCompoundTag(stack, "InvCache", false);
        if (wrapper == null) {
            return nameBase;
        }
        String preGree = TextFormatting.GREEN.toString();
        String rstWhite = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        NBTTagList list = wrapper.func_150295_c("il", 10);
        int totalStacks = wrapper.func_74762_e("ts");
        if (totalStacks == 1) {
            NBTTagCompound tag = list.func_150305_b(0);
            String countStr = EUStringUtils.formatNumber(tag.func_74762_e("c"), 9999L, 4);
            nameBase = String.format("%s - %s%s%s (%s)", nameBase, preGree, tag.func_74779_i("dn"), rstWhite, countStr);
        } else if (totalStacks > 0) {
            nameBase = String.format("%s (%d %s)", nameBase, totalStacks, I18n.func_74838_a((String)"enderutilities.tooltip.item.stacks"));
        }
        return nameBase;
    }

    public static void setPositionInTileEntityNBT(@Nonnull NBTTagCompound tag, @Nonnull BlockPos pos) {
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
    }

    public static void removePositionFromTileEntityNBT(@Nonnull NBTTagCompound tag) {
        tag.func_82580_o("x");
        tag.func_82580_o("y");
        tag.func_82580_o("z");
    }

    public static void writeBlockStateToTag(IBlockState state, @Nonnull NBTTagCompound tag) {
        tag.func_74778_a("name", state.func_177230_c().getRegistryName().toString());
        tag.func_74774_a("meta", (byte)state.func_177230_c().func_176201_c(state));
    }

    @Nullable
    public static IBlockState readBlockStateFromTag(NBTTagCompound tag) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i("name")));
        if (block != null && block != Blocks.field_150350_a) {
            return block.func_176203_a((int)tag.func_74771_c("meta"));
        }
        return null;
    }
}

