/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;

public class PositionHelper {
    public double posX;
    public double posY;
    public double posZ;

    public PositionHelper(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public PositionHelper(Entity entity) {
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
    }

    public PositionHelper(RayTraceResult rayTraceResult) {
        this.initPos(rayTraceResult, 0.0, 0.0, 0.0);
    }

    public PositionHelper(RayTraceResult rayTraceResult, Entity entity) {
        if (entity != null) {
            this.initPos(rayTraceResult, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        } else {
            this.initPos(rayTraceResult, 0.0, 0.0, 0.0);
        }
    }

    public void initPos(RayTraceResult rayTraceResult, double x, double y, double z) {
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && rayTraceResult.field_72307_f != null) {
            this.posX = rayTraceResult.field_72307_f.field_72450_a;
            this.posY = rayTraceResult.field_72307_f.field_72448_b;
            this.posZ = rayTraceResult.field_72307_f.field_72449_c;
        } else if (rayTraceResult.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (rayTraceResult.field_72307_f != null) {
                this.posX = rayTraceResult.field_72307_f.field_72450_a;
                this.posY = rayTraceResult.field_72307_f.field_72448_b;
                this.posZ = rayTraceResult.field_72307_f.field_72449_c;
            } else if (rayTraceResult.field_72308_g != null) {
                this.posX = rayTraceResult.field_72308_g.field_70165_t;
                this.posY = rayTraceResult.field_72308_g.field_70163_u;
                this.posZ = rayTraceResult.field_72308_g.field_70161_v;
            } else {
                this.posX = x;
                this.posY = y;
                this.posZ = z;
            }
        } else {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }
    }

    public void adjustPositionToTouchFace(Entity entity, EnumFacing facing) {
        this.posX += (double)((float)facing.func_82601_c() * entity.field_70130_N / 2.0f);
        this.posZ += (double)((float)facing.func_82599_e() * entity.field_70130_N / 2.0f);
        if (facing.equals((Object)EnumFacing.DOWN)) {
            this.posY -= (double)entity.field_70131_O;
        }
    }
}

