/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityPortal
extends TileEntityEnderUtilities {
    private TargetData destination = null;
    private OwnerData owner = null;
    private int color = 10490080;
    private boolean targetIsPortal;

    public TileEntityPortal() {
        super("portal");
    }

    public int getColor() {
        return this.color;
    }

    public TargetData getDestination() {
        return this.destination;
    }

    public OwnerData getOwner() {
        return this.owner;
    }

    public boolean targetIsPortal() {
        return this.targetIsPortal;
    }

    public void setPortalData(PortalData data) {
        this.destination = data.getDestination();
        this.owner = data.getOwner();
        this.color = data.getColor();
        this.targetIsPortal = data.targetIsPortal();
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.color = nbt.func_74762_e("Color");
        this.destination = TargetData.readTargetFromNBT(nbt);
        this.owner = OwnerData.getOwnerDataFromNBT(nbt);
        this.targetIsPortal = nbt.func_74767_n("Paired");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Color", this.color);
        if (this.targetIsPortal) {
            nbt.func_74757_a("Paired", this.targetIsPortal);
        }
        if (this.destination != null) {
            this.destination.writeToNBT(nbt);
        }
        if (this.owner != null) {
            this.owner.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74768_a("c", this.color);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        if (tag.func_74764_b("c")) {
            this.color = tag.func_74762_e("c");
        }
        super.handleUpdateTag(tag);
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    public static class PortalData {
        private final TargetData destination;
        private final OwnerData owner;
        private final int color;
        private final boolean targetIsPortal;

        public PortalData(TargetData destination, OwnerData owner, int color, boolean targetIsPortal) {
            this.destination = destination;
            this.owner = owner;
            this.color = color;
            this.targetIsPortal = targetIsPortal;
        }

        public TargetData getDestination() {
            return this.destination;
        }

        public OwnerData getOwner() {
            return this.owner;
        }

        public int getColor() {
            return this.color;
        }

        public boolean targetIsPortal() {
            return this.targetIsPortal;
        }
    }
}

