/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.enderutilities.block.BlockInserter;
import fi.dy.masa.enderutilities.gui.client.GuiInserter;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerInserter;
import fi.dy.masa.enderutilities.network.message.ISyncableTile;
import fi.dy.masa.enderutilities.network.message.MessageSyncTileEntity;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityInserter
extends TileEntityEnderUtilitiesInventory
implements ISyncableTile {
    private ItemStackHandlerTileEntity itemHandlerFilters;
    private final List<EnumFacing> enabledSides = new ArrayList<EnumFacing>();
    private final List<EnumFacing> validSides = new ArrayList<EnumFacing>();
    private EnumFacing facingOpposite = EnumFacing.SOUTH;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORED;
    private int filterMask = FilterSetting.MATCH_META.getBitMask();
    private int delay = 4;
    private int outputSideIndex;
    private boolean isFiltered;
    private boolean disableUpdateScheduling;
    private NonNullList<ItemStack> cachedFilterStacks;

    public TileEntityInserter() {
        super("inserter");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 1, 1, false, "Items", this);
        this.itemHandlerExternal = new ItemHandlerWrapperInserter(this.itemHandlerBase);
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public void setIsFiltered(boolean isFiltered) {
        this.isFiltered = isFiltered;
        if (isFiltered && this.itemHandlerFilters == null) {
            this.itemHandlerFilters = new ItemStackHandlerTileEntity(1, 27, 64, false, "ItemsFilter", this);
            this.cachedFilterStacks = NonNullList.func_191196_a();
        }
    }

    public int getUpdateDelay() {
        return this.delay;
    }

    public void setUpdateDelay(int delay) {
        this.delay = MathHelper.func_76125_a((int)delay, (int)0, (int)72000);
    }

    public void setStackLimit(int limit) {
        this.itemHandlerBase.setStackLimit(MathHelper.func_76125_a((int)limit, (int)1, (int)64));
    }

    public boolean isFilterSettingEnabled(FilterSetting setting) {
        return setting.isEnabledInBitmask(this.filterMask);
    }

    public int getFilterMask() {
        return this.filterMask;
    }

    public void setFilterMask(int mask) {
        this.filterMask = mask;
    }

    public int getRedstoneModeIntValue() {
        return this.redstoneMode.getIntValue();
    }

    public void setRedstoneModeFromInteger(int ordinal) {
        this.redstoneMode = RedstoneMode.fromInt(ordinal);
    }

    public IItemHandler getFilterInventory() {
        return this.itemHandlerFilters;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block blockIn) {
        this.updateValidSides(true);
        this.scheduleBlockUpdate(this.delay, false);
    }

    public void toggleOutputSide(EnumFacing side) {
        if (side != this.getFacing() && side != this.getFacing().func_176734_d()) {
            if (this.enabledSides.contains(side)) {
                this.enabledSides.remove(side);
            } else {
                this.enabledSides.add(side);
            }
            this.updateValidSides(true);
        }
    }

    private void updateValidSides(boolean markDirtyAndSync) {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.validSides.clear();
            World world = this.func_145831_w();
            BlockPos pos = this.func_174877_v();
            for (EnumFacing side : this.enabledSides) {
                TileEntity te = world.func_175625_s(pos.func_177972_a(side));
                if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) continue;
                this.validSides.add(side);
            }
            if (markDirtyAndSync) {
                this.func_70296_d();
                this.syncSideConfigs();
            }
        }
    }

    private void syncSideConfigs() {
        this.sendPacketToWatchers(new MessageSyncTileEntity(this.func_174877_v(), this.getCombinesSideMask()));
    }

    public ImmutableList<EnumFacing> getEnabledOutputSides() {
        return ImmutableList.copyOf(this.enabledSides);
    }

    public ImmutableList<EnumFacing> getValidOutputSides() {
        return ImmutableList.copyOf(this.validSides);
    }

    private int getSideMask(List<EnumFacing> list) {
        int mask = 0;
        for (EnumFacing side : list) {
            mask |= 1 << side.func_176745_a();
        }
        return mask;
    }

    private void setSidesFromMask(int mask, List<EnumFacing> list) {
        list.clear();
        for (EnumFacing side : EnumFacing.values()) {
            if ((mask & 1 << side.func_176745_a()) == 0) continue;
            list.add(side);
        }
    }

    private int getCombinesSideMask() {
        return this.getSideMask(this.validSides) << 6 | this.getSideMask(this.enabledSides);
    }

    private void setSidesFromCombinedMask(int mask) {
        this.setSidesFromMask(mask & 0x3F, this.enabledSides);
        this.setSidesFromMask(mask >>> 6 & 0x3F, this.validSides);
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facingOpposite = facing.func_176734_d();
        super.setFacing(facing);
        this.syncSideConfigs();
    }

    @Override
    public void func_189667_a(Rotation rotationIn) {
        ArrayList<EnumFacing> newList = new ArrayList<EnumFacing>();
        for (EnumFacing side : this.enabledSides) {
            newList.add(rotationIn.func_185831_a(side));
        }
        this.enabledSides.clear();
        this.enabledSides.addAll(newList);
        this.updateValidSides(false);
        super.func_189667_a(rotationIn);
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        if (this.itemHandlerFilters != null) {
            this.itemHandlerFilters.deserializeNBT(nbt);
            this.inventoryChanged(this.itemHandlerFilters.getInventoryId(), 0);
        }
        super.readItemsFromNBT(nbt);
    }

    @Override
    public void writeItemsToNBT(NBTTagCompound nbt) {
        if (this.itemHandlerFilters != null) {
            nbt.func_179237_a(this.itemHandlerFilters.serializeNBT());
        }
        super.writeItemsToNBT(nbt);
    }

    @Override
    public void setPlacementProperties(World world, BlockPos pos, ItemStack stack, NBTTagCompound tag) {
        if (tag.func_150297_b("inserter.stack_limit", 1)) {
            this.setStackLimit(tag.func_74771_c("inserter.stack_limit"));
        }
        if (tag.func_150297_b("inserter.delay", 3)) {
            this.setUpdateDelay(tag.func_74762_e("inserter.delay"));
        }
        if (tag.func_150297_b("inserter.redstone_mode", 1)) {
            this.setRedstoneModeFromInteger(tag.func_74771_c("inserter.redstone_mode"));
        }
        this.func_70296_d();
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.setSidesFromCombinedMask(nbt.func_74765_d("Sides"));
        this.delay = nbt.func_74762_e("Delay");
        this.setStackLimit(nbt.func_74771_c("StackLimit"));
        short mask = nbt.func_74765_d("SettingsMask");
        this.filterMask = mask & 0xF;
        this.outputSideIndex = mask >>> 8 & 7;
        this.setIsFiltered((mask & 0x80) != 0);
        this.setRedstoneModeFromInteger(mask >>> 12 & 3);
        super.readFromNBTCustom(nbt);
        this.facingOpposite = this.getFacing().func_176734_d();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74777_a("Sides", (short)this.getCombinesSideMask());
        nbt.func_74768_a("Delay", this.delay);
        nbt.func_74774_a("StackLimit", (byte)this.itemHandlerBase.getInventoryStackLimit());
        int mask = this.filterMask;
        if (this.isFiltered) {
            mask |= 0x80;
        }
        mask |= this.outputSideIndex << 8;
        nbt.func_74777_a("SettingsMask", (short)(mask |= this.redstoneMode.getIntValue() << 12));
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74777_a("sd", (short)this.getCombinesSideMask());
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.setSidesFromCombinedMask(tag.func_74765_d("sd"));
        super.handleUpdateTag(tag);
        this.updateFilterState(true);
    }

    private void updateFilterState(boolean updateHilightBoxes) {
        World world;
        IBlockState state;
        if (this.func_145831_w() != null && (state = (world = this.func_145831_w()).func_180495_p(this.func_174877_v())).func_177230_c() == EnderUtilitiesBlocks.INSERTER) {
            this.setIsFiltered(state.func_177229_b(BlockInserter.TYPE) == BlockInserter.InserterType.FILTERED);
            if (updateHilightBoxes) {
                EnderUtilitiesBlocks.INSERTER.updateBlockHilightBoxes(world, this.func_174877_v(), this.getFacing());
            }
            world.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void onNeighborTileChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!this.disableUpdateScheduling && this.shouldOperate()) {
            this.scheduleBlockUpdate(this.delay, false);
        }
    }

    private boolean shouldOperate() {
        return this.redstoneMode.shouldOperate(this.func_145831_w().func_175640_z(this.func_174877_v()));
    }

    @Override
    public void onScheduledBlockUpdate(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.shouldOperate()) {
            if (!this.itemHandlerBase.getStackInSlot(0).func_190926_b()) {
                if (this.tryPushOutItems(world, pos)) {
                    this.scheduleBlockUpdate(this.delay, false);
                }
            } else if (this.tryPullInItems(world, pos)) {
                this.scheduleBlockUpdate(this.delay, false);
            }
        }
    }

    private boolean tryPullInItems(World world, BlockPos posSelf) {
        IItemHandler inv;
        TileEntity te = world.func_175625_s(posSelf.func_177972_a(this.facingOpposite));
        if (te != null && !(te instanceof TileEntityInserter) && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing()) && (inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getFacing())) != null) {
            this.disableUpdateScheduling = true;
            ItemStack stack = this.isFiltered && this.isFilterSettingEnabled(FilterSetting.IS_INPUT_FILTER) ? this.tryPullInItemsThatPassFilters(inv) : InventoryUtils.getItemsFromFirstNonEmptySlot(inv, this.itemHandlerBase.getInventoryStackLimit(), false);
            if (!stack.func_190926_b()) {
                this.itemHandlerBase.insertItem(0, stack, false);
                this.disableUpdateScheduling = false;
                return true;
            }
            this.disableUpdateScheduling = false;
        }
        return false;
    }

    @Nullable
    private ItemStack tryPullInItemsThatPassFilters(IItemHandler inv) {
        int slots = inv.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b() || !this.itemAllowedByFilters(stack)) continue;
            return inv.extractItem(slot, this.itemHandlerBase.getInventoryStackLimit(), false);
        }
        return ItemStack.field_190927_a;
    }

    private boolean itemAllowedByFilters(@Nonnull ItemStack stack) {
        boolean match = InventoryUtils.matchingStackFoundOnList(this.cachedFilterStacks, stack, !this.isFilterSettingEnabled(FilterSetting.MATCH_META), !this.isFilterSettingEnabled(FilterSetting.MATCH_NBT));
        return match == this.isFilterSettingEnabled(FilterSetting.IS_WHITELIST);
    }

    private boolean tryPushOutItems(World world, BlockPos posSelf) {
        boolean shouldPushToSides = true;
        if (this.isFiltered && !this.isFilterSettingEnabled(FilterSetting.IS_INPUT_FILTER)) {
            shouldPushToSides = this.itemAllowedByFilters(this.itemHandlerBase.getStackInSlot(0));
        }
        if (shouldPushToSides) {
            int numValidSides = this.validSides.size();
            for (int i = 0; i < numValidSides; ++i) {
                if (this.outputSideIndex >= numValidSides) {
                    this.outputSideIndex = 0;
                }
                if (this.outputSideIndex >= numValidSides) continue;
                EnumFacing side = this.validSides.get(this.outputSideIndex);
                ++this.outputSideIndex;
                if (!this.tryPushOutItemsToSide(world, posSelf, side)) continue;
                return true;
            }
        }
        return this.tryPushOutItemsToSide(world, posSelf, this.getFacing());
    }

    private boolean tryPushOutItemsToSide(World world, BlockPos posSelf, EnumFacing side) {
        IItemHandler inv;
        TileEntity te = world.func_175625_s(posSelf.func_177972_a(side));
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()) && (inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) != null) {
            this.disableUpdateScheduling = true;
            ItemStack stack = this.itemHandlerBase.extractItem(0, 64, false);
            int sizeOrig = stack.func_190916_E();
            boolean movedSome = false;
            if (!(stack = InventoryUtils.tryInsertItemStackToInventory(inv, stack)).func_190926_b()) {
                movedSome = stack.func_190916_E() != sizeOrig;
                this.itemHandlerBase.insertItem(0, stack, false);
            }
            this.disableUpdateScheduling = false;
            return stack.func_190926_b() || movedSome;
        }
        return false;
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        if (inventoryId == 1 && this.itemHandlerFilters != null) {
            this.cachedFilterStacks = InventoryUtils.createInventorySnapshotOfNonEmptySlots(this.itemHandlerFilters);
        }
        if (!this.disableUpdateScheduling) {
            this.scheduleBlockUpdate(this.delay, false);
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int actionIn, int element) {
        GuiAction action = GuiAction.fromInt(actionIn);
        switch (action) {
            case CHANGE_REDSTONE_MODE: {
                int ord = this.redstoneMode.getIntValue() + element;
                if (ord >= RedstoneMode.values().length) {
                    ord = 0;
                } else if (ord < 0) {
                    ord = RedstoneMode.values().length - 1;
                }
                this.setRedstoneModeFromInteger(ord);
                this.scheduleBlockUpdate(this.delay, false);
                break;
            }
            case CHANGE_DELAY: {
                this.setUpdateDelay(this.delay + element);
                break;
            }
            case CHANGE_STACK_LIMIT: {
                this.setStackLimit(this.itemHandlerBase.getInventoryStackLimit() + element);
                break;
            }
            case CHANGE_FILTERS: {
                this.filterMask = (this.filterMask ^ element) & 0xF;
                this.scheduleBlockUpdate(this.delay, false);
            }
        }
        this.func_70296_d();
    }

    @Override
    public ContainerInserter getContainer(EntityPlayer player) {
        return new ContainerInserter(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiInserter(this.getContainer(player), this);
    }

    @Override
    public void syncTile(int[] values, ItemStack[] stacks) {
        if (values.length == 1) {
            this.setSidesFromCombinedMask(values[0]);
            this.updateFilterState(true);
        }
    }

    public static enum GuiAction {
        CHANGE_DELAY,
        CHANGE_STACK_LIMIT,
        CHANGE_FILTERS,
        CHANGE_REDSTONE_MODE;


        public static GuiAction fromInt(int action) {
            return GuiAction.values()[action % GuiAction.values().length];
        }
    }

    public static enum RedstoneMode {
        IGNORED(0, true),
        LOW(1, false),
        HIGH(2, true);

        private final int intValue;
        private final boolean operateWhenPowered;

        private RedstoneMode(int intValue, boolean operateWhenPowered) {
            this.intValue = intValue;
            this.operateWhenPowered = operateWhenPowered;
        }

        public boolean shouldOperate(boolean isPowered) {
            return this == IGNORED || this.operateWhenPowered == isPowered;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static RedstoneMode fromInt(int intValue) {
            for (RedstoneMode mode : RedstoneMode.values()) {
                if (mode.getIntValue() != intValue) continue;
                return mode;
            }
            return IGNORED;
        }
    }

    public static enum FilterSetting {
        IS_INPUT_FILTER(1),
        IS_WHITELIST(2),
        MATCH_META(4),
        MATCH_NBT(8);

        private final int bitMask;

        private FilterSetting(int bitMask) {
            this.bitMask = bitMask;
        }

        public boolean isEnabledInBitmask(int mask) {
            return (mask & this.bitMask) != 0;
        }

        public int getBitMask() {
            return this.bitMask;
        }
    }

    private class ItemHandlerWrapperInserter
    implements IItemHandler {
        private final IItemHandler baseHandler;

        private ItemHandlerWrapperInserter(IItemHandler baseHandler) {
            this.baseHandler = baseHandler;
        }

        public int getSlots() {
            return this.baseHandler.getSlots();
        }

        public int getSlotLimit(int slot) {
            return this.baseHandler.getSlotLimit(slot);
        }

        public ItemStack getStackInSlot(int slot) {
            return this.baseHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate) {
                TileEntityInserter.this.scheduleBlockUpdate(TileEntityInserter.this.delay, false);
            }
            return this.baseHandler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    }
}

