/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import com.google.common.base.Predicate;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockElevator;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.BlockPosDistance;
import fi.dy.masa.enderutilities.util.PositionUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityElevator
extends TileEntityEnderUtilities {
    private boolean redstoneState;
    private boolean topHalf;

    public static Predicate<TileEntity> isMatchingElevator(final EnumDyeColor color) {
        return new Predicate<TileEntity>(){

            public boolean apply(TileEntity te) {
                if (!(te instanceof TileEntityElevator)) {
                    return false;
                }
                IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
                return state.func_177230_c() instanceof BlockElevator && state.func_177229_b(BlockElevator.COLOR) == color;
            }
        };
    }

    public TileEntityElevator() {
        super("ender_elevator");
    }

    public boolean isTopHalf() {
        return this.topHalf;
    }

    public void setIsTopHalf(boolean isTopHalf) {
        this.topHalf = isTopHalf;
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.redstoneState = nbt.func_74767_n("Redstone");
        this.topHalf = nbt.func_74767_n("Top");
    }

    @Override
    public NBTTagCompound writeToNBTCustom(NBTTagCompound nbt) {
        nbt.func_74757_a("Redstone", this.redstoneState);
        nbt.func_74757_a("Top", this.topHalf);
        if (this.camoState != null) {
            nbt.func_74768_a("Camo", Block.func_176210_f((IBlockState)this.camoState));
            if (this.camoData != null) {
                nbt.func_74782_a("CamoData", (NBTBase)this.camoData);
            }
        }
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74757_a("t", this.topHalf);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.topHalf = tag.func_74767_n("t");
        super.handleUpdateTag(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block blockIn) {
        boolean redstone = worldIn.func_175640_z(pos);
        if (redstone != this.redstoneState && redstone) {
            this.activateByRedstone(worldIn.func_175687_A(pos) < 8);
        }
        this.redstoneState = redstone;
    }

    public void activateByRedstone(boolean goingUp) {
        BlockPos pos = this.func_174877_v();
        AxisAlignedBB bbBlock = this.func_145831_w().func_180495_p(pos).func_185900_c((IBlockAccess)this.func_145831_w(), pos);
        AxisAlignedBB bb = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o() + bbBlock.field_72337_e, (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + bbBlock.field_72337_e + 1.0, (double)(pos.func_177952_p() + 1));
        List entities = this.func_145831_w().func_72872_a(Entity.class, bb);
        for (Entity entity : entities) {
            this.activateForEntity(entity, goingUp);
        }
    }

    public void activateForEntity(Entity entity, boolean goingUp) {
        Vec3d posDifference = this.getMoveVector(goingUp);
        if (posDifference != null) {
            entity.func_70634_a(entity.field_70165_t + posDifference.field_72450_a, entity.field_70163_u + posDifference.field_72448_b, entity.field_70161_v + posDifference.field_72449_c);
            this.func_145831_w().func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.3f, 1.8f);
        }
    }

    private Vec3d getMoveVector(boolean goingUp) {
        BlockPos center = goingUp ? this.func_174877_v().func_177984_a() : this.func_174877_v().func_177977_b();
        int rangeHorizontal = 64;
        int rangeVerticalUp = goingUp ? 256 : 0;
        int rangeVerticalDown = goingUp ? 0 : 256;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockElevator)) {
            EnderUtilities.logger.warn("Wrong block in {}#getMoveVector", (Object)((Object)((Object)this)).getClass().getSimpleName());
            return null;
        }
        List<BlockPosDistance> elevators = PositionUtils.getTileEntityPositions(this.func_145831_w(), center, rangeHorizontal, rangeVerticalUp, rangeVerticalDown, TileEntityElevator.isMatchingElevator((EnumDyeColor)state.func_177229_b(BlockElevator.COLOR)));
        if (elevators.size() > 0) {
            World world = this.func_145831_w();
            BlockPos posFound = elevators.get((int)0).pos;
            AxisAlignedBB bbThis = world.func_180495_p(this.func_174877_v()).func_185900_c((IBlockAccess)world, this.func_174877_v());
            AxisAlignedBB bbFound = world.func_180495_p(posFound).func_185900_c((IBlockAccess)world, posFound);
            double yDiff = (double)posFound.func_177956_o() + bbFound.field_72337_e - ((double)this.func_174877_v().func_177956_o() + bbThis.field_72337_e);
            return new Vec3d((double)(posFound.func_177958_n() - this.func_174877_v().func_177958_n()), yDiff, (double)(posFound.func_177952_p() - this.func_174877_v().func_177952_p()));
        }
        return null;
    }

    @Override
    protected boolean hasCamouflageAbility() {
        return true;
    }

    @Override
    public boolean hasGui() {
        return false;
    }
}

