/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.tileentity.TileEntityElevator;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageKeyPressed
implements IMessage {
    private int keyPressed;

    public MessageKeyPressed() {
    }

    public MessageKeyPressed(int key) {
        this.keyPressed = key;
    }

    public void fromBytes(ByteBuf buf) {
        this.keyPressed = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.keyPressed);
    }

    public static class Handler
    implements IMessageHandler<MessageKeyPressed, IMessage> {
        public IMessage onMessage(final MessageKeyPressed message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                EnderUtilities.logger.error("Wrong side in MessageKeyPressed: " + ctx.side);
                return null;
            }
            final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (sendingPlayer == null) {
                EnderUtilities.logger.error("Sending player was null in MessageKeyPressed");
                return null;
            }
            WorldServer playerWorldServer = sendingPlayer.func_71121_q();
            if (playerWorldServer == null) {
                EnderUtilities.logger.error("World was null in MessageKeyPressed");
                return null;
            }
            playerWorldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, (EntityPlayer)sendingPlayer);
                }
            });
            return null;
        }

        protected void processMessage(MessageKeyPressed message, EntityPlayer player) {
            if (this.handleEnderElevator(message, player)) {
                return;
            }
            ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, IKeyBound.class);
            if (!stack.func_190926_b() && ((IKeyBound)stack.func_77973_b()).doKeyBindingAction(player, stack, message.keyPressed)) {
                return;
            }
            stack = InventoryUtils.getFirstItemOfType(player, IKeyBoundUnselected.class);
            if (!stack.func_190926_b() && ((IKeyBoundUnselected)stack.func_77973_b()).doUnselectedKeyAction(player, stack, message.keyPressed)) {
                return;
            }
            this.handleKeysGeneric(message.keyPressed, player);
        }

        protected boolean handleEnderElevator(MessageKeyPressed message, EntityPlayer player) {
            if (message.keyPressed == 0x2000000 || message.keyPressed == 0x1000000) {
                BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                World world = player.func_130014_f_();
                TileEntityElevator te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)world, pos, TileEntityElevator.class);
                if (te == null) {
                    te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)world, pos.func_177977_b(), TileEntityElevator.class);
                }
                if (te != null) {
                    te.activateForEntity((Entity)player, message.keyPressed == 0x2000000);
                    return true;
                }
            }
            return false;
        }

        private boolean handleKeysGeneric(int key, EntityPlayer player) {
            BlockPos pos;
            TileEntityEnderUtilities te;
            World world = player.func_130014_f_();
            RayTraceResult trace = EntityUtils.getRayTraceFromPlayer(world, player, true);
            if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK && (te = BlockEnderUtilities.getTileEntitySafely((IBlockAccess)world, pos = trace.func_178782_a(), TileEntityEnderUtilities.class)) != null) {
                return te.onInputAction(key, player, trace, world, pos);
            }
            return false;
        }
    }
}

