/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.effects.Effects;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageAddEffects
implements IMessage {
    public static final int SOUND = 1;
    public static final int PARTICLES = 2;
    public static final int EFFECT_TELEPORT = 1;
    public static final int EFFECT_ENDER_TOOLS = 2;
    public static final int EFFECT_PARTICLES = 100;
    public static final int EFFECT_SOUND_EVENT = 110;
    private int effectType;
    private int flags;
    private float x;
    private float y;
    private float z;
    private int particleCount;
    private double offset;
    private double velocity;
    private int soundEventId;
    private float pitch;
    private float volume;
    private boolean repeat;

    public MessageAddEffects() {
    }

    public MessageAddEffects(int id, int flags, double x, double y, double z) {
        this(id, flags, x, y, z, 32, 0.2f, 2.0f);
    }

    public MessageAddEffects(int id, int flags, double x, double y, double z, int particleCount) {
        this(id, flags, x, y, z, particleCount, 0.2f, 2.0f);
    }

    public MessageAddEffects(int id, int flags, double x, double y, double z, int particleCount, float offset, float velocity) {
        this.effectType = id;
        this.flags = flags;
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        this.particleCount = particleCount;
        this.offset = offset;
        this.velocity = velocity;
    }

    public MessageAddEffects(int soundId, float pitch, float volume, boolean repeat, boolean stop, float x, float y, float z) {
        this.effectType = 110;
        this.soundEventId = soundId;
        this.flags = stop ? 1 : 0;
        this.pitch = pitch;
        this.volume = volume;
        this.repeat = repeat;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.effectType);
        buf.writeByte(this.flags);
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        if (this.effectType == 110) {
            buf.writeShort((int)((short)this.soundEventId));
            buf.writeFloat(this.pitch);
            buf.writeFloat(this.volume);
            buf.writeBoolean(this.repeat);
        } else {
            buf.writeShort(this.particleCount);
            buf.writeFloat((float)this.offset);
            buf.writeFloat((float)this.velocity);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.effectType = buf.readByte();
        this.flags = buf.readByte();
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        if (this.effectType == 110) {
            this.soundEventId = buf.readShort();
            this.pitch = buf.readFloat();
            this.volume = buf.readFloat();
            this.repeat = buf.readBoolean();
        } else {
            this.particleCount = buf.readShort();
            this.offset = buf.readFloat();
            this.velocity = buf.readFloat();
        }
    }

    public static class Handler
    implements IMessageHandler<MessageAddEffects, IMessage> {
        public IMessage onMessage(final MessageAddEffects message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                EnderUtilities.logger.error("Wrong side in MessageAddEffects: " + ctx.side);
                return null;
            }
            final Minecraft mc = FMLClientHandler.instance().getClient();
            final EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
            if (mc == null || player == null) {
                EnderUtilities.logger.error("Minecraft or player was null in MessageAddEffects");
                return null;
            }
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, player, player.func_130014_f_(), mc.func_147118_V());
                }
            });
            return null;
        }

        protected void processMessage(MessageAddEffects message, EntityPlayer player, World world, SoundHandler soundHandler) {
            if (message.effectType == 1) {
                if ((message.flags & 1) == 1) {
                    float pitch = 0.9f + world.field_73012_v.nextFloat() * 0.125f + world.field_73012_v.nextFloat() * 0.125f;
                    Effects.playSoundClient(world, message.x, message.y, message.z, SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 0.8f, pitch);
                }
                if ((message.flags & 2) == 2) {
                    Effects.spawnParticles(world, EnumParticleTypes.PORTAL, message.x, message.y, message.z, message.particleCount, message.offset, message.velocity);
                }
            } else if (message.effectType == 2) {
                if ((message.flags & 1) == 1 && Configs.useToolSounds) {
                    Effects.playSoundClient(world, message.x, message.y, message.z, SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 0.08f, 1.8f);
                }
                if ((message.flags & 2) == 2 && Configs.useToolParticles) {
                    Effects.spawnParticles(world, EnumParticleTypes.PORTAL, message.x, message.y, message.z, message.particleCount, message.offset, message.velocity);
                }
            } else if (message.effectType == 100) {
                Effects.spawnParticles(world, EnumParticleTypes.func_179342_a((int)message.flags), message.x, message.y, message.z, message.particleCount, message.offset, message.velocity);
            } else if (message.effectType == 110) {
                EnderUtilities.proxy.playSound(message.soundEventId, message.pitch, message.volume, message.repeat, message.flags != 0, message.x, message.y, message.z);
            }
        }
    }
}

