/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.Multimap;
import fi.dy.masa.enderutilities.item.base.IAnvilRepairable;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.tool.ItemEnderTool;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemVoidPickaxe
extends ItemEnderUtilities
implements IKeyBound,
IAnvilRepairable {
    public float efficiencyOnProperMaterial = 6.0f;
    private final ItemEnderTool.ToolMaterial material = ItemEnderTool.ToolMaterial.ENDER_ALLOY_ADVANCED;

    public ItemVoidPickaxe(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(this.material.getMaxUses());
        this.setNoRepair();
        this.setHarvestLevel("pickaxe", this.material.getHarvestLevel());
        this.setHarvestLevel("axe", this.material.getHarvestLevel());
        this.setHarvestLevel("shovel", this.material.getHarvestLevel());
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || newStack.func_77960_j() != oldStack.func_77960_j();
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }

    public int getDamage(ItemStack stack) {
        return NBTUtils.getShort(stack, null, "ToolDamage");
    }

    public void setDamage(ItemStack stack, int damage) {
        damage = MathHelper.func_76125_a((int)damage, (int)0, (int)this.getMaxDamage(stack));
        NBTUtils.setShort(stack, null, "ToolDamage", (short)damage);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.isDamaged(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamage(stack) / (double)this.getMaxDamage(stack);
    }

    public boolean isToolBroken(ItemStack stack) {
        return this.getDamage(stack) >= this.getMaxDamage(stack);
    }

    private boolean addToolDamage(ItemStack stack, int amount, EntityLivingBase living1, EntityLivingBase living2) {
        if (this.isToolBroken(stack)) {
            return false;
        }
        if (amount > 0) {
            int unbreakingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"unbreaking"), (ItemStack)stack);
            int amountNegated = 0;
            for (int i = 0; unbreakingLevel > 0 && i < amount; ++i) {
                if (field_77697_d.nextInt(amount + 1) <= 0) continue;
                ++amountNegated;
            }
            if ((amount -= amountNegated) <= 0) {
                return false;
            }
        }
        int damage = this.getDamage(stack);
        damage = Math.min(damage + amount, this.material.getMaxUses());
        if (!living1.func_130014_f_().field_72995_K) {
            this.setDamage(stack, damage);
        }
        if (damage == this.material.getMaxUses()) {
            living1.func_70669_a(stack);
        }
        return true;
    }

    private boolean addToolDamage(ItemStack stack, World world, BlockPos pos, IBlockState state, EntityLivingBase livingBase) {
        if (!this.isToolBroken(stack) && state.func_185887_b(world, pos) > 0.0f) {
            int dmg = this.isFastMode(stack) ? 2 : 1;
            this.addToolDamage(stack, dmg, livingBase, livingBase);
            return true;
        }
        return false;
    }

    @Override
    public boolean repairItem(ItemStack stack, int amount) {
        int damage;
        if (amount == -1) {
            amount = this.material.getMaxUses();
        }
        boolean repaired = (damage = Math.max(this.getDamage(stack) - amount, 0)) != this.getDamage(stack);
        this.setDamage(stack, damage);
        return repaired;
    }

    @Override
    public boolean isRepairItem(@Nonnull ItemStack stackTool, @Nonnull ItemStack stackMaterial) {
        return InventoryUtils.areItemStacksEqual(stackMaterial, this.material.getRepairItemStack());
    }

    @Override
    public boolean canApplyEnchantment(ItemStack stackTool, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.ALL || enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE || enchantment.field_77351_y == EnumEnchantmentType.DIGGER;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        this.addToolDamage(stack, 2, living1, living2);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.func_130014_f_();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) >= 0.0f) {
            if (!world.field_72995_K) {
                BlockUtils.setBlockToAirWithoutSpillingContents(world, pos);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.addToolDamage(stack, world, pos, state, (EntityLivingBase)player);
            }
            return !world.field_72995_K;
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.isToolBroken(stack)) {
            return 0.1f;
        }
        float eff = this.efficiencyOnProperMaterial;
        if (this.isFastMode(stack)) {
            eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"efficiency"), (ItemStack)stack) >= 5 ? 124.0f : 24.0f;
        }
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return eff;
        }
        if (this.canHarvestBlock(state, stack)) {
            return eff;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        if (this.isToolBroken(stack)) {
            return false;
        }
        return state.func_185904_a() != Material.field_175972_I;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (!this.isToolBroken(stack)) {
            return this.material.getHarvestLevel();
        }
        return -1;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.getEnchantability();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        double dmg;
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        double d = dmg = this.isToolBroken(stack) ? 0.5 : 6.0;
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            String modifierName = "Tool modifier";
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, modifierName, dmg, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, modifierName, (double)-2.7f, 0));
        }
        return multimap;
    }

    private boolean isFastMode(ItemStack stack) {
        return NBTUtils.getBoolean(stack, null, "FastMode");
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 1) {
            NBTUtils.cycleByteValue(stack, null, "FastMode", 1);
            return true;
        }
        return false;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String preGreen = TextFormatting.GREEN.toString();
        String modeStr = this.isFastMode(stack) ? I18n.func_135052_a((String)"enderutilities.tooltip.item.fast", (Object[])new Object[0]) : I18n.func_135052_a((String)"enderutilities.tooltip.item.normal", (Object[])new Object[0]);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + preGreen + modeStr + rst);
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("enderutilities", "fastmode"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemVoidPickaxe.this.isFastMode(stack) ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("enderutilities", "broken"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemVoidPickaxe.this.isToolBroken(stack) ? 1.0f : 0.0f;
            }
        });
    }
}

