/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.block;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemBlockEnderUtilities
extends ItemBlock {
    protected String[] blockNames;
    protected String[] tooltipNames;

    public ItemBlockEnderUtilities(BlockEnderUtilities block) {
        super((Block)block);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.setBlockNames(block.getUnlocalizedNames());
        this.setTooltipNames(block.getTooltipNames());
    }

    public void setBlockNames(String[] names) {
        this.blockNames = names;
    }

    public void setTooltipNames(String[] names) {
        this.tooltipNames = names;
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77667_c(ItemStack stack) {
        if (this.blockNames != null && stack.func_77960_j() < this.blockNames.length) {
            return "tile." + ReferenceNames.getDotPrefixedName(this.blockNames[stack.func_77960_j()]);
        }
        return super.func_77667_c(stack);
    }

    public String getTooltipName(ItemStack stack) {
        if (this.tooltipNames != null) {
            if (stack.func_77960_j() < this.tooltipNames.length) {
                return "tile." + ReferenceNames.getDotPrefixedName(this.tooltipNames[stack.func_77960_j()]);
            }
            if (this.tooltipNames.length == 1) {
                return "tile." + ReferenceNames.getDotPrefixedName(this.tooltipNames[0]);
            }
        }
        return this.func_77667_c(stack);
    }

    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = EnderUtilities.proxy.isShiftKeyDown();
        if (stack.func_77978_p() == null) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 2) {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.holdshiftfordescription", (Object[])new Object[0]));
            } else {
                list.addAll(tmpList);
            }
        }
        tmpList.clear();
        boolean isAdvanced = advanced == ITooltipFlag.TooltipFlags.ADVANCED;
        EntityPlayer player = EnderUtilities.proxy.getClientPlayer();
        this.addTooltipLines(stack, player, tmpList, isAdvanced, true);
        if (!verbose && tmpList.size() > 2) {
            tmpList.clear();
            this.addTooltipLines(stack, player, tmpList, isAdvanced, false);
            if (tmpList.size() > 0) {
                list.add(tmpList.get(0));
            }
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.holdshift", (Object[])new Object[0]));
        } else {
            list.addAll(tmpList);
        }
    }

    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderUtilities.addTranslatedTooltip(this.getTooltipName(stack) + ".tooltips", list, verbose, new Object[0]);
    }

    public boolean func_77662_d() {
        return true;
    }
}

