/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.wrapper;

import fi.dy.masa.enderutilities.inventory.IItemHandlerSelective;
import fi.dy.masa.enderutilities.inventory.IItemHandlerSize;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerWrapperContainer
implements IItemHandlerModifiable,
IItemHandlerSelective,
IItemHandlerSize {
    protected final IItemHandlerModifiable baseHandlerModifiable;
    protected final IItemHandler wrapperHandler;
    private final boolean useWrapperForExtract;

    public ItemHandlerWrapperContainer(IItemHandlerModifiable baseHandler, IItemHandler wrapperHandler) {
        this(baseHandler, wrapperHandler, false);
    }

    public ItemHandlerWrapperContainer(IItemHandlerModifiable baseHandler, IItemHandler wrapperHandler, boolean useWrapperForExtract) {
        this.baseHandlerModifiable = baseHandler;
        this.wrapperHandler = wrapperHandler;
        this.useWrapperForExtract = useWrapperForExtract;
    }

    public int getSlots() {
        return this.wrapperHandler.getSlots();
    }

    public int getSlotLimit(int slot) {
        return this.wrapperHandler.getSlotLimit(slot);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.wrapperHandler.getStackInSlot(slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.baseHandlerModifiable.setStackInSlot(slot, stack);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.wrapperHandler.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.useWrapperForExtract) {
            return this.wrapperHandler.extractItem(slot, amount, simulate);
        }
        return this.baseHandlerModifiable.extractItem(slot, amount, simulate);
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (this.wrapperHandler instanceof IItemHandlerSelective) {
            return ((IItemHandlerSelective)this.wrapperHandler).isItemValidForSlot(slot, stack);
        }
        return true;
    }

    @Override
    public boolean canExtractFromSlot(int slot) {
        if (this.useWrapperForExtract && this.wrapperHandler instanceof IItemHandlerSelective) {
            return ((IItemHandlerSelective)this.wrapperHandler).canExtractFromSlot(slot);
        }
        return true;
    }

    @Override
    public int getInventoryStackLimit() {
        if (this.wrapperHandler instanceof IItemHandlerSize) {
            return ((IItemHandlerSize)this.wrapperHandler).getInventoryStackLimit();
        }
        return 64;
    }

    @Override
    public int getItemStackLimit(int slot, ItemStack stack) {
        if (this.wrapperHandler instanceof IItemHandlerSize) {
            return ((IItemHandlerSize)this.wrapperHandler).getItemStackLimit(slot, stack);
        }
        return this.getInventoryStackLimit();
    }
}

