/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.slot;

import com.google.common.collect.Lists;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerCraftResult;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SlotItemHandlerCraftResult
extends SlotItemHandlerGeneric {
    private final EntityPlayer player;
    private final InventoryCrafting craftMatrix;
    private final ItemHandlerCraftResult craftResult;
    private int amountCrafted;

    public SlotItemHandlerCraftResult(InventoryCrafting craftMatrix, ItemHandlerCraftResult craftResult, int index, int xPosition, int yPosition, EntityPlayer player) {
        super(craftResult, index, xPosition, yPosition);
        this.player = player;
        this.craftMatrix = craftMatrix;
        this.craftResult = craftResult;
    }

    @Override
    public boolean func_75214_a(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack func_75209_a(int amount) {
        if (this.func_75216_d()) {
            this.amountCrafted += Math.min(amount, this.func_75211_c().func_190916_E());
        }
        return super.func_75209_a(amount);
    }

    protected void func_75210_a(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.func_75208_c(stack);
    }

    protected void func_75208_c(ItemStack stack) {
        if (this.amountCrafted > 0) {
            stack.func_77980_a(this.player.func_130014_f_(), this.player, this.amountCrafted);
            FMLCommonHandler.instance().firePlayerCraftingEvent(this.player, stack, (IInventory)this.craftMatrix);
        }
        this.amountCrafted = 0;
        IRecipe recipe = this.craftResult.getRecipe();
        if (recipe != null && !recipe.func_192399_d()) {
            this.player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{recipe}));
            this.craftResult.setRecipe(null);
        }
    }

    public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
        this.func_75208_c(stack);
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        NonNullList remainingItems = CraftingManager.func_180303_b((InventoryCrafting)this.craftMatrix, (World)player.func_130014_f_());
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stackInSlot = this.craftMatrix.func_70301_a(i);
            ItemStack remainingItemsInSlot = (ItemStack)remainingItems.get(i);
            if (!stackInSlot.func_190926_b()) {
                this.craftMatrix.func_70298_a(i, 1);
                stackInSlot = this.craftMatrix.func_70301_a(i);
            }
            if (remainingItemsInSlot.func_190926_b()) continue;
            if (stackInSlot.func_190926_b()) {
                this.craftMatrix.func_70299_a(i, remainingItemsInSlot);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)remainingItemsInSlot) && ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)remainingItemsInSlot)) {
                remainingItemsInSlot.func_190917_f(stackInSlot.func_190916_E());
                this.craftMatrix.func_70299_a(i, remainingItemsInSlot);
                continue;
            }
            if (this.player.field_71071_by.func_70441_a(remainingItemsInSlot)) continue;
            this.player.func_71019_a(remainingItemsInSlot, false);
        }
        return stack;
    }
}

