/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.ICustomSlotSync;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerTile;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.tileentity.TileEntityMemoryChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ContainerMemoryChest
extends ContainerTile
implements ICustomSlotSync {
    protected TileEntityMemoryChest temc;
    private final boolean[] lockedLast;
    private final NonNullList<ItemStack> templateStacksLast;
    private boolean isPublic;

    public ContainerMemoryChest(EntityPlayer player, TileEntityMemoryChest te) {
        super(player, te);
        this.temc = te;
        this.inventoryNonWrapped = te.getInventory();
        int numSlots = this.inventoryNonWrapped.getSlots();
        this.lockedLast = new boolean[numSlots];
        this.templateStacksLast = NonNullList.func_191197_a((int)numSlots, (Object)ItemStack.field_190927_a);
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, ((Slot)this.field_75151_b.get((int)(this.field_75151_b.size() - 1))).field_75221_f + 32);
    }

    @Override
    protected void addCustomInventorySlots() {
        int posX = 8;
        int posY = 26;
        int slots = this.inventoryNonWrapped.getSlots();
        this.customInventorySlots = new MergeSlotRange(this.field_75151_b.size(), slots);
        int x = posX;
        for (int slot = 0; slot < slots; ++slot) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, slot, x, posY));
            x += 18;
            if (slot % 9 != 8) continue;
            x = posX;
            posY += 18;
        }
    }

    @Override
    protected boolean transferStackToPrioritySlots(EntityPlayer player, int slotNum, boolean reverse) {
        boolean ret = false;
        ItemStackHandlerLockable inv = this.temc.getInventory();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.isSlotLocked(i)) continue;
            ret |= this.transferStackToSlotRange(player, slotNum, new MergeSlotRange(i, 1), reverse);
        }
        return ret;
    }

    @Override
    public void func_75142_b() {
        boolean isPublic = this.temc.isPublic();
        for (int j = 0; j < this.field_75149_d.size(); ++j) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(j);
            if (this.isPublic == isPublic) continue;
            listener.func_71112_a((Container)this, 0, isPublic ? 1 : 0);
        }
        this.isPublic = isPublic;
        this.syncLockableSlots(this.temc.getInventory(), 0, 1, this.lockedLast, this.templateStacksLast);
        super.func_75142_b();
    }

    @Override
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 0: {
                this.temc.setIsPublic(data == 1);
                break;
            }
            case 1: {
                this.temc.getInventory().setSlotLocked(data & 0xFF, (data & 0x8000) != 0);
            }
        }
    }

    @Override
    public void putCustomStack(int typeId, int slotNum, ItemStack stack) {
        this.temc.getInventory().setTemplateStackInSlot(slotNum, stack);
    }
}

