/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.IContainerItem;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModular;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerArmor;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerCraftResult;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotModuleModularItem;
import fi.dy.masa.enderutilities.inventory.wrapper.InventoryCraftingEnderUtilities;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerCraftResult;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerHandyBag
extends ContainerLargeStacks
implements IContainerItem {
    public static final EntityEquipmentSlot[] EQUIPMENT_SLOT_TYPES = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public final InventoryItemModular inventoryItemModular;
    private final InventoryCraftingEnderUtilities craftMatrix;
    private final IItemHandler craftMatrixWrapper;
    private final ItemHandlerCraftResult craftResult = new ItemHandlerCraftResult();
    private ItemStack modularStackLast = ItemStack.field_190927_a;
    private int craftingSlot = 0;

    public ContainerHandyBag(EntityPlayer player, ItemStack containerStack) {
        super(player, new InventoryItemModular(containerStack, player, true, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS));
        this.inventoryItemModular = (InventoryItemModular)this.inventory;
        this.inventoryItemModular.setHostInventory((IItemHandler)this.playerInv);
        this.craftMatrix = new InventoryCraftingEnderUtilities(2, 2, new ItemStackHandlerBasic(4), this.craftResult, player, this);
        this.craftMatrixWrapper = new InvWrapper((IInventory)this.craftMatrix);
        this.inventoryNonWrapped = (InventoryItemModular)this.inventory;
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 174);
    }

    @Override
    protected void addPlayerInventorySlots(int posX, int posY) {
        int i;
        if (this.getBagTier() == 1) {
            posX += 40;
        }
        super.addPlayerInventorySlots(posX, posY);
        int playerArmorStart = this.field_75151_b.size();
        posY = 15;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerArmor(this, (IItemHandler)this.playerInv, i, 39 - i, posX, posY + i * 18));
        }
        this.playerArmorSlots = new MergeSlotRange(playerArmorStart, 4);
        this.addOffhandSlot(posX + 72, 51);
        posY = 15;
        this.craftingSlot = this.field_75151_b.size();
        this.func_75146_a((Slot)new SlotItemHandlerCraftResult(this.craftMatrix, this.craftResult, 0, (posX += 90) + 54, posY + 10, this.player));
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.craftMatrixWrapper, j + i * 2, posX + j * 18, posY + i * 18));
            }
        }
    }

    @Override
    protected void addCustomInventorySlots() {
        int i;
        int customInvStart = this.field_75151_b.size();
        int xOff = 8;
        int yOff = 102;
        if (this.getBagTier() == 1) {
            xOff += 40;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, i2 * 9 + j, xOff + j * 18, yOff + i2 * 18));
            }
        }
        if (this.getBagTier() == 1) {
            int xOffXtra = 8;
            yOff = 102;
            for (i = 0; i < 7; ++i) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 27 + i * 2, xOffXtra + 0, yOff + i * 18));
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 28 + i * 2, xOffXtra + 18, yOff + i * 18));
            }
            xOffXtra = 214;
            for (i = 0; i < 7; ++i) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 41 + i * 2, xOffXtra + 0, yOff + i * 18));
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 42 + i * 2, xOffXtra + 18, yOff + i * 18));
            }
        }
        this.customInventorySlots = new MergeSlotRange(customInvStart, this.field_75151_b.size() - customInvStart);
        xOff += 90;
        yOff = 69;
        int moduleSlots = this.inventoryItemModular.getModuleInventory().getSlots();
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), moduleSlots);
        for (i = 0; i < moduleSlots; ++i) {
            this.func_75146_a((Slot)new SlotModuleModularItem(this.inventoryItemModular.getModuleInventory(), i, xOff + i * 18, yOff, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, this));
        }
    }

    @Override
    public ItemStack getContainerItem() {
        return this.inventoryItemModular.getModularItemStack();
    }

    public void dropCraftingGridContents() {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.craftMatrix.func_70304_b(i);
            if (stack.func_190926_b()) continue;
            this.player.func_71019_a(stack, true);
        }
        this.craftResult.setStackInSlot(0, ItemStack.field_190927_a);
    }

    public int getBagTier() {
        if (!this.inventoryItemModular.getModularItemStack().func_190926_b()) {
            return this.inventoryItemModular.getModularItemStack().func_77960_j() == 1 ? 1 : 0;
        }
        return 0;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.dropCraftingGridContents();
    }

    @Override
    protected void shiftClickSlot(int slotNum, EntityPlayer player) {
        block2: {
            if (slotNum != this.craftingSlot) {
                super.shiftClickSlot(slotNum, player);
                return;
            }
            SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
            if (slot == null || !slot.func_75216_d()) break block2;
            ItemStack stackOrig = slot.func_75211_c().func_77946_l();
            int num = 64;
            while (num-- > 0 && this.transferStackFromSlot(player, slotNum) && InventoryUtils.areItemStacksEqual(stackOrig, slot.func_75211_c())) {
            }
        }
    }

    @Override
    protected void rightClickSlot(int slotNum, EntityPlayer player) {
        if (slotNum != this.craftingSlot) {
            super.rightClickSlot(slotNum, player);
            return;
        }
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackOrig = slot.func_75211_c().func_77946_l();
            int num = stackOrig.func_77976_d() / stackOrig.func_190916_E();
            while (num-- > 0) {
                super.rightClickSlot(slotNum, player);
                if (InventoryUtils.areItemStacksEqual(stackOrig, slot.func_75211_c())) continue;
                break;
            }
        }
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        super.func_184996_a(slotNum, dragType, clickType, player);
        if (!this.isClient && slotNum == this.craftingSlot) {
            this.syncSlotToClient(this.craftingSlot);
            this.syncCursorStackToClient();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected boolean transferStackFromPlayerMainInventory(EntityPlayer player, int slotNum) {
        ItemStack modularStack = this.inventoryItemModular.getModularItemStack();
        if (!modularStack.func_190926_b() && ItemHandyBag.ShiftMode.getEffectiveMode(modularStack) == ItemHandyBag.ShiftMode.INV_HOTBAR) {
            if (this.playerHotbarSlots.contains(slotNum)) {
                return this.transferStackToSlotRange(player, slotNum, this.playerMainSlots, false);
            }
            if (this.playerMainSlots.contains(slotNum)) {
                return this.transferStackToSlotRange(player, slotNum, this.playerHotbarSlots, false);
            }
        }
        return super.transferStackFromPlayerMainInventory(player, slotNum);
    }

    @Override
    public void func_75142_b() {
        ItemStack modularStack;
        if (!this.player.func_130014_f_().field_72995_K && (modularStack = this.inventoryItemModular.getModularItemStack()) != this.modularStackLast) {
            this.inventoryItemModular.readFromContainerItemStack();
            this.modularStackLast = modularStack;
        }
        super.func_75142_b();
    }
}

