/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.container.base.ContainerTileLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.tileentity.TileEntityDrawbridge;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;

public class ContainerDrawbridge
extends ContainerTileLargeStacks {
    private final TileEntityDrawbridge tedb;
    private final boolean advanced;
    private int lengthLast = -1;
    private int delayLast = -1;
    private int rsModeLast = -1;

    public ContainerDrawbridge(EntityPlayer player, TileEntityDrawbridge te) {
        super(player, te.getWrappedInventoryForContainer(player), te);
        this.tedb = te;
        this.advanced = te.isAdvanced();
        this.inventoryNonWrapped = te.getInventoryDrawbridge();
        this.func_75142_b();
        this.reAddSlots();
    }

    private void reAddSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, this.advanced ? 128 : 54);
    }

    @Override
    protected void addCustomInventorySlots() {
        int posX = 17;
        int posY = 42;
        int slots = this.inventory.getSlots();
        this.customInventorySlots = new MergeSlotRange(this.field_75151_b.size(), slots);
        if (this.advanced) {
            int x = posX;
            for (int slot = 0; slot < slots; ++slot) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, slot, x, posY));
                x += 18;
                if (slot % 8 != 7) continue;
                x = posX;
                posY += 18;
            }
        } else {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, 0, 8, 21));
        }
    }

    @Override
    public void func_75142_b() {
        if (this.isClient) {
            return;
        }
        int maxLength = this.tedb.getMaxLength();
        int delay = this.tedb.getDelay();
        int rsMode = this.tedb.getRedstoneModeIntValue();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            if (maxLength != this.lengthLast) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 0, maxLength);
            }
            if (delay != this.delayLast) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 1, delay);
            }
            if (rsMode == this.rsModeLast) continue;
            ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 2, rsMode);
        }
        if (maxLength != this.lengthLast) {
            this.reAddSlots();
        }
        this.lengthLast = maxLength;
        this.delayLast = delay;
        this.rsModeLast = rsMode;
        super.func_75142_b();
    }

    @Override
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        switch (id) {
            case 0: {
                this.tedb.setMaxLength(data);
                this.reAddSlots();
                break;
            }
            case 1: {
                this.tedb.setDelay(data);
                break;
            }
            case 2: {
                this.tedb.setRedstoneMode(data);
            }
        }
    }
}

