/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.container.base.ContainerTileLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerCraftResult;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerFurnaceOutput;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerModule;
import fi.dy.masa.enderutilities.inventory.wrapper.InvWrapperSyncable;
import fi.dy.masa.enderutilities.inventory.wrapper.InventoryCraftingPermissions;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerCraftResult;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperPermissions;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageSyncSlot;
import fi.dy.masa.enderutilities.tileentity.TileEntityCreationStation;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerCreationStation
extends ContainerTileLargeStacks {
    protected final TileEntityCreationStation tecs;
    public int selectionsLast;
    public int fuelProgress;
    public int smeltProgress;
    private int modeMaskLast;
    private int lastInteractedCraftingGrid;
    private final InventoryCraftingPermissions[] craftingInventories;
    private final IItemHandler[] wrappedCraftingInventories;
    private final ItemHandlerCraftResult[] craftResults;
    private final IItemHandler furnaceInventory;
    private SlotRange craftingGridSlotsLeft;
    private SlotRange craftingGridSlotsRight;
    private int craftingOutputSlotLeft = -1;
    private int craftingOutputSlotRight = -1;
    private final NonNullList<ItemStack> recipeStacks = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);

    public ContainerCreationStation(EntityPlayer player, TileEntityCreationStation te) {
        super(player, te.getItemInventory(player), te);
        this.tecs = te;
        this.craftingInventories = new InventoryCraftingPermissions[]{te.getCraftingInventory(0, player, this), te.getCraftingInventory(1, player, this)};
        this.wrappedCraftingInventories = new IItemHandler[]{new InvWrapperSyncable((IInventory)this.craftingInventories[0]), new InvWrapperSyncable((IInventory)this.craftingInventories[1])};
        this.craftResults = new ItemHandlerCraftResult[]{te.getCraftResultInventory(0), te.getCraftResultInventory(1)};
        this.furnaceInventory = this.tecs.getFurnaceInventory();
        this.inventoryNonWrapped = (ItemHandlerWrapperPermissions)this.inventory;
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(40, 174);
    }

    @Override
    protected void addCustomInventorySlots() {
        int j;
        int i;
        int posX = 40;
        int posY = 102;
        this.customInventorySlots = new MergeSlotRange(this.field_75151_b.size(), 27);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, i * 9 + j, posX + j * 18, posY + i * 18));
            }
        }
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 4);
        posX = 216;
        posY = 102;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerModule(this.tecs.getMemoryCardInventory(), i, posX, posY + i * 18, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS));
        }
        this.craftingGridSlotsLeft = new SlotRange(this.field_75151_b.size(), 9);
        posX = 40;
        posY = 33;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.wrappedCraftingInventories[0], j + i * 3, posX + j * 18, posY + i * 18));
            }
        }
        this.craftingOutputSlotLeft = this.field_75151_b.size();
        this.func_75146_a((Slot)new SlotItemHandlerCraftResult(this.craftingInventories[0], this.craftResults[0], 0, 112, 33, this.player));
        this.craftingGridSlotsRight = new SlotRange(this.field_75151_b.size(), 9);
        posX = 148;
        posY = 33;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.wrappedCraftingInventories[1], j + i * 3, posX + j * 18, posY + i * 18));
            }
        }
        this.craftingOutputSlotRight = this.field_75151_b.size();
        this.func_75146_a((Slot)new SlotItemHandlerCraftResult(this.craftingInventories[1], this.craftResults[1], 0, 112, 69, this.player));
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 6, true);
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 0, 8, 8));
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 1, 8, 51));
        this.func_75146_a((Slot)new SlotItemHandlerFurnaceOutput(this.player, this.furnaceInventory, 2, 40, 8));
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 3, 216, 8));
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.furnaceInventory, 4, 216, 51));
        this.func_75146_a((Slot)new SlotItemHandlerFurnaceOutput(this.player, this.furnaceInventory, 5, 184, 8));
        this.craftingInventories[0].func_70296_d();
        this.craftingInventories[1].func_70296_d();
    }

    public SlotRange getCraftingGridSlotRange(int id) {
        return id == 1 ? this.craftingGridSlotsRight : this.craftingGridSlotsLeft;
    }

    public int getLastInteractedCraftingGridId() {
        return this.tecs.lastInteractedCraftingGrid;
    }

    public InventoryCraftingPermissions getCraftingInventory(int gridId) {
        return this.craftingInventories[gridId];
    }

    public ItemStack getStackOnCraftingGrid(int gridId, int slot) {
        return this.wrappedCraftingInventories[gridId].getStackInSlot(slot);
    }

    @Override
    protected int getMaxStackSizeFromSlotAndStack(Slot slot, ItemStack stack) {
        SlotItemHandler slotItemHandler;
        if (slot instanceof SlotItemHandler && ((slotItemHandler = (SlotItemHandler)slot).getItemHandler() == this.inventory || slotItemHandler.getItemHandler() == this.tecs.getFurnaceInventory())) {
            return slotItemHandler.func_178170_b(stack);
        }
        return super.getMaxStackSizeFromSlotAndStack(slot, stack);
    }

    @Override
    protected boolean transferStackFromSlot(EntityPlayer player, int slotNum) {
        if (this.craftingOutputSlotLeft == slotNum || this.craftingOutputSlotRight == slotNum) {
            int invId;
            int n = invId = this.craftingOutputSlotRight == slotNum ? 1 : 0;
            if (!this.tecs.canCraftItems(this.wrappedCraftingInventories[invId], invId)) {
                return false;
            }
            boolean ret = false;
            ItemHandlerWrapperPermissions inv = this.tecs.getItemInventory(player);
            MergeSlotRange range = new MergeSlotRange(inv);
            ItemStack stackSlot = this.func_75139_a(slotNum).func_75211_c();
            ret = !stackSlot.func_190926_b() && InventoryUtils.matchingStackFoundInSlotRange(inv, range, stackSlot, false, false) ? super.transferStackToSlotRange(player, slotNum, range, false) : super.transferStackFromSlot(player, slotNum);
            this.tecs.restockCraftingGrid(this.wrappedCraftingInventories[invId], invId);
            return ret;
        }
        if ((this.craftingGridSlotsLeft.contains(slotNum) || this.craftingGridSlotsRight.contains(slotNum)) && this.transferStackToSlotRange(player, slotNum, this.customInventorySlots, false)) {
            return true;
        }
        return super.transferStackFromSlot(player, slotNum);
    }

    @Override
    protected void shiftClickSlot(int slotNum, EntityPlayer player) {
        block2: {
            if (this.craftingOutputSlotLeft != slotNum && this.craftingOutputSlotRight != slotNum) {
                super.shiftClickSlot(slotNum, player);
                return;
            }
            SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
            if (slot == null || !slot.func_75216_d()) break block2;
            ItemStack stackOrig = slot.func_75211_c().func_77946_l();
            int num = 64;
            while (num-- > 0 && this.transferStackFromSlot(player, slotNum) && InventoryUtils.areItemStacksEqual(stackOrig, slot.func_75211_c())) {
            }
        }
    }

    @Override
    protected void rightClickSlot(int slotNum, EntityPlayer player) {
        if (this.craftingOutputSlotLeft != slotNum && this.craftingOutputSlotRight != slotNum) {
            super.rightClickSlot(slotNum, player);
            return;
        }
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackOrig = slot.func_75211_c().func_77946_l();
            int num = stackOrig.func_77976_d() / stackOrig.func_190916_E();
            while (num-- > 0) {
                super.rightClickSlot(slotNum, player);
                if (InventoryUtils.areItemStacksEqual(stackOrig, slot.func_75211_c())) continue;
                break;
            }
        }
    }

    @Override
    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        if (!this.tecs.isInventoryAccessible(player) && (this.craftingGridSlotsLeft.contains(slotNum) || this.craftingGridSlotsRight.contains(slotNum))) {
            return ItemStack.field_190927_a;
        }
        if (this.craftingGridSlotsLeft.contains(slotNum) || this.craftingOutputSlotLeft == slotNum) {
            this.tecs.lastInteractedCraftingGrid = 0;
        } else if (this.craftingGridSlotsRight.contains(slotNum) || this.craftingOutputSlotRight == slotNum) {
            this.tecs.lastInteractedCraftingGrid = 1;
        }
        if (this.craftingOutputSlotLeft == slotNum || this.craftingOutputSlotRight == slotNum) {
            int invId;
            int n = invId = this.craftingOutputSlotRight == slotNum ? 1 : 0;
            if (!this.tecs.canCraftItems(this.wrappedCraftingInventories[invId], invId)) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = super.func_184996_a(slotNum, dragType, clickType, player);
            if (!this.isClient) {
                this.tecs.restockCraftingGrid(this.wrappedCraftingInventories[invId], invId);
                this.syncSlotToClient(slotNum);
                this.syncCursorStackToClient();
            }
            return stack;
        }
        super.func_184996_a(slotNum, dragType, clickType, player);
        if (((MergeSlotRange)this.mergeSlotRangesPlayerToExt.get(0)).contains(slotNum)) {
            this.craftingInventories[0].func_70296_d();
            this.craftingInventories[1].func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isInventoryAccessible() {
        return this.tecs.isInventoryAccessible(this.player);
    }

    private void syncRecipeStacks() {
        int start = this.field_75151_b.size();
        for (int slot = 0; slot < this.recipeStacks.size(); ++slot) {
            ItemStack currentStack = (ItemStack)this.tecs.getRecipeItems(slot / 9).get(slot % 9);
            ItemStack prevStack = (ItemStack)this.recipeStacks.get(slot);
            if (ItemStack.func_77989_b((ItemStack)prevStack, (ItemStack)currentStack)) continue;
            prevStack = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
            this.recipeStacks.set(slot, (Object)prevStack);
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
                if (!(listener instanceof EntityPlayerMP)) continue;
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncSlot(this.field_75152_c, start + slot, prevStack), (EntityPlayerMP)listener);
            }
        }
    }

    @Override
    public void syncStackInSlot(int slotId, ItemStack stack) {
        int size = this.field_75151_b.size();
        if (slotId >= size) {
            this.recipeStacks.set(slotId - size, (Object)stack);
        } else {
            super.syncStackInSlot(slotId, stack);
        }
    }

    public ItemStack getRecipeItem(int invId, int slot) {
        return (ItemStack)this.recipeStacks.get(invId * 9 + slot);
    }

    public int getCraftingResultSlotNum(int gridId) {
        return gridId == 1 ? this.craftingOutputSlotRight : this.craftingOutputSlotLeft;
    }

    @Override
    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        int modeMask = this.tecs.getModeMask();
        int selection = this.tecs.getQuickMode() << 2 | this.tecs.getSelectedModuleSlot();
        int smeltProgress = this.tecs.getSmeltProgressScaled(1, 100) << 8 | this.tecs.getSmeltProgressScaled(0, 100);
        int fuelProgress = this.tecs.getBurnTimeRemainingScaled(1, 100) << 8 | this.tecs.getBurnTimeRemainingScaled(0, 100);
        listener.func_71112_a((Container)this, 0, modeMask);
        listener.func_71112_a((Container)this, 1, selection);
        listener.func_71112_a((Container)this, 2, fuelProgress);
        listener.func_71112_a((Container)this, 3, smeltProgress);
        listener.func_71112_a((Container)this, 4, this.tecs.lastInteractedCraftingGrid);
        this.func_75142_b();
    }

    @Override
    public void func_75142_b() {
        if (this.tecs.func_145831_w().field_72995_K) {
            return;
        }
        super.func_75142_b();
        this.syncRecipeStacks();
        int modeMask = this.tecs.getModeMask();
        int selection = this.tecs.getQuickMode() << 2 | this.tecs.getSelectedModuleSlot();
        int smeltProgress = this.tecs.getSmeltProgressScaled(1, 100) << 8 | this.tecs.getSmeltProgressScaled(0, 100);
        int fuelProgress = this.tecs.getBurnTimeRemainingScaled(1, 100) << 8 | this.tecs.getBurnTimeRemainingScaled(0, 100);
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
            if (this.modeMaskLast != modeMask) {
                listener.func_71112_a((Container)this, 0, modeMask);
            }
            if (this.selectionsLast != selection) {
                listener.func_71112_a((Container)this, 1, selection);
            }
            if (this.fuelProgress != fuelProgress) {
                listener.func_71112_a((Container)this, 2, fuelProgress);
            }
            if (this.smeltProgress != smeltProgress) {
                listener.func_71112_a((Container)this, 3, smeltProgress);
            }
            if (this.lastInteractedCraftingGrid == this.tecs.lastInteractedCraftingGrid) continue;
            listener.func_71112_a((Container)this, 4, this.tecs.lastInteractedCraftingGrid);
        }
        this.modeMaskLast = modeMask;
        this.selectionsLast = selection;
        this.fuelProgress = fuelProgress;
        this.smeltProgress = smeltProgress;
        this.lastInteractedCraftingGrid = this.tecs.lastInteractedCraftingGrid;
    }

    @Override
    public void func_75137_b(int var, int val) {
        super.func_75137_b(var, val);
        switch (var) {
            case 0: {
                this.tecs.setModeMask(val);
                break;
            }
            case 1: {
                this.tecs.setSelectedModuleSlot(val & 3);
                this.tecs.setQuickMode(val >> 2 & 7);
                this.tecs.inventoryChanged(1, 0);
                break;
            }
            case 2: {
                this.fuelProgress = val;
                break;
            }
            case 3: {
                this.smeltProgress = val;
                break;
            }
            case 4: {
                this.tecs.lastInteractedCraftingGrid = val;
                break;
            }
        }
    }
}

