/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.ICustomSlotSync;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerTileLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.tileentity.TileEntityASU;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ContainerASU
extends ContainerTileLargeStacks
implements ICustomSlotSync {
    protected final TileEntityASU teasu;
    private final boolean[] lockedLast = new boolean[27];
    private final NonNullList<ItemStack> templateStacksLast = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int stackLimitLast = -1;
    private int slotCountLast = -1;

    public ContainerASU(EntityPlayer player, TileEntityASU te) {
        super(player, te.getWrappedInventoryForContainer(player), te);
        this.teasu = te;
        this.inventoryNonWrapped = te.getInventoryASU();
        this.reAddSlots();
    }

    private void reAddSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 112);
    }

    @Override
    protected void addCustomInventorySlots() {
        int posX = 8;
        int posY = 43;
        int slots = this.inventory.getSlots();
        this.customInventorySlots = new MergeSlotRange(this.field_75151_b.size(), slots);
        int x = posX;
        for (int slot = 0; slot < slots; ++slot) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, slot, x, posY));
            x += 18;
            if (slot % 9 != 8) continue;
            x = posX;
            posY += 18;
        }
    }

    @Override
    public void func_75142_b() {
        int stackLimit = this.inventoryNonWrapped.getInventoryStackLimit();
        int slotCount = this.inventory.getSlots();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            if (stackLimit != this.stackLimitLast) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 0, stackLimit & 0xFFFF);
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 1, stackLimit >>> 16);
            }
            if (slotCount == this.slotCountLast) continue;
            ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 3, slotCount);
        }
        if (slotCount != this.slotCountLast) {
            this.reAddSlots();
        }
        this.stackLimitLast = stackLimit;
        this.slotCountLast = slotCount;
        this.syncLockableSlots(this.teasu.getInventoryASU(), 0, 2, this.lockedLast, this.templateStacksLast);
        super.func_75142_b();
    }

    @Override
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        switch (id) {
            case 0: {
                this.stackLimitLast = data;
                break;
            }
            case 1: {
                this.teasu.setStackLimit(data << 16 | this.stackLimitLast);
                break;
            }
            case 2: {
                this.teasu.getInventoryASU().setSlotLocked(data & 0xFF, (data & 0x8000) != 0);
                break;
            }
            case 3: {
                this.teasu.setInvSize(data);
                this.reAddSlots();
            }
        }
    }

    @Override
    public void putCustomStack(int typeId, int slotNum, ItemStack stack) {
        this.teasu.getInventoryASU().setTemplateStackInSlot(slotNum, stack);
    }
}

