/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.BitSet;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ItemStackHandlerLockable
extends ItemStackHandlerTileEntity {
    private final NonNullList<ItemStack> templateStacks;
    private final BitSet locked;

    public ItemStackHandlerLockable(int inventoryId, int invSize, int stackLimit, boolean allowCustomStackSizes, String tagName, TileEntityEnderUtilitiesInventory te) {
        super(inventoryId, invSize, stackLimit, allowCustomStackSizes, tagName, te);
        this.templateStacks = NonNullList.func_191197_a((int)invSize, (Object)ItemStack.field_190927_a);
        this.locked = new BitSet(invSize);
    }

    public boolean isSlotLocked(int slot) {
        return this.locked.get(slot);
    }

    public boolean toggleSlotLocked(int slot) {
        boolean isLocked = !this.locked.get(slot);
        this.setSlotLocked(slot, isLocked);
        return isLocked;
    }

    public void setSlotLocked(int slot, boolean isLocked) {
        if (isLocked) {
            this.locked.set(slot);
        } else {
            this.locked.clear(slot);
        }
        this.onContentsChanged(slot);
    }

    public ItemStack getTemplateStackInSlot(int slot) {
        return (ItemStack)this.templateStacks.get(slot);
    }

    public void setTemplateStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            this.templateStacks.set(slot, (Object)ItemStack.field_190927_a);
        } else {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            this.templateStacks.set(slot, (Object)stack);
        }
        this.onContentsChanged(slot);
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return !this.locked.get(slot) || InventoryUtils.areItemStacksEqual((ItemStack)this.templateStacks.get(slot), stack);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt = NBTUtils.writeItemsToTag(nbt, this.templateStacks, "TemplateItems", false);
        nbt.func_74773_a("LockedSlots", this.locked.toByteArray());
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        NBTUtils.readStoredItemsFromTag(nbt, this.templateStacks, "TemplateItems");
        this.locked.clear();
        this.locked.or(BitSet.valueOf(nbt.func_74770_j("LockedSlots")));
    }
}

