/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import com.google.common.collect.Ordering;
import fi.dy.masa.enderutilities.gui.client.base.GuiContainerLargeStacks;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonHoverText;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonIcon;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonStateCallback;
import fi.dy.masa.enderutilities.gui.client.button.IButtonStateCallback;
import fi.dy.masa.enderutilities.inventory.container.ContainerHandyBag;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModular;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.registry.ModRegistry;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiHandyBag
extends GuiContainerLargeStacks
implements IButtonStateCallback {
    public static final int BTN_ID_FIRST_SELECT_MODULE = 0;
    public static final int BTN_ID_FIRST_MOVE_ITEMS = 4;
    public static final int BTN_ID_FIRST_SORT = 10;
    public static final int BTN_ID_FIRST_BLOCK = 14;
    public static final int BTN_ID_FIRST_MODES = 17;
    public static final int BTN_ID_BAUBLES = 100;
    private static final String[] BUTTON_STRINGS = new String[]{"enderutilities.gui.label.moveallitemsexcepthotbar", "enderutilities.gui.label.movematchingitemsexcepthotbar", "enderutilities.gui.label.leaveonefilledstack", "enderutilities.gui.label.fillstacks", "enderutilities.gui.label.movematchingitems", "enderutilities.gui.label.moveallitems", "enderutilities.gui.label.sortitems"};
    private final ContainerHandyBag containerHB;
    private final InventoryItemModular invModular;
    private final int invSize;
    private final int numModuleSlots;
    private final int bagTier;
    private final int offsetXTier;
    private float oldMouseX;
    private float oldMouseY;
    private int firstModuleSlotX;
    private int firstModuleSlotY;
    private boolean hasActivePotionEffects;
    private int[] lastPos = new int[2];
    private final boolean baublesLoaded;
    public static final ResourceLocation RESOURCES_BAUBLES_BUTTON = new ResourceLocation("baubles".toLowerCase(), "textures/gui/expanded_inventory.png");

    public GuiHandyBag(ContainerHandyBag container) {
        super(container, container.getBagTier() == 1 ? 256 : 176, 256, "gui.container.handybag." + container.getBagTier());
        this.containerHB = container;
        this.invModular = container.inventoryItemModular;
        this.invSize = this.invModular.getSlots();
        this.numModuleSlots = this.invModular.getModuleInventory().getSlots();
        this.bagTier = this.containerHB.getBagTier();
        this.offsetXTier = this.bagTier == 1 ? 40 : 0;
        this.baublesLoaded = ModRegistry.isModLoadedBaubles();
        this.scaledStackSizeTextInventories.add(this.invModular);
    }

    private void updatePositions() {
        this.firstModuleSlotX = this.field_147003_i + this.containerHB.func_75139_a((int)0).field_75223_e + 90;
        this.firstModuleSlotY = this.field_147009_r + this.containerHB.func_75139_a((int)0).field_75221_f - 33;
        this.createButtons();
        this.lastPos[0] = this.field_147003_i;
        this.lastPos[1] = this.field_147009_r;
    }

    private boolean needsPositionUpdate() {
        return this.lastPos[0] != this.field_147003_i || this.lastPos[1] != this.field_147009_r;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.updatePositions();
        this.updateActivePotionEffects();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateActivePotionEffects();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        if (this.needsPositionUpdate()) {
            this.updatePositions();
        }
        if (this.hasActivePotionEffects) {
            this.drawActivePotionEffects();
        }
        this.drawTooltips(mouseX, mouseY);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        ItemStack modularStack;
        int index;
        int i;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.bindTexture(this.guiTextureWidgets);
        if (!this.invModular.isAccessibleBy((Entity)this.player)) {
            for (i = 0; i < this.invSize; ++i) {
                Slot slot = this.containerHB.func_75139_a(i);
                this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 102, 0, 18, 18);
            }
        }
        if (!this.invModular.getModuleInventory().isAccessibleBy((Entity)this.player)) {
            for (i = 0; i < this.numModuleSlots; ++i) {
                this.func_73729_b(this.firstModuleSlotX - 1 + i * 18, this.firstModuleSlotY - 1, 102, 0, 18, 18);
            }
        }
        if ((index = this.invModular.getSelectedModuleIndex()) >= 0) {
            this.func_73729_b(this.firstModuleSlotX - 1 + index * 18, this.firstModuleSlotY - 1, 102, 18, 18, 18);
            this.func_73729_b(this.firstModuleSlotX + 3 + index * 18, this.firstModuleSlotY + 18, 120, 0, 10, 10);
        }
        for (int i2 = 0; i2 < this.numModuleSlots; ++i2) {
            if (!this.invModular.getModuleInventory().getStackInSlot(i2).func_190926_b()) continue;
            this.func_73729_b(this.firstModuleSlotX + i2 * 18, this.firstModuleSlotY, 240, 80, 16, 16);
        }
        if (this.containerHB.getBagTier() == 1) {
            int x = (this.field_146294_l - this.field_146999_f) / 2;
            int y = (this.field_146295_m - this.field_147000_g) / 2;
            int[] xPos = new int[]{114, 20, 226};
            for (int i3 = 0; i3 < 3; ++i3) {
                if (!this.isMaskActiveForSection(i3, "LockMask")) continue;
                this.func_73729_b(x + xPos[i3], y + 90, 120, 24, 10, 10);
            }
        }
        if (!(modularStack = this.containerHB.inventoryItemModular.getModularItemStack()).func_190926_b() && ItemHandyBag.ShiftMode.getEffectiveMode(modularStack) == ItemHandyBag.ShiftMode.TO_BAG) {
            int x = this.field_147003_i + this.offsetXTier + 64;
            this.func_73729_b(x, this.field_147009_r + 157, 154, 0, 12, 12);
        }
        int xOff = this.field_147003_i + 51 + this.offsetXTier;
        GuiInventory.func_147046_a((int)xOff, (int)(this.field_147009_r + 82), (int)30, (float)((float)xOff - this.oldMouseX), (float)((float)(this.field_147009_r + 25) - this.oldMouseY), (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int xOff = this.offsetXTier;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), xOff + 97, 5, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.memorycards", (Object[])new Object[0]), xOff + 99, 59, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.handybag", (Object[])new Object[0]), xOff + 8, 5, 0x404040);
    }

    protected void createButtons() {
        this.field_146292_n.clear();
        int numModules = this.invModular.getModuleInventory().getSlots();
        for (int i = 0; i < numModules; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(0 + i, this.firstModuleSlotX + 4 + i * 18, this.firstModuleSlotY + 19, 8, 8, 0, 0, this.guiTextureWidgets, 8, 0));
        }
        int x = this.field_147003_i + this.containerHB.func_75139_a((int)0).field_75223_e + 2;
        int y = this.field_147009_r + this.containerHB.func_75139_a((int)0).field_75221_f + 55;
        this.field_146292_n.add(new GuiButtonHoverText(4, x + 0, y + 0, 12, 12, 24, 0, this.guiTextureWidgets, 12, 0, "enderutilities.gui.label.moveallitemsexcepthotbar", "enderutilities.gui.label.holdshifttoincludehotbar"));
        this.field_146292_n.add(new GuiButtonHoverText(5, x + 18, y + 0, 12, 12, 24, 12, this.guiTextureWidgets, 12, 0, "enderutilities.gui.label.movematchingitemsexcepthotbar", "enderutilities.gui.label.holdshifttoincludehotbar"));
        int[] xOff = new int[]{36, 108, 126, 144};
        for (int i = 2; i < 6; ++i) {
            this.field_146292_n.add(new GuiButtonHoverText(4 + i, x + xOff[i - 2], y, 12, 12, 24, i * 12, this.guiTextureWidgets, 12, 0, BUTTON_STRINGS[i]));
        }
        y = this.field_147009_r + this.containerHB.func_75139_a((int)0).field_75221_f - 11;
        this.field_146292_n.add(new GuiButtonStateCallback(17, x - 1, y, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 48, "enderutilities.gui.label.bag.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 0, "enderutilities.gui.label.bag.enabled")));
        this.field_146292_n.add(new GuiButtonStateCallback(18, x + 23, y, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.pickupmode.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 56, "enderutilities.gui.label.pickupmode.matching"), GuiButtonStateCallback.ButtonState.createTranslate(0, 64, "enderutilities.gui.label.pickupmode.all")));
        this.field_146292_n.add(new GuiButtonStateCallback(19, x + 11, y, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.restockmode.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 80, "enderutilities.gui.label.restockmode.hotbar"), GuiButtonStateCallback.ButtonState.createTranslate(0, 72, "enderutilities.gui.label.restockmode.all")));
        this.field_146292_n.add(new GuiButtonStateCallback(23, x + 35, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 16, ItemHandyBag.ShiftMode.TO_BAG.getUnlocName()), GuiButtonStateCallback.ButtonState.createTranslate(0, 96, ItemHandyBag.ShiftMode.INV_HOTBAR.getUnlocName()), GuiButtonStateCallback.ButtonState.createTranslate(0, 104, ItemHandyBag.ShiftMode.DOUBLE_TAP.getUnlocName())));
        if (this.bagTier == 0) {
            this.field_146292_n.add(new GuiButtonHoverText(10, x + 74, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(13, x + 74, y + 70, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.sortitems.player"));
            this.field_146292_n.add(new GuiButtonStateCallback(20, x + 62, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.updateitems.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 88, "enderutilities.gui.label.updateitems.enabled")));
        } else {
            this.field_146292_n.add(new GuiButtonHoverText(11, x - 17, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(10, x + 53, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(12, x + 165, y + 0, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, BUTTON_STRINGS[6]));
            this.field_146292_n.add(new GuiButtonHoverText(13, x + 74, y + 70, 8, 8, 0, 24, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.sortitems.player"));
            this.field_146292_n.add(new GuiButtonStateCallback(15, x - 29, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 0, "enderutilities.gui.label.blockquickactions.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.blockquickactions.enabled")));
            this.field_146292_n.add(new GuiButtonStateCallback(14, x + 65, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 0, "enderutilities.gui.label.blockquickactions.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.blockquickactions.enabled")));
            this.field_146292_n.add(new GuiButtonStateCallback(16, x + 177, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 0, "enderutilities.gui.label.blockquickactions.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.blockquickactions.enabled")));
            this.field_146292_n.add(new GuiButtonStateCallback(21, x - 41, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.updateitems.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 88, "enderutilities.gui.label.updateitems.enabled")));
            this.field_146292_n.add(new GuiButtonStateCallback(20, x + 77, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.updateitems.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 88, "enderutilities.gui.label.updateitems.enabled")));
            this.field_146292_n.add(new GuiButtonStateCallback(22, x + 189, y + 0, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.updateitems.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 88, "enderutilities.gui.label.updateitems.enabled")));
        }
        if (this.baublesLoaded) {
            this.field_146292_n.add(new GuiButtonHoverText(100, this.field_147003_i + 68 + this.offsetXTier, this.field_147009_r + 15, 10, 10, 190, 48, RESOURCES_BAUBLES_BUTTON, 10, 0, "Baubles"));
        }
    }

    @Override
    protected void actionPerformedWithButton(GuiButton button, int mouseButton) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k >= 0 && button.field_146127_k < 0 + this.numModuleSlots) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 0, button.field_146127_k - 0));
        } else if (button.field_146127_k >= 4 && button.field_146127_k <= 9) {
            int value = button.field_146127_k - 4;
            if (GuiScreen.func_146272_n()) {
                value |= 0x8000;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 1, value));
        } else if (button.field_146127_k >= 10 && button.field_146127_k < 14) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 2, button.field_146127_k - 10));
        } else if (button.field_146127_k >= 14 && button.field_146127_k < 17) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 3, button.field_146127_k - 14));
        } else if (button.field_146127_k >= 17 && button.field_146127_k < 20) {
            int data = button.field_146127_k - 17;
            if (mouseButton == 1) {
                data |= 0x8000;
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 5, data));
        } else if (button.field_146127_k >= 20 && button.field_146127_k <= 22) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 4, button.field_146127_k - 20));
        } else if (button.field_146127_k == 23) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 6, mouseButton));
        } else if (button.field_146127_k == 100 && this.baublesLoaded) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 100, 0));
        }
    }

    protected void updateActivePotionEffects() {
        boolean hasVisibleEffect = false;
        for (PotionEffect potioneffect : this.field_146297_k.field_71439_g.func_70651_bq()) {
            Potion potion = potioneffect.func_188419_a();
            if (!potion.shouldRender(potioneffect)) continue;
            hasVisibleEffect = true;
            break;
        }
        if (!this.field_146297_k.field_71439_g.func_70651_bq().isEmpty() && hasVisibleEffect) {
            this.field_147003_i = MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.PotionShiftEvent((GuiScreen)this)) ? (this.field_146294_l - this.field_146999_f) / 2 : 160 + (this.field_146294_l - this.field_146999_f - 200) / 2;
            this.hasActivePotionEffects = true;
        } else {
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.hasActivePotionEffects = false;
        }
    }

    private void drawActivePotionEffects() {
        int x = this.field_147003_i - 124;
        int y = this.field_147009_r;
        Collection collection = this.field_146297_k.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            int entryHeight = 33;
            if (collection.size() > 5) {
                entryHeight = 132 / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : Ordering.natural().sortedCopy((Iterable)collection)) {
                Potion potion = potioneffect.func_188419_a();
                if (!potion.shouldRender(potioneffect)) continue;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
                this.func_73729_b(x, y, 0, 166, 140, 32);
                if (potion.func_76400_d()) {
                    int i1 = potion.func_76392_e();
                    this.func_73729_b(x + 6, y + 7, 0 + i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                }
                potion.renderInventoryEffect(potioneffect, (Gui)this, x, y, this.field_73735_i);
                if (!potion.shouldRenderInvText(potioneffect)) {
                    y += entryHeight;
                    continue;
                }
                String s1 = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                int amp = potioneffect.func_76458_c();
                if (amp >= 1 && amp <= 3) {
                    s1 = s1 + " " + I18n.func_135052_a((String)("enchantment.level." + (amp + 1)), (Object[])new Object[0]);
                }
                this.field_146289_q.func_175063_a(s1, (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
                String s = Potion.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                this.field_146289_q.func_175063_a(s, (float)(x + 10 + 18), (float)(y + 6 + 10), 0x7F7F7F);
                y += entryHeight;
            }
        }
    }

    @Override
    public int getButtonStateIndex(int callbackId) {
        ItemStack stack = this.containerHB.getContainerItem();
        if (!stack.func_190926_b()) {
            if (callbackId == 17) {
                return NBTUtils.getBoolean(stack, "HandyBag", "DisableOpen") ? 0 : 1;
            }
            if (callbackId == 18) {
                ItemHandyBag.PickupMode mode = ItemHandyBag.PickupMode.fromStack(stack);
                if (mode == ItemHandyBag.PickupMode.ALL) {
                    return 2;
                }
                if (mode == ItemHandyBag.PickupMode.MATCHING) {
                    return 1;
                }
                return 0;
            }
            if (callbackId == 19) {
                ItemHandyBag.RestockMode mode = ItemHandyBag.RestockMode.fromStack(stack);
                if (mode == ItemHandyBag.RestockMode.ALL) {
                    return 2;
                }
                if (mode == ItemHandyBag.RestockMode.HOTBAR) {
                    return 1;
                }
                return 0;
            }
            if (callbackId >= 14 && callbackId <= 16) {
                return this.isMaskActiveForSection(callbackId - 14, "LockMask") ? 1 : 0;
            }
            if (callbackId >= 20 && callbackId <= 22) {
                return this.isMaskActiveForSection(callbackId - 20, "UpdateMask") ? 1 : 0;
            }
            if (callbackId == 23) {
                return MathHelper.func_76125_a((int)(NBTUtils.getByte(stack, "HandyBag", "ShiftMode") & 3), (int)0, (int)2);
            }
        }
        return 0;
    }

    @Override
    public boolean isButtonEnabled(int callbackId) {
        return true;
    }

    private boolean isMaskActiveForSection(int section, String tagName) {
        ItemStack stack;
        int selected = this.invModular.getSelectedModuleIndex();
        if (selected >= 0 && section >= 0 && section <= 2 && !(stack = this.invModular.getModuleInventory().getStackInSlot(selected)).func_190926_b()) {
            long[] masks = new long[]{0x1FFFFFFL, 2198889037824L, 36026597995708416L};
            long lockMask = NBTUtils.getLong(stack, "HandyBag", tagName);
            if ((lockMask & masks[section]) == masks[section]) {
                return true;
            }
        }
        return false;
    }
}

