/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.gui.client.base.GuiContainerLargeStacks;
import fi.dy.masa.enderutilities.gui.client.base.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonStateCallback;
import fi.dy.masa.enderutilities.gui.client.button.IButtonStateCallback;
import fi.dy.masa.enderutilities.inventory.container.ContainerBarrel;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.tileentity.TileEntityBarrel;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiBarrel
extends GuiContainerLargeStacks
implements IButtonStateCallback {
    private final TileEntityBarrel tebarrel;
    private final IItemHandler upgradeInv;

    public GuiBarrel(ContainerBarrel container, TileEntityBarrel te) {
        super(container, 176, 175, "gui.container.barrel");
        this.tebarrel = te;
        this.infoArea = new GuiEnderUtilities.InfoArea(160, 17, 11, 11, "enderutilities.gui.infoarea.barrel", Configs.barrelCapacityUpgradeStacksPer);
        this.upgradeInv = container.getUpgradeInventory();
        this.scaledStackSizeTextInventories.add(container.inventory);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.barrel", (Object[])new Object[0]), 8, 5, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, 80, 0x404040);
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        super.func_146976_a(gameTicks, mouseX, mouseY);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = 0; i < this.upgradeInv.getSlots(); ++i) {
            if (!this.upgradeInv.getStackInSlot(i).func_190926_b()) continue;
            this.func_73729_b(x + 44 + i * 18, y + 59, 176, i * 16, 16, 16);
        }
        if (this.tebarrel.isCreative()) {
            this.bindTexture(this.guiTextureWidgets);
            this.func_73729_b(x + 161, y + 5, 120, 24, 10, 10);
        }
        this.drawLockedSlotBackgrounds(this.tebarrel.getInventoryBarrel());
        this.drawTemplateStacks(this.tebarrel.getInventoryBarrel());
    }

    protected void createButtons() {
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButtonStateCallback(1, x + 162, y + 6, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.msu.creative.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 112, "enderutilities.gui.label.msu.creative.enabled")));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1 && this.player.field_71075_bZ.field_75098_d) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(this.tebarrel.func_145831_w().field_73011_w.getDimension(), this.tebarrel.func_174877_v(), 0, 1, 0));
        }
    }

    @Override
    public int getButtonStateIndex(int callbackId) {
        if (callbackId == 1) {
            return this.tebarrel.isCreative() ? 1 : 0;
        }
        return 0;
    }

    @Override
    public boolean isButtonEnabled(int callbackId) {
        return true;
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiBarrel && event.getEntityPlayer() != null && event.getEntityPlayer().field_71070_bA instanceof ContainerBarrel) {
            ContainerBarrel container = (ContainerBarrel)event.getEntityPlayer().field_71070_bA;
            GuiBarrel gui = (GuiBarrel)Minecraft.func_71410_x().field_71462_r;
            Slot slot = gui.getSlotUnderMouse();
            if (slot != null && slot.func_75216_d() && container.getCustomInventorySlotRange().contains(slot.field_75222_d)) {
                String size = EUStringUtils.formatNumberWithKSeparators(slot.func_75211_c().func_190916_E());
                event.getToolTip().add(size + " " + I18n.func_135052_a((String)"enderutilities.tooltip.item.items", (Object[])new Object[0]));
            }
        }
    }
}

