/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.TileUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFallingBlockEU
extends Entity {
    private IBlockState blockState;
    private int fallTime;
    private boolean shouldDropItem = true;
    private boolean dropAsItemOnPlacementFail;
    private boolean canSetAsBlock = true;
    private boolean hurtEntities;
    private boolean canBePushed;
    private int fallHurtMax = 40;
    private float fallHurtAmount = 2.0f;
    private NBTTagCompound tileEntityData;
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(EntityFallingBlockEU.class, (DataSerializer)DataSerializers.field_187200_j);
    protected static final DataParameter<Optional<IBlockState>> BLOCK_STATE = EntityDataManager.func_187226_a(EntityFallingBlockEU.class, (DataSerializer)DataSerializers.field_187197_g);

    public EntityFallingBlockEU(World worldIn) {
        super(worldIn);
        this.setCanBePushed(true);
        this.func_70105_a(0.98f, 0.98f);
        this.dropAsItemOnPlacementFail = Configs.fallingBlockDropsAsItemOnPlacementFail;
    }

    public static EntityFallingBlockEU convertBlockToEntity(World worldIn, BlockPos pos) {
        EntityFallingBlockEU entity = new EntityFallingBlockEU(worldIn);
        entity.setBlockState(worldIn.func_180495_p(pos).func_185899_b((IBlockAccess)worldIn, pos));
        entity.setOrigin(new BlockPos((Vec3i)pos));
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            entity.tileEntityData = te.func_189515_b(new NBTTagCompound());
        }
        entity.field_70156_m = true;
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (float)pos.func_177956_o() + (1.0f - entity.field_70131_O) / 2.0f, (double)pos.func_177952_p() + 0.5);
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        entity.field_70169_q = entity.field_70165_t;
        entity.field_70167_r = entity.field_70163_u;
        entity.field_70166_s = entity.field_70161_v;
        BlockUtils.setBlockToAirWithoutSpillingContents(worldIn, pos);
        return entity;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(BLOCK_STATE, (Object)Optional.absent());
    }

    private void setOrigin(BlockPos pos) {
        this.func_184212_Q().func_187227_b(ORIGIN, (Object)pos);
    }

    public void setCanBePushed(boolean canBePushed) {
        this.canBePushed = canBePushed;
    }

    private void setBlockState(IBlockState state) {
        this.blockState = state;
        this.func_184212_Q().func_187227_b(BLOCK_STATE, (Object)Optional.of((Object)state));
    }

    @Nullable
    public IBlockState getBlockState() {
        return (IBlockState)((Optional)this.func_184212_Q().func_187225_a(BLOCK_STATE)).orNull();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BLOCK_STATE.equals(key)) {
            this.blockState = this.getBlockState();
        }
        super.func_184206_a(key);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return this.canBePushed;
    }

    public void func_70071_h_() {
        if (this.blockState == null) {
            return;
        }
        if (this.blockState.func_185904_a() == Material.field_151579_a) {
            this.func_70106_y();
            return;
        }
        BlockPos pos = new BlockPos((Entity)this);
        World world = this.func_130014_f_();
        Block block = this.blockState.func_177230_c();
        this.updateMovement();
        if (world.field_72995_K) {
            return;
        }
        pos = new BlockPos((Entity)this);
        if (this.field_70122_E) {
            IBlockState iblockstate = world.func_180495_p(pos);
            BlockPos posBelow = new BlockPos(this.field_70165_t, this.field_70163_u - 0.01, this.field_70161_v);
            if (world.func_175623_d(posBelow) && BlockFalling.func_185759_i((IBlockState)world.func_180495_p(posBelow))) {
                this.field_70122_E = false;
                return;
            }
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
            if (iblockstate.func_177230_c() != Blocks.field_180384_M && this.canSetAsBlock) {
                if (world.func_190527_a(block, pos, true, EnumFacing.UP, null) && !BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(pos.func_177977_b())) && this.field_70170_p.func_180501_a(pos, this.blockState, 3)) {
                    if (block instanceof BlockFalling) {
                        ((BlockFalling)block).func_176502_a_(world, pos, this.blockState, iblockstate);
                    }
                    if (this.tileEntityData != null && this.blockState.func_177230_c().hasTileEntity(this.blockState)) {
                        TileUtils.createAndAddTileEntity(world, pos, this.tileEntityData);
                    }
                    this.func_70106_y();
                } else if (this.dropAsItemOnPlacementFail) {
                    if (this.shouldDropItem && world.func_82736_K().func_82766_b("doEntityDrops")) {
                        ItemStack stack = new ItemStack(block, 1, block.func_180651_a(this.blockState));
                        if (this.tileEntityData != null) {
                            NBTUtils.getRootCompoundTag(stack, true).func_74782_a("BlockEntityTag", (NBTBase)this.tileEntityData);
                        }
                        this.func_70099_a(stack, 0.0f);
                    }
                    this.func_70106_y();
                }
            }
        } else if (pos.func_177956_o() < -64) {
            this.func_70106_y();
        }
    }

    private void updateMovement() {
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.04;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i;
        Block block = this.blockState.func_177230_c();
        if (this.hurtEntities && (i = MathHelper.func_76123_f((float)(distance - 1.0f))) > 0) {
            boolean isAnvil = block == Blocks.field_150467_bQ;
            ArrayList list = Lists.newArrayList((Iterable)this.func_130014_f_().func_72839_b((Entity)this, this.func_174813_aQ()));
            DamageSource damageSource = isAnvil ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : list) {
                entity.func_70097_a(damageSource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * this.fallHurtAmount)), this.fallHurtMax));
            }
            if (isAnvil && (double)this.field_70146_Z.nextFloat() < 0.05 + (double)i * 0.05) {
                int j = (Integer)this.blockState.func_177229_b((IProperty)BlockAnvil.field_176505_b) + 1;
                if (j > 2) {
                    this.canSetAsBlock = false;
                } else {
                    this.blockState = this.blockState.func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(j));
                }
            }
        }
    }

    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        if (entity instanceof EntityMinecart) {
            BlockPos pos = new BlockPos((Entity)this);
            for (BlockPos posTmp : PositionUtils.getAdjacentPositions(pos, EnumFacing.UP, true)) {
                if (!this.func_130014_f_().func_175623_d(posTmp)) continue;
                this.func_70107_b((double)posTmp.func_177958_n() + 0.5, this.field_70163_u, (double)posTmp.func_177952_p() + 0.5);
                break;
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        Block block = null;
        int meta = nbt.func_74771_c("Data") & 0xF;
        if (nbt.func_150297_b("Block", 8)) {
            block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
            this.setBlockState(block.func_176203_a(meta));
        }
        this.fallTime = nbt.func_74762_e("Time");
        if (nbt.func_150297_b("HurtEntities", 1)) {
            this.hurtEntities = nbt.func_74767_n("HurtEntities");
            this.fallHurtAmount = nbt.func_74760_g("FallHurtAmount");
            this.fallHurtMax = nbt.func_74762_e("FallHurtMax");
        } else if (block == Blocks.field_150467_bQ) {
            this.hurtEntities = true;
        }
        if (nbt.func_150297_b("DropItem", 99)) {
            this.shouldDropItem = nbt.func_74767_n("DropItem");
        }
        if (nbt.func_150297_b("TileEntityData", 10)) {
            this.tileEntityData = nbt.func_74775_l("TileEntityData");
        }
        if (block == null || block.func_176223_P().func_185904_a() == Material.field_151579_a) {
            this.blockState = Blocks.field_150354_m.func_176223_P();
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        Block block = this.blockState != null ? this.blockState.func_177230_c() : Blocks.field_150350_a;
        ResourceLocation rl = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        compound.func_74778_a("Block", rl == null ? "" : rl.toString());
        compound.func_74774_a("Data", this.blockState != null ? (byte)block.func_176201_c(this.blockState) : (byte)0);
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74757_a("DropItem", this.shouldDropItem);
        compound.func_74757_a("HurtEntities", this.hurtEntities);
        compound.func_74776_a("FallHurtAmount", this.fallHurtAmount);
        compound.func_74768_a("FallHurtMax", this.fallHurtMax);
        if (this.tileEntityData != null) {
            compound.func_74782_a("TileEntityData", (NBTBase)this.tileEntityData);
        }
    }

    public boolean func_90999_ad() {
        return false;
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.func_184212_Q().func_187225_a(ORIGIN);
    }
}

