/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.model.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BakedModelCamouflageBlock
implements IBakedModel {
    public static final Map<BlockRenderLayer, Map<ImmutablePair<IBlockState, IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>>> QUAD_CACHE = new HashMap<BlockRenderLayer, Map<ImmutablePair<IBlockState, IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>>>();
    protected final IModel baseModel;
    @Nullable
    protected final IModel overlayModel;
    protected final IBakedModel bakedBaseModel;
    protected final IBakedModel bakedOverlayModel;
    protected final IModelState modelState;
    protected final VertexFormat format;
    protected final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    protected final ImmutableList<BakedQuad> itemQuads;

    public BakedModelCamouflageBlock(IModel baseModel, @Nullable IModel overlayModel, ImmutableMap<String, String> textures, IModelState modelState, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.baseModel = baseModel;
        this.overlayModel = overlayModel;
        this.modelState = modelState;
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        this.bakedBaseModel = baseModel.bake(modelState, format, bakedTextureGetter);
        this.bakedOverlayModel = overlayModel != null ? overlayModel.bake(modelState, format, bakedTextureGetter) : null;
        this.itemQuads = BakedModelCamouflageBlock.buildItemModel(this.bakedBaseModel, this.bakedOverlayModel);
    }

    public boolean func_177555_b() {
        return this.bakedBaseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedBaseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedBaseModel.func_188618_c();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedBaseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.bakedBaseModel.func_188617_f();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedBaseModel.func_177554_e();
    }

    public synchronized List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ImmutablePair key;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (state == null || layer == null) {
            return this.itemQuads;
        }
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        IBlockState camoState = (IBlockState)extendedState.getValue((IUnlistedProperty)BlockEnderUtilitiesTileEntity.CAMOBLOCKSTATE);
        IBlockState camoExtendedState = (IBlockState)extendedState.getValue((IUnlistedProperty)BlockEnderUtilitiesTileEntity.CAMOBLOCKSTATEEXTENDED);
        ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> quads = null;
        Map<ImmutablePair<IBlockState, IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>> map = QUAD_CACHE.get(layer);
        boolean validCamo = camoState != null && camoState.func_177230_c() != Blocks.field_150350_a;
        IBlockState stateClean = extendedState.getClean();
        if (map == null) {
            map = new HashMap<ImmutablePair<IBlockState, IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>>();
            QUAD_CACHE.put(layer, map);
        }
        if ((quads = map.get(key = validCamo ? ImmutablePair.of((Object)stateClean, (Object)camoState) : ImmutablePair.of((Object)stateClean, (Object)Blocks.field_150350_a.func_176223_P()))) == null) {
            IBakedModel bakedOverlayModel;
            IBakedModel iBakedModel = bakedOverlayModel = this.overlayModel != null ? this.overlayModel.bake(this.modelState, this.format, this.bakedTextureGetter) : null;
            if (validCamo) {
                IBakedModel bakedBaseModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(camoState);
                quads = this.getCombinedQuads(layer, bakedBaseModel, camoState, camoExtendedState, bakedOverlayModel, (IBlockState)extendedState, true);
            } else {
                IBakedModel bakedBaseModel = BakedModelCamouflageBlock.getRotatedBakedModel(this.baseModel, this.bakedBaseModel, state, this.format, this.bakedTextureGetter);
                quads = this.getCombinedQuads(layer, bakedBaseModel, stateClean, (IBlockState)extendedState, bakedOverlayModel, (IBlockState)extendedState, false);
            }
            map.put((ImmutablePair<IBlockState, IBlockState>)key, quads);
        }
        return (List)quads.get(Optional.ofNullable(side));
    }

    protected ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> getCombinedQuads(BlockRenderLayer layer, @Nonnull IBakedModel baseModel, @Nonnull IBlockState baseActualState, @Nonnull IBlockState baseExtendedState, @Nullable IBakedModel overlayModel, @Nullable IBlockState overlayState, boolean isCamoModel) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumFacing face : EnumFacing.values()) {
            ImmutableList.Builder quads = ImmutableList.builder();
            if ((isCamoModel || baseActualState.func_177230_c().func_180664_k() == layer) && baseActualState.func_177230_c().canRenderInLayer(baseActualState, layer)) {
                quads.addAll((Iterable)baseModel.func_188616_a(baseExtendedState, face, 0L));
            }
            if (overlayModel != null && overlayState != null && layer == BlockRenderLayer.CUTOUT) {
                quads.addAll((Iterable)overlayModel.func_188616_a(overlayState, face, 0L));
            }
            builder.put(Optional.of(face), (Object)quads.build());
        }
        ImmutableList.Builder quads = ImmutableList.builder();
        if ((isCamoModel || baseActualState.func_177230_c().func_180664_k() == layer) && baseActualState.func_177230_c().canRenderInLayer(baseActualState, layer)) {
            quads.addAll((Iterable)baseModel.func_188616_a(baseExtendedState, null, 0L));
        }
        if (overlayModel != null && overlayState != null && layer == BlockRenderLayer.CUTOUT) {
            quads.addAll((Iterable)overlayModel.func_188616_a(overlayState, null, 0L));
        }
        builder.put(Optional.empty(), (Object)quads.build());
        return builder.build();
    }

    public static ImmutableList<BakedQuad> buildItemModel(IBakedModel bakedBaseModel, @Nullable IBakedModel bakedOverlayModel) {
        ImmutableList.Builder quads = ImmutableList.builder();
        for (EnumFacing side : EnumFacing.values()) {
            quads.addAll((Iterable)bakedBaseModel.func_188616_a(null, side, 0L));
            if (bakedOverlayModel == null) continue;
            quads.addAll((Iterable)bakedOverlayModel.func_188616_a(null, side, 0L));
        }
        quads.addAll((Iterable)bakedBaseModel.func_188616_a(null, null, 0L));
        if (bakedOverlayModel != null) {
            quads.addAll((Iterable)bakedOverlayModel.func_188616_a(null, null, 0L));
        }
        return quads.build();
    }

    @Nullable
    public static IBakedModel getRotatedBakedModel(@Nullable IModel model, @Nullable IBakedModel bakedModelDefault, IBlockState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (model != null) {
            if (state.func_177227_a().contains(BlockEnderUtilities.FACING)) {
                return model.bake((IModelState)TRSRTransformation.from((EnumFacing)((EnumFacing)state.func_177229_b((IProperty)BlockEnderUtilities.FACING))), format, bakedTextureGetter);
            }
            if (state.func_177227_a().contains(BlockEnderUtilities.FACING_H)) {
                return model.bake((IModelState)TRSRTransformation.from((EnumFacing)((EnumFacing)state.func_177229_b((IProperty)BlockEnderUtilities.FACING_H))), format, bakedTextureGetter);
            }
        }
        return bakedModelDefault;
    }

    static {
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            QUAD_CACHE.put(layer, new HashMap());
        }
    }
}

