/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPhasing
extends BlockEnderUtilities {
    public static final PropertyBool INVERTED = PropertyBool.func_177716_a((String)"inverted");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockPhasing(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INVERTED, POWERED});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"phasing", "phasing_inverted"};
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.func_189540_a(state, worldIn, pos, this, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean powered;
        if (!worldIn.field_72995_K && (powered = worldIn.func_175640_z(pos)) != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)INVERTED) != false ? 1 : 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)INVERTED) != false ? 1 : 0) | ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149637_q(state);
    }

    public boolean func_185481_k(IBlockState state) {
        return this.func_149637_q(state);
    }

    public boolean func_149730_j(IBlockState state) {
        return this.func_149637_q(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149637_q(state);
    }

    public boolean func_149637_q(IBlockState state) {
        return state.func_177229_b((IProperty)POWERED) == state.func_177229_b((IProperty)INVERTED);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149637_q(state);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return !this.func_149637_q(worldIn.func_180495_p(pos));
    }

    public boolean func_176214_u(IBlockState state) {
        return this.func_149637_q(state);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        boolean phased = !this.func_149637_q(state);
        return phased && layer == BlockRenderLayer.TRANSLUCENT || !phased && layer == BlockRenderLayer.SOLID;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149637_q(state) ? 255 : 0;
    }

    public boolean func_149751_l(IBlockState state) {
        return !this.func_149637_q(state);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)INVERTED) != false ? MapColor.field_193562_N : MapColor.field_193568_T;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState stateAdjacent = blockAccess.func_180495_p(pos.func_177972_a(side));
        if (state != stateAdjacent) {
            return true;
        }
        if (stateAdjacent.func_177230_c() == this) {
            return false;
        }
        return super.func_176225_a(state, blockAccess, pos, side);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177229_b((IProperty)POWERED) == state.func_177229_b((IProperty)INVERTED) ? field_185505_j : field_185506_k;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }
}

