/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnergyBridge
extends BlockEnderUtilitiesTileEntity {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnum<BridgeType> TYPE = PropertyEnum.func_177709_a((String)"type", BridgeType.class);

    public BlockEnergyBridge(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING_H, (Comparable)BlockEnderUtilities.DEFAULT_FACING).func_177226_a(TYPE, (Comparable)((Object)BridgeType.RESONATOR)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, FACING_H, TYPE});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{BridgeType.RESONATOR.func_176610_l(), BridgeType.RECEIVER.func_176610_l(), BridgeType.TRANSMITTER.func_176610_l()};
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        TileEntityEnergyBridge te = new TileEntityEnergyBridge();
        te.setType(((BridgeType)((Object)state.func_177229_b(TYPE))).getMeta());
        return te;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityEnergyBridge te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = BlockEnergyBridge.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnergyBridge.class)) != null) {
            te.tryAssembleMultiBlock();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityEnergyBridge te;
        if (!world.field_72995_K && (te = BlockEnergyBridge.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnergyBridge.class)) != null) {
            te.disassembleMultiblock();
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BridgeType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((BridgeType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntityEnergyBridge te = BlockEnergyBridge.getTileEntitySafely(world, pos, TileEntityEnergyBridge.class);
        if (te != null) {
            state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(te.getIsActive()));
        }
        return state;
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 15;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < BridgeType.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, BridgeType.values()[i].getMeta()));
        }
    }

    public static enum BridgeType implements IStringSerializable
    {
        RESONATOR(0, "energy_bridge_resonator"),
        RECEIVER(1, "energy_bridge_receiver"),
        TRANSMITTER(2, "energy_bridge_transmitter");

        private final String name;
        private final int meta;

        private BridgeType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static BridgeType fromMeta(int meta) {
            return meta < BridgeType.values().length ? BridgeType.values()[meta] : RESONATOR;
        }
    }
}

