/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import fi.dy.masa.enderutilities.capabilities.EnderUtilitiesCapabilities;
import fi.dy.masa.enderutilities.capabilities.IPortalCooldownCapability;
import fi.dy.masa.enderutilities.effects.Effects;
import fi.dy.masa.enderutilities.event.TickHandler;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortal;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockEnderUtilitiesPortal
extends BlockEnderUtilitiesTileEntity {
    protected static final AxisAlignedBB PORTAL_BOUNDS_NS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB PORTAL_BOUNDS_WE = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB PORTAL_BOUNDS_UD = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);

    public BlockEnderUtilitiesPortal(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.propFacing = FACING;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)BlockEnderUtilities.DEFAULT_FACING));
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149722_s();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{this.blockName};
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        return new TileEntityPortal();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k()) {
            case X: {
                return PORTAL_BOUNDS_WE;
            }
            case Z: {
                return PORTAL_BOUNDS_NS;
            }
        }
        return PORTAL_BOUNDS_UD;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return side == facing || side == facing.func_176734_d();
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        Effects.spawnParticlesAround(worldIn, EnumParticleTypes.PORTAL, pos, 2, rand);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            if (entityIn instanceof EntityPlayer) {
                TickHandler.instance().addPlayerToTeleport((EntityPlayer)entityIn);
            } else {
                this.teleportEntity(worldIn, pos, state, entityIn);
            }
        }
    }

    public void teleportEntity(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityPortal te;
        if (!world.field_72995_K && (te = BlockEnderUtilitiesPortal.getTileEntitySafely((IBlockAccess)world, pos, TileEntityPortal.class)) != null && te.getDestination() != null && entity.func_174813_aQ().func_72326_a(state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos))) {
            OwnerData ownerData;
            long currentTime = world.func_82737_E();
            if (!this.isEntityUnderPortalCooldown(entity, currentTime, 10) && ((ownerData = te.getOwner()) == null || ownerData.canAccess(entity))) {
                WorldServer worldDst;
                TargetData target = te.getDestination();
                if (te.targetIsPortal() && ((worldDst = entity.func_184102_h().func_71218_a(target.dimension)) == null || worldDst.func_180495_p(target.pos).func_177230_c() != EnderUtilitiesBlocks.PORTAL)) {
                    return;
                }
                entity = TeleportEntity.teleportEntityUsingTarget(entity, target, false, true, true);
            }
            if (entity != null) {
                this.updatePortalCooldown(entity, currentTime);
            }
        }
    }

    private boolean isEntityUnderPortalCooldown(Entity entity, long currentTime, int cooldown) {
        IPortalCooldownCapability cap = (IPortalCooldownCapability)entity.getCapability(EnderUtilitiesCapabilities.CAPABILITY_PORTAL_COOLDOWN, null);
        return cap != null && currentTime - cap.getLastInPortalTime() < (long)cooldown;
    }

    private void updatePortalCooldown(Entity entity, long currentTime) {
        IPortalCooldownCapability cap = (IPortalCooldownCapability)entity.getCapability(EnderUtilitiesCapabilities.CAPABILITY_PORTAL_COOLDOWN, null);
        if (cap != null) {
            cap.setLastInPortalTime(currentTime);
        }
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && !this.checkCanStayAndScheduleBreaking(worldIn, pos, state)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 0.2f, 0.8f);
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.checkCanStayAndScheduleBreaking(worldIn, pos, state)) {
            worldIn.func_180497_b(pos, (Block)this, 0, 0);
        }
    }

    private boolean checkCanStayAndScheduleBreaking(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos[] positions = PositionUtils.getAdjacentPositions(pos, facing, false);
        boolean canStay = true;
        for (BlockPos posTmp : positions) {
            Block block = world.func_180495_p(posTmp).func_177230_c();
            if (block == this || block == EnderUtilitiesBlocks.PORTAL_FRAME) continue;
            for (BlockPos posTmp2 : positions) {
                block = world.func_180495_p(posTmp2).func_177230_c();
                if (block != this) continue;
                world.func_180497_b(posTmp2, block, 0, 0);
            }
            canStay = false;
            break;
        }
        return canStay;
    }
}

