/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.wailastages;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="wailastages", name="Waila Stages", version="2.0.23", dependencies="required-after:bookshelf;required-after:waila;required-after:gamestages@[2.0.89,);required-after:crafttweaker", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class WailaStages {
    public static final LoggingHelper LOG = new LoggingHelper("Waila Stages");
    public static List<String> requiredStages = new ArrayList<String>();
    public static Multimap<String, String> prefixes = HashMultimap.create();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void preTooltipRender(WailaRenderEvent.Pre event) {
        if (!requiredStages.isEmpty() && !GameStageHelper.clientHasAnyOf((EntityPlayer)PlayerUtils.getClientPlayer(), requiredStages)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void getTooltipText(WailaTooltipEvent event) {
        for (String stage : prefixes.keySet()) {
            if (GameStageHelper.clientHasStage((EntityPlayer)PlayerUtils.getClientPlayer(), (String)stage)) continue;
            Iterator iterator = event.getCurrentTip().iterator();
            block1: while (iterator.hasNext()) {
                String line = (String)iterator.next();
                for (String regex : prefixes.get((Object)stage)) {
                    if (!line.startsWith(regex)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
    }
}

